/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.pkix.cmc.OtherInfo;

public class CMCStatusInfo
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private INTEGER status;
    private SEQUENCE bodyList;
    private UTF8String statusString;
    private OtherInfo otherInfo;
    public static final int SUCCESS = 0;
    public static final int RESERVED = 1;
    public static final int FAILED = 2;
    public static final int PENDING = 3;
    public static final int NOSUPPORT = 4;
    public static final int CONFIRM_REQUIRED = 5;
    public static final String[] STATUS = new String[]{"success", "reserved", "failed", "pending", "not supported", "confirm required"};
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CMCStatusInfo(int status, SEQUENCE bodyList) {
        this.status = new INTEGER(status);
        this.bodyList = bodyList;
        this.statusString = null;
        this.otherInfo = null;
    }

    public CMCStatusInfo(int status, SEQUENCE bodyList, String statusString, OtherInfo otherInfo) {
        this.status = new INTEGER(status);
        this.bodyList = bodyList;
        if (statusString != null) {
            try {
                this.statusString = new UTF8String(statusString);
            }
            catch (Exception exception) {}
        } else {
            this.statusString = null;
        }
        this.otherInfo = otherInfo;
    }

    public CMCStatusInfo(INTEGER status, SEQUENCE bodyList, UTF8String statusString, OtherInfo otherInfo) {
        this.status = status;
        this.bodyList = bodyList;
        this.statusString = statusString;
        this.otherInfo = otherInfo;
    }

    public void setStatusString(String statusString) {
        if (statusString != null) {
            try {
                this.statusString = new UTF8String(statusString);
            }
            catch (Exception exception) {}
        } else {
            this.statusString = null;
        }
    }

    public void addBodyPartID(int id) {
        INTEGER id1 = new INTEGER(id);
        assert (id1.compareTo(BODYIDMAX) <= 0);
        this.bodyList.addElement(id1);
    }

    public int getStatus() {
        return this.status.intValue();
    }

    public SEQUENCE getBodyList() {
        return this.bodyList;
    }

    public String getStatusString() {
        if (this.statusString != null) {
            return this.statusString.toString();
        }
        return null;
    }

    public OtherInfo getOtherInfo() {
        return this.otherInfo;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.status);
        seq.addElement(this.bodyList);
        if (this.statusString != null) {
            seq.addElement(this.statusString);
        }
        if (this.otherInfo != null) {
            seq.addElement(this.otherInfo);
        }
        seq.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SEQUENCE.OF_Template(INTEGER.getTemplate()));
            this.seqt.addOptionalElement(UTF8String.getTemplate());
            this.seqt.addOptionalElement(OtherInfo.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new CMCStatusInfo((INTEGER)seq.elementAt(0), (SEQUENCE)seq.elementAt(1), (UTF8String)seq.elementAt(2), (OtherInfo)seq.elementAt(3));
        }
    }
}

