/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class PopLinkWitnessV2
implements ASN1Value {
    private AlgorithmIdentifier keyGenAlgorithm;
    private AlgorithmIdentifier macAlgorithm;
    private OCTET_STRING witness;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AlgorithmIdentifier getKeyGenAlgorithm() {
        return this.keyGenAlgorithm;
    }

    public AlgorithmIdentifier getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public OCTET_STRING getWitness() {
        return this.witness;
    }

    public PopLinkWitnessV2(AlgorithmIdentifier keyGenAlgorithm, AlgorithmIdentifier macAlgorithm, OCTET_STRING witness) {
        if (keyGenAlgorithm == null || macAlgorithm == null || witness == null) {
            throw new IllegalArgumentException("PopLinkWitnessV2 constructor parameter is null");
        }
        this.keyGenAlgorithm = keyGenAlgorithm;
        this.macAlgorithm = macAlgorithm;
        this.witness = witness;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(keyGenAlgorithm);
        this.sequence.addElement(macAlgorithm);
        this.sequence.addElement(witness);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new PopLinkWitnessV2((AlgorithmIdentifier)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2));
        }
    }
}

