/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.crypto.Policy;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.nss.PR;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.nss.SSL;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.nss.SecurityStatusResult;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.mozilla.jss.provider.javax.crypto.JSSTrustManager;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.mozilla.jss.ssl.SSLVersion;
import org.mozilla.jss.ssl.SSLVersionRange;
import org.mozilla.jss.ssl.javax.JSSParameters;
import org.mozilla.jss.ssl.javax.JSSSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JSSEngine
extends SSLEngine {
    public static Logger logger = LoggerFactory.getLogger(JSSEngine.class);
    protected static int BUFFER_SIZE = 18713;
    protected boolean as_server;
    protected String hostname;
    protected String certAlias;
    protected PK11Cert cert;
    protected PK11PrivKey key;
    protected X509KeyManager[] key_managers;
    protected X509TrustManager[] trust_managers;
    protected boolean need_client_auth;
    protected boolean want_client_auth;
    protected SSLEngineResult.HandshakeStatus handshake_state = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected SSLCipher[] enabled_ciphers;
    protected SSLVersion min_protocol;
    protected SSLVersion max_protocol;
    protected JSSSession session;
    protected SSLFDProxy ssl_fd;
    protected boolean is_outbound_closed;
    protected boolean is_inbound_closed;
    protected HashMap<Integer, Integer> config;
    protected static HashMap<PK11Cert, SSLFDProxy> serverTemplates = new HashMap();
    private static final AtomicBoolean sessionCacheInitialized = new AtomicBoolean();
    private Collection<? extends EventListener> listeners = new ArrayList<EventListener>();

    public JSSEngine() {
        this.session = new JSSSession(this, BUFFER_SIZE);
        this.config = this.getDefaultConfiguration();
    }

    public JSSEngine(String peerHost, int peerPort) {
        super(peerHost, peerPort);
        this.session = new JSSSession(this, BUFFER_SIZE);
        this.session.setPeerHost(peerHost);
        this.session.setPeerPort(peerPort);
        this.config = this.getDefaultConfiguration();
    }

    public JSSEngine(String peerHost, int peerPort, X509Certificate localCert, PrivateKey localKey) {
        super(peerHost, peerPort);
        this.cert = (PK11Cert)localCert;
        this.key = (PK11PrivKey)localKey;
        this.session = new JSSSession(this, BUFFER_SIZE);
        this.session.setPeerHost(peerHost);
        this.session.setPeerPort(peerPort);
        this.config = this.getDefaultConfiguration();
    }

    protected static String errorText(int error) {
        String error_name = PR.ErrorToName(error);
        String error_text = PR.GetErrorText();
        if (error == 0) {
            return "NO ERROR";
        }
        if (error_name.isEmpty()) {
            return "UNKNOWN (" + error + ")";
        }
        if (error_text.isEmpty()) {
            return error_name + " (" + error + ")";
        }
        return error_name + " (" + error + "): " + error_text;
    }

    public static void initializeSessionCache(int maxCacheEntries, long timeout, String directory) throws SSLException {
        if (sessionCacheInitialized.compareAndSet(false, true) && SSL.ConfigServerSessionIDCache(maxCacheEntries, timeout, timeout, directory) == SSL.SECFailure) {
            Object msg = "Unable to configure server session cache: ";
            msg = (String)msg + JSSEngine.errorText(PR.GetError());
            throw new SSLException((String)msg);
        }
    }

    public SSLFDProxy getSSLFDProxy() {
        return this.ssl_fd;
    }

    @Override
    public JSSParameters getSSLParameters() {
        JSSParameters ret = new JSSParameters();
        ret.setCipherSuites(this.getEnabledCipherSuites());
        ret.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            ret.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            ret.setWantClientAuth(true);
        }
        ret.setAlias(this.certAlias);
        ret.setHostname(this.hostname);
        ret.setListeners(this.listeners);
        return ret;
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        JSSParameters parsed = params instanceof JSSParameters ? (JSSParameters)params : new JSSParameters(params);
        if (parsed.getSSLCiphers() != null) {
            this.setEnabledCipherSuites(parsed.getSSLCiphers());
        }
        if (parsed.getSSLVersionRange() != null) {
            this.setEnabledProtocols(parsed.getSSLVersionRange());
        }
        this.setWantClientAuth(parsed.getWantClientAuth());
        this.setNeedClientAuth(parsed.getNeedClientAuth());
        if (parsed.getAlias() != null && this.key_managers != null && this.key_managers.length > 0 && this.cert == null && this.key == null) {
            this.setCertFromAlias(parsed.getAlias());
        }
        if (parsed.getHostname() != null) {
            this.setHostname(parsed.getHostname());
        }
        if (parsed.getListeners() != null) {
            this.setListeners(parsed.getListeners());
        }
    }

    public void setHostname(String name) {
        this.hostname = name;
    }

    public void setCertFromAlias(String alias) throws IllegalArgumentException {
        if (alias == null) {
            this.certAlias = null;
            this.cert = null;
            this.key = null;
            return;
        }
        this.certAlias = alias;
        if (this.key_managers == null || this.key_managers.length == 0) {
            String string2 = "Missing or null KeyManagers; refusing to search ";
            string2 = string2 + "for cert";
            throw new IllegalArgumentException(string2);
        }
        for (X509KeyManager key_manager : this.key_managers) {
            if (key_manager == null || !(key_manager instanceof JSSKeyManager)) continue;
            JSSKeyManager jkm = (JSSKeyManager)key_manager;
            this.cert = (PK11Cert)jkm.getCertificate(alias);
            this.key = (PK11PrivKey)jkm.getPrivateKey(alias);
            if (this.cert != null && this.key != null) break;
        }
        if (this.cert == null && this.key == null) {
            String string3 = "JSSEngine.setCertFromAlias: Unable to find ";
            string3 = string3 + "certificate and key for specified alias!";
            throw new IllegalArgumentException(string3);
        }
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) throws IllegalArgumentException {
        JSSParameters parser = new JSSParameters();
        parser.setCipherSuites(suites);
        this.setEnabledCipherSuites(parser.getSSLCiphers());
    }

    public void setEnabledCipherSuites(SSLCipher[] suites) throws IllegalArgumentException {
        if (this.ssl_fd != null) {
            Object msg = "Unable to process setEnabledCipherSuites(...) ";
            msg = (String)msg + "after handshake has started!";
            throw new IllegalArgumentException((String)msg);
        }
        if (suites == null || suites.length == 0) {
            this.enabled_ciphers = null;
            logger.warn("JSSEngine.setEnabledCipherSuites(...) given a null list of cipher suites.");
            return;
        }
        ArrayList<SSLCipher> supportedCiphers = new ArrayList<SSLCipher>();
        for (SSLCipher suite : suites) {
            if (!suite.isSupported()) continue;
            supportedCiphers.add(suite);
        }
        if (supportedCiphers.size() == 0) {
            this.enabled_ciphers = null;
            logger.warn("JSSEngine.setEnabledCipherSuites(...) given a list of cipher suites where none were supported or approved.");
            return;
        }
        this.enabled_ciphers = supportedCiphers.toArray(new SSLCipher[supportedCiphers.size()]);
    }

    public static SSLCipher[] queryEnabledCipherSuites() {
        logger.debug("JSSEngine: queryEnabledCipherSuites()");
        ArrayList<SSLCipher> enabledCiphers = new ArrayList<SSLCipher>();
        for (SSLCipher cipher : SSLCipher.values()) {
            try {
                if (!cipher.isSupported() || !SSL.CipherPrefGetDefault(cipher.getID())) continue;
                logger.debug("Enabled: " + cipher.name() + " (" + cipher.getID() + ")");
                enabledCiphers.add(cipher);
            }
            catch (Exception e) {
                logger.warn("Unable to get default preference for cipher {}: {}", (Object)cipher.name(), (Object)e.getMessage());
            }
        }
        return enabledCiphers.toArray(new SSLCipher[0]);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        logger.debug("JSSEngine: getEnabledCipherSuites()");
        if (this.enabled_ciphers == null) {
            this.enabled_ciphers = JSSEngine.queryEnabledCipherSuites();
        }
        JSSParameters parser = new JSSParameters();
        parser.setCipherSuites(this.enabled_ciphers);
        return parser.getCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        logger.debug("JSSEngine: getSupportedCipherSuites()");
        ArrayList<String> result = new ArrayList<String>();
        for (SSLCipher c : SSLCipher.values()) {
            if (!c.isSupported()) continue;
            logger.debug("JSSEngine: getSupportedCipherSuites() - Supported: " + c);
            result.add(c.name());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) throws IllegalArgumentException {
        logger.debug("JSSEngine: setEnabledProtocols(");
        for (String protocol : protocols) {
            logger.debug("\t" + protocol + ",");
        }
        logger.debug(")");
        JSSParameters parser = new JSSParameters();
        parser.setProtocols(protocols);
        SSLVersionRange vrange = parser.getSSLVersionRange();
        this.setEnabledProtocols(vrange);
    }

    public void setEnabledProtocols(SSLVersion min, SSLVersion max) throws IllegalArgumentException {
        logger.debug("JSSEngine: setEnabledProtocols()");
        if (this.min_protocol == null && this.max_protocol != null || this.min_protocol != null && this.max_protocol == null) {
            throw new IllegalArgumentException("Expected min and max to either both be null or both be not-null; not mixed: (" + min + ", " + max + ")");
        }
        if (max == null && min == null) {
            this.min_protocol = null;
            this.max_protocol = null;
            return;
        }
        this.setEnabledProtocols(new SSLVersionRange(min, max));
    }

    public void setEnabledProtocols(SSLVersionRange vrange) {
        logger.debug("JSSEngine: setEnabledProtocols()");
        if (vrange == null) {
            this.min_protocol = null;
            this.max_protocol = null;
            return;
        }
        if (this.ssl_fd != null) {
            Object msg = "Unable to process setEnabledProtocols(...) after ";
            msg = (String)msg + "handshake has started!";
            throw new IllegalArgumentException((String)msg);
        }
        SSLVersionRange bounded = vrange.boundBy(Policy.TLS_VERSION_RANGE);
        this.min_protocol = bounded.getMinVersion();
        this.max_protocol = bounded.getMaxVersion();
    }

    public static SSLVersionRange queryEnabledProtocols() {
        SSLVersionRange vrange;
        logger.debug("JSSEngine: queryEnabledProtocols()");
        try {
            vrange = SSL.VersionRangeGetDefault();
        }
        catch (Exception e) {
            throw new RuntimeException("JSSEngine.queryEnabledProtocols() Unexpected failure: " + e.getMessage(), e);
        }
        if (vrange == null) {
            throw new RuntimeException("JSSEngine.queryEnabledProtocols() - null protocol range");
        }
        return vrange.boundBy(Policy.TLS_VERSION_RANGE);
    }

    @Override
    public String[] getEnabledProtocols() {
        logger.debug("JSSEngine: getEnabledProtocols()");
        if (this.min_protocol == null || this.max_protocol == null) {
            SSLVersionRange vrange = JSSEngine.queryEnabledProtocols();
            this.min_protocol = vrange.getMinVersion();
            this.max_protocol = vrange.getMaxVersion();
        }
        JSSParameters parser = new JSSParameters();
        parser.setProtocols(this.min_protocol, this.max_protocol);
        return parser.getProtocols();
    }

    @Override
    public String[] getSupportedProtocols() {
        logger.debug("JSSEngine: getSupportedProtocols()");
        ArrayList<String> result = new ArrayList<String>();
        for (SSLVersion v : Policy.TLS_VERSION_RANGE.getAllInRange()) {
            logger.debug("JSSEngine: getSupportedProtocol - Supported: " + v);
            result.add(v.jdkAlias());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setKeyMaterials(PK11Cert our_cert, PK11PrivKey our_key) throws IllegalArgumentException {
        logger.debug("JSSEngine: setKeyMaterials()");
        if (our_cert == null && our_key != null || our_cert != null && our_key == null) {
            throw new IllegalArgumentException("JSSEngine.setKeyMaterials(): Either both cert and key must be null or both must be not-null");
        }
        this.cert = our_cert;
        this.key = our_key;
    }

    public void setKeyManager(X509KeyManager km) {
        if (km == null) {
            logger.debug("JSSEngine: setKeyManager(null)");
            return;
        }
        logger.debug("JSSEngine: setKeyManager(" + km.getClass().getName() + ")");
        this.key_managers = new X509KeyManager[]{km};
    }

    public void setKeyManagers(X509KeyManager[] xkms) {
        if (xkms == null) {
            logger.debug("JSSEngine: setKeyManagers([null])");
            return;
        }
        logger.debug("JSSEngine: setKeyManagers(");
        for (X509KeyManager km : xkms) {
            logger.debug(" - " + km.getClass().getName());
        }
        logger.debug(")");
        this.key_managers = xkms;
    }

    public void setTrustManager(JSSTrustManager tm) {
        if (tm == null) {
            logger.debug("JSSEngine: setTrustManager(null)");
            return;
        }
        logger.debug("JSSEngine: setTrustManager(" + tm.getClass().getName() + ")");
        this.trust_managers = new X509TrustManager[]{tm};
    }

    public void setTrustManagers(X509TrustManager[] xtms) {
        if (xtms == null) {
            logger.debug("JSSEngine: setKeyManagers([null])");
            return;
        }
        logger.debug("JSSEngine: setTrustManagers(");
        for (X509TrustManager tm : xtms) {
            logger.debug(" - " + tm.getClass().getName());
        }
        logger.debug(")");
        this.trust_managers = xtms;
    }

    @Override
    public JSSSession getSession() {
        logger.debug("JSSEngine: getSession()");
        return this.session;
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        logger.debug("JSSEngine: setEnableSessionCreation(" + flag + ") - not implemented");
        if (!flag) {
            String msg = "JSSEngine does not support restricting to only resuming existing sessions.";
            throw new RuntimeException(msg);
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        logger.debug("JSSEngine: getEnableSessionCreation() - not implemented");
        return true;
    }

    @Override
    public void setUseClientMode(boolean mode) throws IllegalArgumentException {
        logger.debug("JSSEngine.setUseClientMode(" + mode + ")");
        if (this.ssl_fd != null) {
            String msg = "Unable to process setUseClientMode(" + mode + ") ";
            msg = msg + "after handshake has started!";
            throw new IllegalArgumentException(msg);
        }
        this.as_server = !mode;
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        logger.debug("JSSEngine.setNeedClientAuth(" + need + ")");
        this.need_client_auth = need;
        this.reconfigureClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        logger.debug("JSSEngine.setWantClientAuth(" + want + ")");
        this.want_client_auth = want;
        this.reconfigureClientAuth();
    }

    protected abstract void reconfigureClientAuth();

    @Override
    public boolean getUseClientMode() {
        return !this.as_server;
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.need_client_auth;
    }

    @Override
    public boolean getWantClientAuth() {
        return this.want_client_auth;
    }

    public void setListeners(Collection<? extends EventListener> new_listeners) {
        this.listeners = new_listeners;
    }

    public Collection<? extends EventListener> getListeners() {
        return this.listeners;
    }

    protected void fireAlertReceived(SSLAlertEvent event) {
        if (this.listeners != null) {
            for (EventListener eventListener : this.listeners) {
                if (!(eventListener instanceof SSLSocketListener)) continue;
                SSLSocketListener socket_listener = (SSLSocketListener)eventListener;
                socket_listener.alertReceived(event);
            }
        }
    }

    protected void fireAlertSent(SSLAlertEvent event) {
        if (this.listeners != null) {
            for (EventListener eventListener : this.listeners) {
                if (!(eventListener instanceof SSLSocketListener)) continue;
                SSLSocketListener socket_listener = (SSLSocketListener)eventListener;
                socket_listener.alertSent(event);
            }
        }
    }

    protected void fireHandshakeComplete(SSLHandshakeCompletedEvent event) {
        if (this.listeners != null) {
            for (EventListener eventListener : this.listeners) {
                if (!(eventListener instanceof SSLHandshakeCompletedListener)) continue;
                SSLHandshakeCompletedListener handshake_listener = (SSLHandshakeCompletedListener)eventListener;
                handshake_listener.handshakeCompleted(event);
            }
        }
    }

    @Override
    public boolean isInboundDone() {
        logger.debug("JSSEngine.isInboundDone()? " + this.is_inbound_closed);
        return this.is_inbound_closed;
    }

    @Override
    public boolean isOutboundDone() {
        logger.debug("JSSEngine.isOutboundDone()? " + this.is_outbound_closed);
        return this.is_outbound_closed;
    }

    public abstract SecurityStatusResult getStatus();

    public HashMap<Integer, Integer> getDefaultConfiguration() {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        result.put(SSL.ENABLE_POST_HANDSHAKE_AUTH, 1);
        result.put(SSL.ENABLE_RENEGOTIATION, SSL.RENEGOTIATE_REQUIRES_XTN);
        result.put(SSL.REQUIRE_SAFE_NEGOTIATION, 1);
        return result;
    }

    public void addConfiguration(int key, int value) {
        this.config.put(key, value);
    }

    public void removeConfiguration(int key) {
        this.config.remove(key);
    }

    public void setConfiguration(HashMap<Integer, Integer> config) {
        this.config = config;
    }

    protected static SSLFDProxy getServerTemplate(PK11Cert cert, PK11PrivKey key) {
        if (cert == null || key == null) {
            return null;
        }
        SSLFDProxy fd = serverTemplates.get(cert);
        if (fd == null) {
            PRFDProxy base = PR.NewTCPSocket();
            fd = SSL.ImportFD(null, base);
            if (SSL.ConfigServerCert(fd, cert, key) != SSL.SECSuccess) {
                Object msg = "Unable to configure certificate and key on ";
                msg = (String)msg + "model SSL PRFileDesc proxy: ";
                msg = (String)msg + JSSEngine.errorText(PR.GetError());
                throw new RuntimeException((String)msg);
            }
            serverTemplates.put(cert, fd);
        }
        return fd;
    }

    public abstract void tryCleanup();

    public abstract void cleanup();
}

