/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class TestPKCS11Constants {
    public static void main(String[] args) throws Exception {
        Class<?> jss = Class.forName("org.mozilla.jss.pkcs11.PKCS11Constants");
        Class<?> sun = Class.forName("sun.security.pkcs11.wrapper.PKCS11Constants");
        assert (!jss.equals(sun));
        Field[] jss_fields = jss.getDeclaredFields();
        Field[] sun_fields = sun.getDeclaredFields();
        HashMap<String, Field> jss_map = new HashMap<String, Field>();
        HashMap<String, Field> sun_map = new HashMap<String, Field>();
        HashSet<String> keys = new HashSet<String>();
        for (Field field : jss_fields) {
            jss_map.put(field.getName(), field);
            keys.add(field.getName());
        }
        for (Field field : sun_fields) {
            sun_map.put(field.getName(), field);
            keys.add(field.getName());
        }
        Object[] keys_sorted = new String[keys.size()];
        keys_sorted = keys.toArray(keys_sorted);
        Arrays.sort(keys_sorted);
        for (Object key : keys_sorted) {
            if (jss_map.containsKey(key) && sun_map.containsKey(key)) {
                Field jss_field = (Field)jss_map.get(key);
                Field sun_field = (Field)sun_map.get(key);
                assert (jss_field.getType() == Long.TYPE);
                assert (sun_field.getType() == Long.TYPE);
                if (jss_field.getLong(null) != sun_field.getLong(null)) {
                    System.err.println("Symbol: " + (String)key + " - NOT OK!!\n");
                    System.err.println("\tJSS: " + jss_field.getLong(null));
                    System.err.println("\tSun: " + sun_field.getLong(null));
                }
                assert (jss_field.getLong(null) == sun_field.getLong(null));
                System.out.println("Field: " + (String)key + " - OK");
                continue;
            }
            if (jss_map.containsKey(key)) {
                System.err.println("Field: " + (String)key + " - only JSS");
                continue;
            }
            if (!sun_map.containsKey(key)) continue;
            System.err.println("Field: " + (String)key + " - only Sun");
        }
    }
}

