/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.IOException;
import org.mozilla.jss.netscape.security.pkcs.ParsingException;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class ContentInfo {
    private static int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};
    private static int[] data = new int[]{1, 2, 840, 113549, 1, 7, 1};
    private static int[] sdata = new int[]{1, 2, 840, 113549, 1, 7, 2};
    private static int[] edata = new int[]{1, 2, 840, 113549, 1, 7, 3};
    private static int[] sedata = new int[]{1, 2, 840, 113549, 1, 7, 4};
    private static int[] ddata = new int[]{1, 2, 840, 113549, 1, 7, 5};
    private static int[] crdata = new int[]{1, 2, 840, 113549, 1, 7, 6};
    public static final ObjectIdentifier PKCS7_OID = new ObjectIdentifier(pkcs7);
    public static final ObjectIdentifier DATA_OID = new ObjectIdentifier(data);
    public static final ObjectIdentifier SIGNED_DATA_OID = new ObjectIdentifier(sdata);
    public static final ObjectIdentifier ENVELOPED_DATA_OID = new ObjectIdentifier(edata);
    public static final ObjectIdentifier SIGNED_AND_ENVELOPED_DATA_OID = new ObjectIdentifier(sedata);
    public static final ObjectIdentifier DIGESTED_DATA_OID = new ObjectIdentifier(ddata);
    public static final ObjectIdentifier ENCRYPTED_DATA_OID = new ObjectIdentifier(crdata);
    ObjectIdentifier contentType;
    DerValue content;

    public ContentInfo(ObjectIdentifier contentType, DerValue content) {
        this.contentType = contentType;
        this.content = content;
    }

    public ContentInfo(byte[] bytes) {
        this.contentType = DATA_OID;
        if (bytes != null && bytes.length > 0) {
            DerValue octetString;
            this.content = octetString = new DerValue(4, bytes);
        }
    }

    public ContentInfo(DerInputStream derin) throws IOException, ParsingException {
        DerValue[] typeAndContent = derin.getSequence(2);
        DerValue type = typeAndContent[0];
        DerInputStream disType = new DerInputStream(type.toByteArray());
        this.contentType = disType.getOID();
        if (typeAndContent.length > 1) {
            DerValue taggedContent = typeAndContent[1];
            DerInputStream disTaggedContent = new DerInputStream(taggedContent.toByteArray());
            DerValue[] contents = disTaggedContent.getSet(1, true);
            this.content = contents[0];
        }
    }

    public DerValue getContent() {
        return this.content;
    }

    public byte[] getData() throws IOException {
        if (this.contentType.equals(DATA_OID)) {
            return this.content != null ? this.content.getOctetString() : new byte[]{};
        }
        throw new IOException("content type is not DATA: " + this.contentType);
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream seq = new DerOutputStream();
        seq.putOID(this.contentType);
        if (this.content != null) {
            DerOutputStream contentDerCode = new DerOutputStream();
            this.content.encode(contentDerCode);
            DerValue taggedContent = new DerValue(-96, contentDerCode.toByteArray());
            seq.putDerValue(taggedContent);
        }
        out.write((byte)48, seq);
    }

    public byte[] getContentBytes() throws IOException {
        if (this.content == null) {
            return new byte[0];
        }
        DerInputStream dis = new DerInputStream(this.content.toByteArray());
        return dis.getOctetString();
    }

    public String toString() {
        Object out = "";
        out = (String)out + "Content Info Sequence\n\tContent type: " + this.contentType + "\n";
        if (this.content != null) {
            out = (String)out + "\tContent: " + this.content;
        }
        return out;
    }
}

