/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import org.mozilla.jss.netscape.security.pkcs.PKCS9Attribute;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.ACertAttrSet;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extensions;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class PKCS10Attribute
implements DerEncoder,
Serializable {
    private static final long serialVersionUID = 2002480042340316170L;
    protected ObjectIdentifier attributeId = null;
    protected CertAttrSet attributeValue = null;

    public PKCS10Attribute() {
    }

    public PKCS10Attribute(DerValue derVal) throws IOException {
        if (derVal.tag != 48) {
            throw new IOException("Sequence tag missing for PKCS10Attribute.");
        }
        DerInputStream in = derVal.toDerInputStream();
        this.attributeId = in.getOID();
        DerValue[] inAttrValues = in.getSet(1);
        int attrValueNum = inAttrValues.length;
        if (attrValueNum > 1) {
            throw new IOException("More than one value per attribute not supported");
        }
        DerValue inAttrValue = inAttrValues[0];
        if (this.attributeId.equals(PKCS9Attribute.EXTENSION_REQUEST_OID)) {
            try {
                DerInputStream fi = new DerInputStream(inAttrValue.toByteArray());
                this.attributeValue = new Extensions(fi);
                return;
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        byte[] val = inAttrValue.toByteArray();
        Class[] params = new Class[]{Object.class};
        try {
            Class<?> extClass = OIDMap.getClass(this.attributeId);
            if (extClass != null) {
                Constructor<?> cons = extClass.getConstructor(params);
                Object value = Array.newInstance(Byte.TYPE, val.length);
                for (int i = 0; i < val.length; ++i) {
                    Array.setByte(value, i, val[i]);
                }
                Object[] passed = new Object[]{value};
                this.attributeValue = (CertAttrSet)cons.newInstance(passed);
            } else {
                this.attributeValue = new ACertAttrSet(inAttrValue);
            }
        }
        catch (InvocationTargetException invk) {
            throw new IOException(invk.getTargetException().getMessage(), invk);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public PKCS10Attribute(ObjectIdentifier attributeId, CertAttrSet attributeValue) {
        this.attributeId = attributeId;
        this.attributeValue = attributeValue;
    }

    public PKCS10Attribute(PKCS10Attribute attr) {
        this.attributeId = attr.attributeId;
        this.attributeValue = attr.attributeValue;
    }

    public void encode(OutputStream out) throws CertificateException, IOException {
        try (DerOutputStream tmp = new DerOutputStream();){
            DerOutputStream outAttrValue = new DerOutputStream();
            this.attributeValue.encode(outAttrValue);
            DerValue outAttrValueSet = new DerValue(49, outAttrValue.toByteArray());
            DerOutputStream outAttr = new DerOutputStream();
            outAttr.putOID(this.attributeId);
            outAttr.putDerValue(outAttrValueSet);
            tmp.write((byte)48, outAttr);
            out.write(tmp.toByteArray());
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        try {
            this.encode(out);
        }
        catch (CertificateException ce) {
            IOException ioe = new IOException(ce.toString());
            ioe.fillInStackTrace();
            throw ioe;
        }
    }

    public ObjectIdentifier getAttributeId() {
        return this.attributeId;
    }

    public CertAttrSet getAttributeValue() {
        return this.attributeValue;
    }

    public String toString() {
        String s = "AttributeId: " + this.attributeId.toString() + "\n";
        s = s + "AttributeValue: " + this.attributeValue.toString();
        return s;
    }
}

