/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.netscape.security.pkcs.PKCS12CertInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS12KeyInfo;
import org.mozilla.jss.pkcs11.PK11Cert;

public class PKCS12 {
    public static final OBJECT_IDENTIFIER PKI_OID = new OBJECT_IDENTIFIER("2.16.840.1.113730.5");
    public static final OBJECT_IDENTIFIER PKCS12_OID = PKI_OID.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS12_ATTRIBUTES_OID = PKCS12_OID.subBranch(1L);
    public static final OBJECT_IDENTIFIER CERT_TRUST_FLAGS_OID = PKCS12_ATTRIBUTES_OID.subBranch(1L);
    @Deprecated
    public static final int TERMINAL_RECORD = 1;
    @Deprecated
    public static final int TRUSTED = 2;
    @Deprecated
    public static final int SEND_WARN = 4;
    @Deprecated
    public static final int VALID_CA = 8;
    @Deprecated
    public static final int TRUSTED_CA = 16;
    @Deprecated
    public static final int NS_TRUSTED_CA = 32;
    @Deprecated
    public static final int USER = 64;
    @Deprecated
    public static final int TRUSTED_CLIENT_CA = 128;
    @Deprecated
    public static final int INVISIBLE_CA = 256;
    @Deprecated
    public static final int GOVT_APPROVED_CA = 512;
    Map<BigInteger, PKCS12KeyInfo> keyInfosByID = new LinkedHashMap<BigInteger, PKCS12KeyInfo>();
    Map<BigInteger, PKCS12CertInfo> certInfosByID = new LinkedHashMap<BigInteger, PKCS12CertInfo>();
    Map<BigInteger, PKCS12CertInfo> certInfosByKeyID = new LinkedHashMap<BigInteger, PKCS12CertInfo>();

    @Deprecated
    public static boolean isFlagEnabled(int flag, int flags) {
        return PK11Cert.isTrustFlagEnabled(flag, flags);
    }

    @Deprecated
    public static String encodeFlags(int flags) {
        return PK11Cert.encodeTrustFlags(flags);
    }

    @Deprecated
    public static int decodeFlags(String flags) throws Exception {
        return PK11Cert.decodeTrustFlags(flags);
    }

    public Collection<PKCS12KeyInfo> getKeyInfos() {
        return this.keyInfosByID.values();
    }

    public void addKeyInfo(PKCS12KeyInfo keyInfo) {
        this.keyInfosByID.put(new BigInteger(1, keyInfo.getID()), keyInfo);
    }

    public PKCS12KeyInfo getKeyInfoByID(byte[] id) {
        return this.keyInfosByID.get(new BigInteger(1, id));
    }

    public PKCS12KeyInfo removeKeyInfoByID(byte[] id) {
        return this.keyInfosByID.remove(new BigInteger(1, id));
    }

    public Collection<PKCS12CertInfo> getCertInfos() {
        return this.certInfosByID.values();
    }

    public void addCertInfo(PKCS12CertInfo certInfo, boolean replace) {
        BigInteger id = new BigInteger(1, certInfo.getID());
        if (!replace && this.certInfosByID.containsKey(id)) {
            return;
        }
        this.certInfosByID.put(id, certInfo);
        byte[] keyID = certInfo.getKeyID();
        if (keyID == null) {
            return;
        }
        this.certInfosByKeyID.put(new BigInteger(1, keyID), certInfo);
    }

    public PKCS12CertInfo getCertInfoByID(byte[] id) {
        return this.certInfosByID.get(new BigInteger(1, id));
    }

    public PKCS12CertInfo getCertInfoByKeyID(byte[] keyID) {
        return this.certInfosByKeyID.get(new BigInteger(1, keyID));
    }

    public Collection<PKCS12CertInfo> getCertInfosByFriendlyName(String friendlyName) {
        ArrayList<PKCS12CertInfo> result = new ArrayList<PKCS12CertInfo>();
        for (PKCS12CertInfo certInfo : this.certInfosByID.values()) {
            if (!friendlyName.equals(certInfo.getFriendlyName())) continue;
            result.add(certInfo);
        }
        return result;
    }

    public void removeCertInfoByFriendlyName(String friendlyName) throws Exception {
        Collection<PKCS12CertInfo> result = this.getCertInfosByFriendlyName(friendlyName);
        if (result.isEmpty()) {
            throw new Exception("Certificate not found: " + friendlyName);
        }
        for (PKCS12CertInfo certInfo : result) {
            BigInteger id = new BigInteger(1, certInfo.getID());
            this.certInfosByID.remove(id);
            byte[] keyID = certInfo.getKeyID();
            if (keyID == null) continue;
            this.certInfosByKeyID.remove(new BigInteger(1, keyID));
            this.keyInfosByID.remove(new BigInteger(1, keyID));
        }
    }
}

