/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class CertificateChain
implements Serializable {
    private List<X509Certificate> certs = new ArrayList<X509Certificate>();

    public CertificateChain() {
    }

    public CertificateChain(X509Certificate cert) {
        if (cert == null) {
            throw new IllegalArgumentException("Missing input certificate");
        }
        this.certs.add(cert);
    }

    public CertificateChain(X509Certificate[] certs) {
        if (certs == null) {
            throw new IllegalArgumentException("Missing input certificates");
        }
        this.certs.addAll(Arrays.asList(certs));
    }

    public List<X509Certificate> getCertificates() {
        return this.certs;
    }

    public X509Certificate getCertificate(int index) {
        return this.certs.get(index);
    }

    public X509Certificate getFirstCertificate() {
        return this.certs.get(0);
    }

    public X509Certificate[] getChain() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public void sort() throws Exception {
        X509Certificate[] certs = this.getChain();
        certs = Cert.sortCertificateChain(certs);
        this.certs.clear();
        this.certs.addAll(Arrays.asList(certs));
    }

    public void encode(OutputStream out) throws IOException {
        this.encode(out, true);
    }

    public void encode(OutputStream out, boolean sort) throws IOException {
        X509Certificate[] certs = this.getChain();
        PKCS7 p7 = new PKCS7(certs);
        p7.encodeSignedData(out, sort);
    }

    public void decode(InputStream in) throws IOException {
        PKCS7 p7 = new PKCS7(in);
        this.certs.clear();
        this.certs.addAll(Arrays.asList(p7.getCertificates()));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.encode(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.decode(in);
    }

    public void addCertificate(X509Certificate cert) {
        this.certs.add(cert);
    }

    public void addCertificateChain(CertificateChain certChain) {
        this.certs.addAll(certChain.certs);
    }

    public void addPKCS7(PKCS7 pkcs7) {
        this.certs.addAll(Arrays.asList(pkcs7.getCertificates()));
    }

    public static CertificateChain fromPEMString(String input) throws Exception {
        String[] lines;
        CertificateChain certChain = new CertificateChain();
        StringBuilder sb = new StringBuilder();
        for (String line : lines = input.split("\\r?\\n")) {
            byte[] bytes;
            if ("-----BEGIN CERTIFICATE-----".equals(line = line.trim())) {
                sb.setLength(0);
                continue;
            }
            if ("-----END CERTIFICATE-----".equals(line)) {
                bytes = Utils.base64decode(sb.toString());
                certChain.addCertificate(new X509CertImpl(bytes));
                continue;
            }
            if ("-----BEGIN PKCS7-----".equals(line)) {
                sb.setLength(0);
                continue;
            }
            if ("-----END PKCS7-----".equals(line)) {
                bytes = Utils.base64decode(sb.toString());
                PKCS7 pkcs7 = new PKCS7(bytes);
                certChain.addPKCS7(pkcs7);
                continue;
            }
            sb.append(line);
        }
        certChain.sort();
        return certChain;
    }

    public String toPEMString() throws Exception {
        this.sort();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        for (X509Certificate cert : this.certs) {
            pw.println("-----BEGIN CERTIFICATE-----");
            pw.print(Utils.base64encodeMultiLine(cert.getEncoded()));
            pw.println("-----END CERTIFICATE-----");
        }
        return sw.toString();
    }

    public PKCS7 toPKCS7() throws Exception {
        this.sort();
        ArrayList<X509CertImpl> certImpls = new ArrayList<X509CertImpl>();
        for (X509Certificate cert : this.certs) {
            certImpls.add(new X509CertImpl(cert.getEncoded()));
        }
        return new PKCS7(certImpls.toArray(new X509CertImpl[0]));
    }

    public String toString() {
        if (this.certs.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (X509Certificate cert : this.certs) {
            sb.append(cert);
        }
        sb.append("]");
        return sb.toString();
    }
}

