/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Properties;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CRLDistributionPointsExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDMap {
    private static final Logger logger = LoggerFactory.getLogger(OIDMap.class);
    public static final String EXTENSIONS_HOME = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cert" + File.separator;
    public static final String EXTENSIONS_OIDS = "x509extensions.oid";
    public static final String EXTENSIONS_CLASSES = "x509extensions.classes";
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String AUTHORITY_INFORMATION_ACCESS_IDENTIFIER = "x509.info.extensions.AuthInfoAccessExtension";
    private static final String SUBJECT_INFORMATION_ACCESS_IDENTIFIER = "x509.info.extensions.SubjectInfoAccessExtension";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CERT_POLICIES = "x509.info.extensions.CertificatePolicies";
    private static final String SUBJ_DIR_ATTR = "x509.info.extensions.SubjectDirectoryAttributes";
    public static final String EXT_KEY_USAGE_NAME = "ExtendedKeyUsageExtension";
    public static final String EXT_INHIBIT_ANY_POLICY_NAME = "InhibitAnyPolicyExtension";
    private static final String EXT_KEY_USAGE = "x509.info.extensions.ExtendedKeyUsageExtension";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReason";
    private static final Hashtable<ObjectIdentifier, String> oid2Name = new Hashtable();
    private static final Hashtable<String, ObjectIdentifier> name2OID = new Hashtable();
    private static final Hashtable<String, String> name2Class = new Hashtable();

    private static void loadNamesDefault(Properties props) {
        props.put(SUB_KEY_IDENTIFIER, "2.5.29.14");
        props.put(AUTHORITY_INFORMATION_ACCESS_IDENTIFIER, "1.3.6.1.5.5.7.1.1");
        props.put(SUBJECT_INFORMATION_ACCESS_IDENTIFIER, "1.3.6.1.5.5.7.1.11");
        props.put(KEY_USAGE, "2.5.29.15");
        props.put(PRIVATE_KEY_USAGE, "2.5.29.16");
        props.put(SUB_ALT_NAME, "2.5.29.17");
        props.put(ISSUER_ALT_NAME, "2.5.29.18");
        props.put(BASIC_CONSTRAINTS, "2.5.29.19");
        props.put(CRL_NUMBER, "2.5.29.20");
        props.put(CRL_REASON, "2.5.29.21");
        props.put(NAME_CONSTRAINTS, "2.5.29.30");
        props.put(POLICY_MAPPINGS, "2.5.29.33");
        props.put(POLICY_CONSTRAINTS, "2.5.29.36");
        props.put(CERT_POLICIES, "2.5.29.32");
        props.put(AUTH_KEY_IDENTIFIER, "2.5.29.35");
        props.put(SUBJ_DIR_ATTR, "2.5.29.9");
        props.put(EXT_KEY_USAGE, "2.5.29.37");
    }

    private static void loadClassDefault(Properties props) {
        props.put(AUTH_KEY_IDENTIFIER, "org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension");
        props.put(SUB_KEY_IDENTIFIER, "org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension");
        props.put(AUTHORITY_INFORMATION_ACCESS_IDENTIFIER, "org.mozilla.jss.netscape.security.extensions.AuthInfoAccessExtension");
        props.put(SUBJECT_INFORMATION_ACCESS_IDENTIFIER, "org.mozilla.jss.netscape.security.extensions.SubjectInfoAccessExtension");
        props.put(KEY_USAGE, "org.mozilla.jss.netscape.security.x509.KeyUsageExtension");
        props.put(PRIVATE_KEY_USAGE, "org.mozilla.jss.netscape.security.x509.PrivateKeyUsageExtension");
        props.put(POLICY_MAPPINGS, "org.mozilla.jss.netscape.security.x509.PolicyMappingsExtension");
        props.put(SUB_ALT_NAME, "org.mozilla.jss.netscape.security.x509.SubjectAlternativeNameExtension");
        props.put(ISSUER_ALT_NAME, "org.mozilla.jss.netscape.security.x509.IssuerAlternativeNameExtension");
        props.put(BASIC_CONSTRAINTS, "org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension");
        props.put(NAME_CONSTRAINTS, "org.mozilla.jss.netscape.security.x509.NameConstraintsExtension");
        props.put(POLICY_CONSTRAINTS, "org.mozilla.jss.netscape.security.x509.PolicyConstraintsExtension");
        props.put(CERT_POLICIES, "org.mozilla.jss.netscape.security.x509.CertificatePoliciesExtension");
        props.put(SUBJ_DIR_ATTR, "org.mozilla.jss.netscape.security.x509.SubjectDirAttributesExtension");
        props.put(EXT_KEY_USAGE, "org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension");
        props.put(CRL_NUMBER, "org.mozilla.jss.netscape.security.x509.CRLNumberExtension");
        props.put(CRL_REASON, "org.mozilla.jss.netscape.security.x509.CRLReasonExtension");
    }

    private static File certificatePropFile(String fileName) {
        return new File(EXTENSIONS_HOME + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNames() {
        Properties props = new Properties();
        File namesMap = OIDMap.certificatePropFile(EXTENSIONS_OIDS);
        if (!namesMap.exists()) {
            OIDMap.loadNamesDefault(props);
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(namesMap);
                props.load(fis);
            }
            catch (IOException e) {
                OIDMap.loadNamesDefault(props);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.debug("Error closing x509extensions.oid", (Throwable)e);
                    }
                }
            }
        }
        for (String name : props.stringPropertyNames()) {
            String oidName = props.getProperty(name);
            ObjectIdentifier oid = new ObjectIdentifier(oidName);
            name2OID.put(name, oid);
            oid2Name.put(oid, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadClasses() {
        Properties props = new Properties();
        File classMap = OIDMap.certificatePropFile(EXTENSIONS_CLASSES);
        if (!classMap.exists()) {
            OIDMap.loadClassDefault(props);
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(classMap);
                props.load(fis);
            }
            catch (IOException e) {
                OIDMap.loadClassDefault(props);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.debug("Error closing x509extensions.classes", (Throwable)e);
                    }
                }
            }
        }
        for (String name : props.stringPropertyNames()) {
            String className = props.getProperty(name);
            name2Class.put(name, className);
        }
    }

    public static void addClass(Class<? extends Extension> clazz) {
        try {
            OIDMap.addAttribute(clazz.getName(), (String)clazz.getField("OID").get(null), (String)clazz.getField("NAME").get(null));
        }
        catch (Throwable e) {
            System.out.println("Error adding class " + clazz.getName() + " to OIDMap: " + e);
        }
    }

    public static void addAttribute(String className, String oid, String name) throws CertificateException {
        ObjectIdentifier objId = new ObjectIdentifier(oid);
        if (oid2Name.get(objId) != null) {
            throw new CertificateException("Object identifier already exists.");
        }
        if (name2OID.get(name) != null) {
            throw new CertificateException("Name already exists.");
        }
        if (name2Class.get(className) != null) {
            throw new CertificateException("Class already exists.");
        }
        oid2Name.put(objId, name);
        name2OID.put(name, objId);
        name2Class.put(name, className);
    }

    public static String getName(ObjectIdentifier oid) {
        return oid2Name.get(oid);
    }

    public static ObjectIdentifier getOID(String name) {
        return name2OID.get(name);
    }

    public static Class<?> getClass(String name) throws CertificateException {
        String className = name2Class.get(name);
        if (className == null) {
            return null;
        }
        try {
            Class<?> extClass = Class.forName(className);
            return extClass;
        }
        catch (Exception e) {
            throw new CertificateException("Error instantiating class for " + name + " " + e.toString());
        }
    }

    public static Class<?> getClass(ObjectIdentifier oid) throws CertificateException {
        String name = OIDMap.getName(oid);
        if (name == null) {
            return null;
        }
        String className = name2Class.get(name);
        if (className == null) {
            return null;
        }
        try {
            Class<?> extClass = Class.forName(className);
            return extClass;
        }
        catch (Exception e) {
            throw new CertificateException("Error instantiating class for " + name + " " + e.getMessage(), e);
        }
    }

    static {
        OIDMap.loadNames();
        OIDMap.loadClasses();
        OIDMap.addClass(CRLDistributionPointsExtension.class);
    }
}

