/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.LdapV3DNStrConverter;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;

public class RFC1779StrConverter
extends LdapV3DNStrConverter {
    public RFC1779StrConverter() {
    }

    public RFC1779StrConverter(X500NameAttrMap attributeMap, boolean doAcceptUnknownOids) {
        super(attributeMap, doAcceptUnknownOids);
    }

    @Override
    public String encodeOID(ObjectIdentifier oid) throws IOException {
        Object keyword = this.attrMap.getName(oid);
        if (keyword == null) {
            if (!this.acceptUnknownOids) {
                throw new IllegalArgumentException("Unrecognized OID");
            }
            keyword = "OID." + oid.toString();
        }
        return keyword;
    }

    @Override
    public String encodeValue(DerValue attrValue, ObjectIdentifier oid) throws IOException {
        String s = super.encodeValue(attrValue, oid);
        if (s.indexOf(10) != -1) {
            return "\"" + s + "\"";
        }
        return s;
    }
}

