/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public class RC2AlgorithmParameters
extends AlgorithmParametersSpi {
    private RC2ParameterSpec RC2ParamSpec;

    @Override
    public void engineInit(AlgorithmParameterSpec paramSpec) {
        this.RC2ParamSpec = (RC2ParameterSpec)paramSpec;
    }

    @Override
    public <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (clazz == null || !clazz.isInstance(this.RC2ParamSpec)) {
            Class<?> paramSpecClass = this.RC2ParamSpec.getClass();
            throw new InvalidParameterSpecException("RC2 getParameterSpec has class " + paramSpecClass.getName());
        }
        return (T)((AlgorithmParameterSpec)clazz.cast(this.RC2ParamSpec));
    }

    @Override
    public void engineInit(byte[] params) throws IOException {
        throw new IOException("engineInit(byte[]) not supported");
    }

    @Override
    public void engineInit(byte[] params, String format) throws IOException {
        throw new IOException("engineInit(byte[],String) not supported");
    }

    @Override
    public byte[] engineGetEncoded() throws IOException {
        throw new IOException("encoding RC2AlgorithmParameters not supported");
    }

    @Override
    public byte[] engineGetEncoded(String format) throws IOException {
        throw new IOException("encoding RC2AlgorithmParameters not supported");
    }

    @Override
    public String engineToString() {
        String str = new String("Mozilla-JSS RC2AlgorithmParameters " + this.getClass().getName());
        return str;
    }
}

