/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AuthorityKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLNumberExtension;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;

public class EnumerationZeroTest {
    private EnumerationZeroTest() {
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static AuthorityKeyIdentifierExtension buildAuthorityKeyIdentifier(RSAPublicKey key) throws IOException {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-1");
            byte[] encodedKey = key.getEncoded();
            DerInputStream s = new DerValue(encodedKey).toDerInputStream();
            s.skipSequence(0);
            BitArray b = s.getUnalignedBitString();
            byte[] digest = d.digest(b.toByteArray());
            KeyIdentifier ki = new KeyIdentifier(digest);
            return new AuthorityKeyIdentifierExtension(ki, null, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Could not find SHA1 implementation", e);
        }
    }

    public static void outputExtension(CRLReasonExtension ext) throws Exception {
        ByteArrayOutputStream resultBytesOut = new ByteArrayOutputStream();
        ext.encode((OutputStream)resultBytesOut);
        byte[] encodedBytes = resultBytesOut.toByteArray();
        System.out.print("Full encoded extension: " + EnumerationZeroTest.toHex(encodedBytes));
        Extension reasonExt = new Extension(new DerValue(encodedBytes));
        System.out.print("\tEncoded CRL Reason: " + EnumerationZeroTest.toHex(reasonExt.getExtensionValue()));
        DerValue reasonValue = new DerValue(reasonExt.getExtensionValue());
        System.out.println("\tReason value: " + reasonValue.getEnumerated());
    }

    public static X509CRL buildCrl(boolean useZero) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048);
        KeyPair kp = generator.generateKeyPair();
        ArrayList<RevokedCertImpl> revokedCerts = new ArrayList<RevokedCertImpl>();
        for (int i = 0; i <= 10; ++i) {
            if (i == 7 || i == 0 && !useZero) continue;
            CRLReasonExtension reasonExt = new CRLReasonExtension(RevocationReason.fromInt((int)i));
            EnumerationZeroTest.outputExtension(reasonExt);
            CRLExtensions entryExtensions = new CRLExtensions();
            entryExtensions.add((Object)reasonExt);
            revokedCerts.add(new RevokedCertImpl(BigInteger.valueOf(i), new Date(), entryExtensions));
        }
        CRLExtensions crlExtensions = new CRLExtensions();
        crlExtensions.add((Object)new CRLNumberExtension(BigInteger.ONE));
        crlExtensions.add((Object)EnumerationZeroTest.buildAuthorityKeyIdentifier((RSAPublicKey)kp.getPublic()));
        X500Name issuer = new X500Name("CN=Test");
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 365);
        Date until = calendar.getTime();
        X509CRLImpl crlImpl = new X509CRLImpl(issuer, now, until, revokedCerts.toArray(new RevokedCertificate[0]), crlExtensions);
        crlImpl.sign(kp.getPrivate(), "SHA256withRSA");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        byte[] data = crlImpl.getEncoded();
        return (X509CRL)cf.generateCRL(new ByteArrayInputStream(data));
    }

    public static void main(String[] args) throws Exception {
        X509CRL crl = EnumerationZeroTest.buildCrl(false);
        System.out.println(crl.toString());
        EnumerationZeroTest.buildCrl(true);
    }

    static {
        Security.addProvider((Provider)new JSSProvider());
    }
}

