/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.TestCertApprovalCallback;
import org.mozilla.jss.ssl.TestClientCertificateSelectionCallback;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSS_FileUploadClient {
    public static Logger logger = LoggerFactory.getLogger(JSS_FileUploadClient.class);
    private String clientCertNick = null;
    private String serverHost = null;
    private boolean TestCertCallBack = false;
    private boolean success = true;
    private int fCipher = -1;
    private int port = 29755;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private String fUploadFile = "foo.in";

    public void setCipher(int aCipher) {
        this.fCipher = aCipher;
    }

    public void setHostName(String aHostName) {
        this.serverHost = aHostName;
    }

    public void setPort(int aPort) {
        this.port = aPort;
    }

    public void setPasswordFile(String aPasswordFile) {
        this.fPasswordFile = aPasswordFile;
    }

    public void setCertDbPath(String aCertDbPath) {
        this.fCertDbPath = aCertDbPath;
    }

    public void setUploadFile(String aUploadFile) {
        this.fUploadFile = aUploadFile;
    }

    public void setTestCertCallback(boolean aTestCertCallback) {
        this.TestCertCallBack = aTestCertCallback;
    }

    public void setClientCertNick(String aClientCertNick) {
        this.clientCertNick = aClientCertNick;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public void setEOF(String fEof) {
        this.EOF = fEof;
    }

    public void doIt() throws Exception {
        try {
            this.cm = CryptoManager.getInstance();
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("client about to connect...");
        String hostAddr = InetAddress.getByName(this.serverHost).getHostAddress();
        logger.debug("the host " + this.serverHost + " and the address " + hostAddr);
        TestCertApprovalCallback approvalCallback = new TestCertApprovalCallback();
        TestClientCertificateSelectionCallback certSelectionCallback = new TestClientCertificateSelectionCallback();
        SSLSocket sock = null;
        if (this.TestCertCallBack) {
            logger.debug("calling approvalCallBack");
            sock = new SSLSocket(InetAddress.getByName(hostAddr), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertApprovalCallback(), null);
        } else {
            logger.debug("NOT calling approvalCallBack");
            sock = new SSLSocket(InetAddress.getByName(hostAddr), this.port);
        }
        logger.debug("clientCertNick=" + this.clientCertNick);
        sock.setClientCertNickname(this.clientCertNick);
        if (this.fCipher != -1) {
            sock.setCipherPreference(this.fCipher, true);
        }
        logger.debug("Client specified cert by nickname");
        logger.debug("client connected");
        sock.addHandshakeCompletedListener((SSLHandshakeCompletedListener)new HandshakeListener("client", this));
        sock.forceHandshake();
        readWriteThread rwThread = new readWriteThread(sock, 0);
        rwThread.start();
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] args) {
        String certnick = "JSSCATestCert";
        String testCipher = "1";
        String testhost = "localhost";
        int testport = 29755;
        int socketCntr = 1;
        String certDbPath = null;
        String passwdFile = null;
        String uploadFile = "foo.in";
        String usage = "\nUSAGE:\njava org.mozilla.jss.tests.JSS_FileUploadClient [# sockets] [JSS cipher integer]\n[certdb path] [password file] [upload test file]  [server host] [server port]";
        try {
            if (args.length <= 0 || args[0].toLowerCase().equals("-h")) {
                System.out.println(usage);
                System.exit(1);
            } else {
                socketCntr = Integer.parseInt(args[0]);
                System.out.println("Socket Counter = " + socketCntr);
            }
            testCipher = args[1];
            System.out.println("Test Cipher    = " + testCipher);
            if (args.length >= 3) {
                certDbPath = args[2];
                passwdFile = args[3];
            }
            if (args.length >= 5) {
                uploadFile = args[4];
                testhost = args[5];
                testport = Integer.parseInt(args[6]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Client connecting to server ...");
        for (int j = 0; j < socketCntr; ++j) {
            JSS_FileUploadClient jssTest = new JSS_FileUploadClient();
            try {
                if (!testhost.equals("localhost")) {
                    jssTest.setHostName(testhost);
                }
                if (testport != 29755) {
                    jssTest.setPort(testport);
                }
                jssTest.setTestCertCallback(true);
                jssTest.setClientCertNick(certnick);
                if (certDbPath != null) {
                    jssTest.setCertDbPath(certDbPath);
                }
                if (passwdFile != null) {
                    jssTest.setPasswordFile(passwdFile);
                }
                if (!uploadFile.equals("foo.in")) {
                    jssTest.setUploadFile(uploadFile);
                }
                if (testCipher == null) continue;
                try {
                    jssTest.setCipher(Integer.parseInt(testCipher));
                    jssTest.setEOF(testCipher);
                    jssTest.doIt();
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("All " + socketCntr + " sockets created. Exiting");
        try {
            Thread.sleep(300000L);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_FileUploadClient boss;

        public HandshakeListener(String who, JSS_FileUploadClient boss) {
            this.who = who;
            this.boss = boss;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            try {
                String mesg = this.who + " got a completed handshake ";
                SSLSecurityStatus status = event.getStatus();
                mesg = status.isSecurityOn() ? mesg + "(security is ON)" : mesg + "(security is OFF)";
                logger.debug(mesg);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.boss.setFailure();
            }
            JSS_FileUploadClient.this.setHandshakeCompleted();
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket clientSock = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sock, int cntr) {
            this.clientSock = sock;
            this.socketCntr = cntr;
        }

        @Override
        public void run() {
            try {
                Object socketData = null;
                Object cbuf = null;
                boolean readLength = false;
                String readString = null;
                OutputStream os = this.clientSock.getOutputStream();
                System.out.println("Reading file foo.in");
                BufferedReader in = new BufferedReader(new FileReader(JSS_FileUploadClient.this.fUploadFile));
                System.out.println("Successfully got a handle to " + JSS_FileUploadClient.this.fUploadFile);
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                while ((readString = in.readLine()) != null) {
                    System.out.println("Read:" + readString);
                    out.println(readString);
                    out.flush();
                }
                in.close();
                out.close();
            }
            catch (Exception e) {
                System.out.println("Exception caught" + e.getMessage());
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

