/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attributes;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500Signer;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS10 {
    public static Logger logger = LoggerFactory.getLogger(PKCS10.class);
    private X500Name subject;
    private X509Key subjectPublicKeyInfo;
    private PKCS10Attributes attributeSet;
    private byte[] certificateRequest;
    private byte[] certRequestInfo;

    public PKCS10(X509Key publicKey) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = new PKCS10Attributes();
    }

    public PKCS10(X509Key publicKey, PKCS10Attributes attributes) {
        this.subjectPublicKeyInfo = publicKey;
        this.attributeSet = attributes != null ? attributes : new PKCS10Attributes();
    }

    public PKCS10(byte[] data, boolean sigver) throws IOException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        Object msg = "";
        logger.debug("PKCS10: begins");
        if (data == null) {
            throw new IllegalArgumentException("Missing PKCS #10 data");
        }
        this.certificateRequest = data;
        DerInputStream in = new DerInputStream(data);
        DerValue[] seq = in.getSequence(3);
        if (seq == null) {
            throw new IllegalArgumentException("in.getSequence null");
        }
        if (seq.length != 3) {
            throw new IllegalArgumentException("Invalid PKCS #10 request");
        }
        data = seq[0].toByteArray();
        this.certRequestInfo = seq[0].toByteArray();
        AlgorithmId id = AlgorithmId.parse(seq[1]);
        byte[] sigData = seq[2].getBitString();
        BigInt serial = seq[0].data.getInteger();
        this.subject = new X500Name(seq[0].data);
        msg = "Request Subject: " + this.subject + ": ";
        byte[] val1 = seq[0].data.getDerValue().toByteArray();
        this.subjectPublicKeyInfo = X509Key.parse(new DerValue(val1));
        PublicKey publicKey = X509Key.parsePublicKey(new DerValue(val1));
        if (publicKey == null) {
            logger.error("PKCS10: " + (String)msg + "publicKey null");
            throw new SignatureException((String)msg + "publicKey null");
        }
        this.attributeSet = seq[0].data.available() != 0 ? new PKCS10Attributes(seq[0].data) : new PKCS10Attributes();
        try {
            String idName = id.getName();
            if (idName.equals("MD5withRSA")) {
                idName = "MD5/RSA";
            } else if (idName.equals("MD2withRSA")) {
                idName = "MD2/RSA";
            } else if (idName.equals("SHA1withRSA")) {
                idName = "SHA1/RSA";
            } else if (idName.equals("SHA1withDSA")) {
                idName = "SHA1/DSA";
            } else if (idName.equals("SHA256withRSA")) {
                idName = "SHA256/RSA";
            } else if (idName.equals("SHA384withRSA")) {
                idName = "SHA384/RSA";
            } else if (idName.equals("SHA512withRSA")) {
                idName = "SHA512/RSA";
            } else if (idName.equals("SHA1withEC")) {
                idName = "SHA1/EC";
            } else if (idName.equals("SHA256withEC")) {
                idName = "SHA256/EC";
            } else if (idName.equals("SHA384withEC")) {
                idName = "SHA384/EC";
            } else if (idName.equals("SHA512withEC")) {
                idName = "SHA512/EC";
            }
            if (sigver) {
                Signature sig = Signature.getInstance(idName, "Mozilla-JSS");
                sig.initVerify(publicKey);
                sig.update(data);
                if (!sig.verify(sigData)) {
                    logger.error("PKCS10: " + (String)msg + "sig.verify() failed");
                    throw new SignatureException((String)msg + "Invalid PKCS #10 signature");
                }
            }
        }
        catch (InvalidKeyException e) {
            logger.error("PKCS10: " + (String)msg + e.getMessage());
            throw new SignatureException((String)msg + "invalid key", e);
        }
        logger.debug("PKCS10: ends");
    }

    public PKCS10(byte[] data) throws IOException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        this(data, true);
    }

    public void encodeAndSign(X500Signer requester) throws CertificateException, IOException, SignatureException {
        if (this.certificateRequest != null) {
            throw new SignatureException("request is already signed");
        }
        this.subject = requester.getSigner();
        DerOutputStream scratch = new DerOutputStream();
        scratch.putInteger(new BigInt(0));
        this.subject.encode(scratch);
        this.subjectPublicKeyInfo.encode(scratch);
        this.attributeSet.encode(scratch);
        DerOutputStream out = new DerOutputStream();
        out.write((byte)48, scratch);
        byte[] certificateRequestInfo = out.toByteArray();
        scratch = out;
        requester.update(certificateRequestInfo, 0, certificateRequestInfo.length);
        byte[] sig = requester.sign();
        requester.getAlgorithmId().encode(scratch);
        scratch.putBitString(sig);
        out = new DerOutputStream();
        out.write((byte)48, scratch);
        this.certificateRequest = out.toByteArray();
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public X509Key getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public PKCS10Attributes getAttributes() {
        return this.attributeSet;
    }

    public byte[] toByteArray() {
        return this.certificateRequest;
    }

    public void print(PrintStream out) throws IOException, SignatureException {
        if (this.certificateRequest == null) {
            throw new SignatureException("Cert request was not signed");
        }
        out.println("-----BEGIN CERTIFICATE REQUEST-----");
        out.print(Utils.base64encode(this.certificateRequest, true));
        out.println("-----END CERTIFICATE REQUEST-----");
    }

    public String toString() {
        return "[PKCS #10 certificate request:\n" + this.subjectPublicKeyInfo.toString() + " subject: <" + this.subject + ">\n attributes: " + this.attributeSet.toString() + "\n]";
    }

    public byte[] getCertRequestInfo() {
        return this.certRequestInfo;
    }
}

