/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

public class PrettyPrintFormat {
    private String mSeparator = "";
    private int mIndentSize = 0;
    private int mLineLen = 0;
    private static final String spaces = "                                                                                                                                                                                                                                                     ";
    private static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PrettyPrintFormat(String separator) {
        this.mSeparator = separator;
    }

    public PrettyPrintFormat(String separator, int lineLen) {
        this.mSeparator = separator;
        this.mLineLen = lineLen;
    }

    public PrettyPrintFormat(String separator, int lineLen, int indentSize) {
        this.mSeparator = separator;
        this.mLineLen = lineLen;
        this.mIndentSize = indentSize;
    }

    public String indent(int size) {
        return spaces.substring(0, size);
    }

    public String toHexString(byte[] in, int indentSize, int lineLen, String separator) {
        if (in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int hexCount = 0;
        int j = 0;
        char[] c = lineLen == 0 ? new char[in.length * 3 + 1] : new char[lineLen * 3 + 1];
        char sep = separator.charAt(0);
        sb.append(this.indent(indentSize));
        for (int i = 0; i < in.length; ++i) {
            if (lineLen > 0 && hexCount == lineLen) {
                c[j++] = 10;
                sb.append(c, 0, j);
                sb.append(this.indent(indentSize));
                hexCount = 0;
                j = 0;
            }
            byte x = in[i];
            c[j++] = hexdigits[(char)(x >> 4 & 0xF)];
            c[j++] = hexdigits[(char)(x & 0xF)];
            if (i != in.length - 1) {
                c[j++] = sep;
            }
            ++hexCount;
        }
        if (j > 0) {
            c[j++] = 10;
            sb.append(c, 0, j);
        }
        return sb.toString();
    }

    public String toHexString(byte[] in, int indentSize, int lineLen) {
        return this.toHexString(in, indentSize, lineLen, this.mSeparator);
    }

    public String toHexString(byte[] in, int indentSize) {
        return this.toHexString(in, indentSize, this.mLineLen);
    }

    public String toHexString(byte[] in) {
        return this.toHexString(in, this.mIndentSize);
    }
}

