/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.GeneralNamesException;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPoint;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class IssuingDistributionPointExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -1281544042375527550L;
    public static final String OID = "2.5.29.28";
    public static final String NAME = "IssuingDistributionPoint";
    public static final String ISSUING_DISTRIBUTION_POINT = "issuing_distribution_point";
    private IssuingDistributionPoint issuingDistributionPoint = null;
    private byte[] cachedEncoding = null;

    public IssuingDistributionPointExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = critical;
        byte[] extValue = this.extensionValue = (byte[])((byte[])value).clone();
        this.issuingDistributionPoint = new IssuingDistributionPoint();
        DerValue val = new DerValue(extValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
        while (val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            if (opt != null) {
                for (int i = 0; i < 5; ++i) {
                    if (!opt.isContextSpecific((byte)i)) continue;
                    if (i == 0 && opt.isConstructed() && opt.data.available() != 0 || i != 0 && !opt.isConstructed() && opt.data.available() != 0) {
                        if (i == 0) {
                            DerValue opt1 = opt.data.getDerValue();
                            if (opt1 == null) continue;
                            if (opt1.isContextSpecific((byte)0)) {
                                if (opt1.isConstructed() && opt1.data.available() != 0) {
                                    opt1.resetTag((byte)48);
                                    try {
                                        GeneralNames fullName = new GeneralNames(opt1);
                                        if (fullName == null) continue;
                                        this.issuingDistributionPoint.setFullName(fullName);
                                        continue;
                                    }
                                    catch (GeneralNamesException e) {
                                        throw new IOException("Invalid encoding of IssuingDistributionPoint " + e, e);
                                    }
                                    catch (IOException e) {
                                        throw new IOException("Invalid encoding of IssuingDistributionPoint " + e, e);
                                    }
                                }
                                throw new IOException("Invalid encoding of IssuingDistributionPoint");
                            }
                            if (!opt1.isContextSpecific((byte)1)) continue;
                            if (opt1.isConstructed() && opt1.data.available() != 0) {
                                opt1.resetTag((byte)49);
                                try {
                                    RDN relativeName = new RDN(opt1);
                                    if (relativeName == null) continue;
                                    this.issuingDistributionPoint.setRelativeName(relativeName);
                                    continue;
                                }
                                catch (IOException e) {
                                    throw new IOException("Invalid encoding of IssuingDistributionPoint " + e, e);
                                }
                            }
                            throw new IOException("Invalid encoding of IssuingDistributionPoint");
                        }
                        if (i == 3) {
                            opt.resetTag((byte)3);
                            try {
                                BitArray reasons = opt.getUnalignedBitString();
                                if (reasons == null) {
                                    throw new IOException("Unable to get the unaligned bit string.");
                                }
                                this.issuingDistributionPoint.setOnlySomeReasons(reasons);
                                byte[] byArray = reasons.toByteArray();
                                continue;
                            }
                            catch (IOException e) {
                                throw new IOException("Invalid encoding of IssuingDistributionPoint " + e, e);
                            }
                        }
                        opt.resetTag((byte)1);
                        try {
                            boolean b = opt.getBoolean();
                            if (i == 1) {
                                this.issuingDistributionPoint.setOnlyContainsUserCerts(b);
                                continue;
                            }
                            if (i == 2) {
                                this.issuingDistributionPoint.setOnlyContainsCACerts(b);
                                continue;
                            }
                            if (i != 4) continue;
                            this.issuingDistributionPoint.setIndirectCRL(b);
                            continue;
                        }
                        catch (IOException e) {
                            throw new IOException("Invalid encoding of IssuingDistributionPoint " + e, e);
                        }
                    }
                    throw new IOException("Invalid encoding of IssuingDistributionPoint");
                }
                continue;
            }
            throw new IOException("Invalid encoding of IssuingDistributionPoint");
        }
    }

    public IssuingDistributionPointExtension(IssuingDistributionPoint idp) {
        this.extensionId = PKIXExtensions.IssuingDistributionPoint_Id;
        this.critical = true;
        this.issuingDistributionPoint = idp;
    }

    public IssuingDistributionPoint getIssuingDistributionPoint() {
        return this.issuingDistributionPoint;
    }

    @Override
    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical(boolean critical) {
        return this.critical;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        this.extensionValue = ASN1Util.encode(this.issuingDistributionPoint);
        super.encode(out);
    }

    public void flushCachedEncoding() {
        this.cachedEncoding = null;
    }

    @Override
    public String toString() {
        return NAME;
    }

    @Override
    public void encode(OutputStream ostream) throws CertificateException, IOException {
        if (this.cachedEncoding == null) {
            DerOutputStream tmp = new DerOutputStream();
            this.encode(tmp);
            this.cachedEncoding = tmp.toByteArray();
        }
        ostream.write(this.cachedEncoding);
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
        throw new IOException("Not supported");
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
        if (name.equalsIgnoreCase(ISSUING_DISTRIBUTION_POINT)) {
            if (!(obj instanceof IssuingDistributionPoint)) {
                throw new IOException("Attribute value should be of type IssuingDistributionPoint.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPointExtension");
        }
        this.issuingDistributionPoint = (IssuingDistributionPoint)obj;
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        if (name.equalsIgnoreCase(ISSUING_DISTRIBUTION_POINT)) {
            return this.issuingDistributionPoint;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPointExtension");
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
        if (!name.equalsIgnoreCase(ISSUING_DISTRIBUTION_POINT)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuingDistributionPointExtension");
        }
        this.issuingDistributionPoint = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(ISSUING_DISTRIBUTION_POINT);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FilterOutputStream bos = null;
        try {
            if (args.length != 1) {
                System.out.println("Usage: IssuingDistributionPointExtension <outfile>");
                System.exit(-1);
            }
            bos = new BufferedOutputStream(new FileOutputStream(args[0]));
            IssuingDistributionPoint idp = new IssuingDistributionPoint();
            URIName uri = new URIName("http://www.mycrl.com/go/here");
            GeneralNames generalNames = new GeneralNames();
            generalNames.addElement(uri);
            idp.setFullName(generalNames);
            IssuingDistributionPointExtension idpExt = new IssuingDistributionPointExtension(idp);
            idp = new IssuingDistributionPoint();
            X500Name dn = new X500Name("CN=Otis Smith,E=otis@fedoraproject.org,OU=Certificate Server,O=Fedora,C=US");
            generalNames = new GeneralNames();
            generalNames.addElement(dn);
            idp.setFullName(generalNames);
            idpExt.set(ISSUING_DISTRIBUTION_POINT, idp);
            BitArray ba = new BitArray(5, new byte[]{40});
            idp = new IssuingDistributionPoint();
            idp.setFullName(generalNames);
            idp.setOnlySomeReasons(ba);
            idpExt.set(ISSUING_DISTRIBUTION_POINT, idp);
            idp = new IssuingDistributionPoint();
            RDN rdn = new RDN("OU=foobar dept");
            idp.setRelativeName(rdn);
            idp.setOnlySomeReasons(ba);
            idp.setOnlyContainsCACerts(true);
            idp.setOnlyContainsUserCerts(true);
            idp.setIndirectCRL(true);
            idpExt.set(ISSUING_DISTRIBUTION_POINT, idp);
            idpExt.setCritical(false);
            idpExt.encode(bos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        try {
            OIDMap.addAttribute(IssuingDistributionPointExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

