/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.InvalidKeyException;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.SymmetricKeyDeriver;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11Token;

public class PK11SymmetricKeyDeriver
implements SymmetricKeyDeriver {
    private PK11Token token = null;
    private SymmetricKey baseKey = null;
    private SymmetricKey secondaryKey = null;
    private long deriveMechanism = 0L;
    private long targetMechanism = 0L;
    private long operation = 0L;
    private long keySize = 0L;
    private byte[] param = null;
    private byte[] iv = null;

    public PK11SymmetricKeyDeriver(PK11Token token) {
        this.token = token;
    }

    @Override
    public void initDerive(SymmetricKey baseKey, long deriveMech, byte[] param, byte[] iv, long targetMech, long operation, long keySize) throws InvalidKeyException {
        this.reset();
        if (baseKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        this.baseKey = baseKey;
        this.deriveMechanism = deriveMech;
        this.targetMechanism = targetMech;
        this.operation = operation;
        if (param != null) {
            this.param = new byte[param.length];
            System.arraycopy(param, 0, this.param, 0, param.length);
        }
        if (iv != null) {
            this.iv = new byte[iv.length];
            System.arraycopy(iv, 0, this.iv, 0, iv.length);
        }
        this.keySize = keySize;
    }

    @Override
    public void initDerive(SymmetricKey baseKey, SymmetricKey secondaryKey, long deriveMech, byte[] param, byte[] iv, long targetMech, long operation, long keySize) throws InvalidKeyException {
        this.reset();
        if (baseKey == null || secondaryKey == null) {
            throw new InvalidKeyException("Key is null");
        }
        this.initDerive(baseKey, deriveMech, param, iv, targetMech, operation, keySize);
        this.secondaryKey = secondaryKey;
    }

    @Override
    public SymmetricKey derive() throws TokenException {
        SymmetricKey result = this.deriveSymKey(this.baseKey, this.secondaryKey, this.deriveMechanism, this.param, this.iv, this.targetMechanism, this.operation, this.keySize);
        return result;
    }

    private SymmetricKey deriveSymKey(SymmetricKey baseKey, SymmetricKey secondaryKey, long deriveMechanism, byte[] param, byte[] iv, long targetMechanism, long operation, long keySize) throws TokenException, IllegalStateException {
        return this.nativeDeriveSymKey(this.token, baseKey, secondaryKey, deriveMechanism, param, iv, targetMechanism, operation, keySize);
    }

    public native SymmetricKey nativeDeriveSymKey(PK11Token var1, SymmetricKey var2, SymmetricKey var3, long var4, byte[] var6, byte[] var7, long var8, long var10, long var12);

    private void reset() {
        this.baseKey = null;
        this.secondaryKey = null;
        this.deriveMechanism = 0L;
        this.targetMechanism = 0L;
        this.operation = 0L;
        this.keySize = 0L;
        this.param = null;
        this.iv = null;
    }
}

