/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import org.mozilla.jss.ssl.SSLVersion;

public enum SSLCipher {
    SSL2_RC4_128_WITH_MD5(65281, SSLVersion.SSL_2_0),
    SSL2_RC4_128_EXPORT40_WITH_MD5(65282, SSLVersion.SSL_2_0),
    SSL2_RC2_128_CBC_WITH_MD5(65283, SSLVersion.SSL_2_0),
    SSL2_RC2_128_CBC_EXPORT40_WITH_MD5(65284, SSLVersion.SSL_2_0),
    SSL2_IDEA_128_CBC_WITH_MD5(65285, SSLVersion.SSL_2_0),
    SSL2_DES_64_CBC_WITH_MD5(65286, SSLVersion.SSL_2_0),
    SSL2_DES_192_EDE3_CBC_WITH_MD5(65287, SSLVersion.SSL_2_0),
    TLS_NULL_WITH_NULL_NULL(0, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_RSA_WITH_NULL_MD5(1, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_NULL_MD5(1, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_RSA_WITH_NULL_SHA(2, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_NULL_SHA(2, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_RSA_EXPORT_WITH_RC4_40_MD5(3, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_RSA_EXPORT_WITH_RC4_40_MD5(3, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_RSA_WITH_RC4_128_MD5(4, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_RC4_128_MD5(4, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_RSA_WITH_RC4_128_SHA(5, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_RC4_128_SHA(5, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_RSA_EXPORT_WITH_RC2_CBC_40_MD5(6, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5(6, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_RSA_WITH_IDEA_CBC_SHA(7, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_RSA_WITH_IDEA_CBC_SHA(7, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    SSL3_RSA_EXPORT_WITH_DES40_CBC_SHA(8, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA(8, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_RSA_WITH_DES_CBC_SHA(9, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_RSA_WITH_DES_CBC_SHA(9, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    SSL3_RSA_WITH_3DES_EDE_CBC_SHA(10, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_3DES_EDE_CBC_SHA(10, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_DH_DSS_EXPORT_WITH_DES40_CBC_SHA(11, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA(11, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_DH_DSS_WITH_DES_CBC_SHA(12, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_DH_DSS_WITH_DES_CBC_SHA(12, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    SSL3_DH_DSS_WITH_3DES_EDE_CBC_SHA(13, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA(13, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_DH_RSA_EXPORT_WITH_DES40_CBC_SHA(14, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA(14, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_DH_RSA_WITH_DES_CBC_SHA(15, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_DH_RSA_WITH_DES_CBC_SHA(15, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    SSL3_DH_RSA_WITH_3DES_EDE_CBC_SHA(16, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA(16, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA(17, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA(17, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_DHE_DSS_WITH_DES_CBC_SHA(18, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_DHE_DSS_WITH_DES_CBC_SHA(18, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    SSL3_DHE_DSS_WITH_3DES_EDE_CBC_SHA(19, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA(19, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA(20, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA(20, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_DHE_RSA_WITH_DES_CBC_SHA(21, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_DHE_RSA_WITH_DES_CBC_SHA(21, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    SSL3_DHE_RSA_WITH_3DES_EDE_CBC_SHA(22, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA(22, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    SSL3_DH_ANON_EXPORT_WITH_RC4_40_MD5(23, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DH_anon_EXPORT_WITH_RC4_40_MD5(23, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL3_DH_ANON_WITH_RC4_128_MD5(24, SSLVersion.SSL_3_0),
    TLS_DH_anon_WITH_RC4_128_MD5(24, SSLVersion.SSL_3_0),
    SSL3_DH_ANON_EXPORT_WITH_DES40_CBC_SHA(25, SSLVersion.SSL_3_0),
    TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA(25, SSLVersion.SSL_3_0),
    SSL3_DH_ANON_WITH_DES_CBC_SHA(26, SSLVersion.SSL_3_0),
    TLS_DH_anon_WITH_DES_CBC_SHA(26, SSLVersion.SSL_3_0),
    SSL3_DH_ANON_WITH_3DES_EDE_CBC_SHA(27, SSLVersion.SSL_3_0),
    TLS_DH_anon_WITH_3DES_EDE_CBC_SHA(27, SSLVersion.SSL_3_0),
    SSL3_FORTEZZA_DMS_WITH_NULL_SHA(28, SSLVersion.SSL_3_0),
    SSL3_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA(29, SSLVersion.SSL_3_0),
    SSL3_FORTEZZA_DMS_WITH_RC4_128_SHA(30, SSLVersion.SSL_3_0),
    SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA(65279, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    SSL_RSA_FIPS_WITH_DES_CBC_SHA(65278, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA(98, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_RSA_EXPORT1024_WITH_RC4_56_SHA(100, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA(99, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA(101, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_DHE_DSS_WITH_RC4_128_SHA(102, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256(103, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256(106, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256(107, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_AES_128_CBC_SHA(47, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA(48, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA(49, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA(50, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA(51, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_ANON_WITH_AES_128_CBC_SHA(52, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_DH_anon_WITH_AES_128_CBC_SHA(52, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_RSA_WITH_AES_256_CBC_SHA(53, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA(54, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA(55, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA(56, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA(57, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_ANON_WITH_AES_256_CBC_SHA(58, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_anon_WITH_AES_256_CBC_SHA(58, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_NULL_SHA256(59, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_AES_128_CBC_SHA256(60, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_AES_256_CBC_SHA256(61, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256(65, new SSLVersion[]{SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA(65, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA(66, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA(67, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA(68, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA(69, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA(70, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA(70, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA(132, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA(133, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA(134, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA(135, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA(136, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA(137, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA(137, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_RSA_WITH_SEED_CBC_SHA(150, new SSLVersion[]{SSLVersion.SSL_3_0, SSLVersion.TLS_1_0}),
    TLS_RSA_WITH_AES_128_GCM_SHA256(156, SSLVersion.TLS_1_2),
    TLS_RSA_WITH_AES_256_GCM_SHA384(157, SSLVersion.TLS_1_2),
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256(158, SSLVersion.TLS_1_2),
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384(159, SSLVersion.TLS_1_2),
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256(162, SSLVersion.TLS_1_2),
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384(163, SSLVersion.TLS_1_2),
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256(170, SSLVersion.TLS_1_2),
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384(171, SSLVersion.TLS_1_2),
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV(255),
    TLS_FALLBACK_SCSV(22016),
    TLS_ECDH_ECDSA_WITH_NULL_SHA(49153, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA(49154, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA(49155, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA(49156, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA(49157, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_ECDSA_WITH_NULL_SHA(49158, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA(49159, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA(49160, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1}),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA(49161, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_RSA_WITH_NULL_SHA(49163, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_RSA_WITH_RC4_128_SHA(49164, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA(49165, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA(49166, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA(49167, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_RSA_WITH_NULL_SHA(49168, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_RSA_WITH_RC4_128_SHA(49169, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA(49170, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA(49171, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(49172, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_anon_WITH_NULL_SHA(49173, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_anon_WITH_RC4_128_SHA(49174, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA(49175, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_anon_WITH_AES_128_CBC_SHA(49176, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDH_anon_WITH_AES_256_CBC_SHA(49177, true, new SSLVersion[]{SSLVersion.TLS_1_0, SSLVersion.TLS_1_1, SSLVersion.TLS_1_2}),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(49188, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256(49191, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384(49192, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(49196, true, SSLVersion.TLS_1_2),
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256(49197, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(49199, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(49200, true, SSLVersion.TLS_1_2),
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256(49201, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52392, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52393, true, SSLVersion.TLS_1_2),
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52394, SSLVersion.TLS_1_2),
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52396, true, SSLVersion.TLS_1_2),
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52397, SSLVersion.TLS_1_2),
    TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256(53249, true, SSLVersion.TLS_1_2),
    TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384(53250, true, SSLVersion.TLS_1_2),
    TLS_AES_128_GCM_SHA256(4865, false, SSLVersion.TLS_1_3),
    TLS_AES_256_GCM_SHA384(4866, false, SSLVersion.TLS_1_3),
    TLS_CHACHA20_POLY1305_SHA256(4867, false, SSLVersion.TLS_1_3);

    private int id;
    private boolean ecc;
    private SSLVersion[] versions;
    private boolean supported;

    private SSLCipher(int id) {
        this(id, false, (SSLVersion[])null);
    }

    private SSLCipher(int id, SSLVersion version) {
        this(id, false, new SSLVersion[]{version});
    }

    private SSLCipher(int id, SSLVersion[] versions) {
        this(id, false, versions);
    }

    private SSLCipher(int id, boolean ecc, SSLVersion version) {
        this(id, ecc, new SSLVersion[]{version});
    }

    private SSLCipher(int id, boolean ecc, SSLVersion[] versions) {
        this.id = id;
        this.ecc = ecc;
        this.versions = versions;
        this.supported = SSLCipher.checkSupportedStatus(id);
    }

    private static native boolean checkSupportedStatus(int var0);

    public int getID() {
        return this.id;
    }

    public boolean isECC() {
        return this.ecc;
    }

    public boolean supportsTLSVersion(SSLVersion v) {
        if (this.versions == null) {
            return false;
        }
        for (SSLVersion version : this.versions) {
            if (version != v) continue;
            return true;
        }
        return false;
    }

    public boolean isTLSv12() {
        return this.supportsTLSVersion(SSLVersion.TLS_1_2);
    }

    public boolean isTLSv13() {
        return this.supportsTLSVersion(SSLVersion.TLS_1_3);
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean requiresRSACert() {
        return this.name().contains("_RSA_") && !this.name().contains("ECDH_RSA");
    }

    public boolean requiresECDSACert() {
        return this.name().contains("_ECDSA_") || this.name().contains("ECDH_RSA");
    }

    public boolean requiresDSSCert() {
        return this.name().contains("_DSS_");
    }

    public static SSLCipher valueOf(int id) {
        for (SSLCipher cipher : (SSLCipher[])SSLCipher.class.getEnumConstants()) {
            if (cipher.id != id) continue;
            return cipher;
        }
        return null;
    }
}

