/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import org.mozilla.jss.crypto.CMACAlgorithm;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.KBKDFDataParameter;
import org.mozilla.jss.crypto.KBKDFDerivedKey;
import org.mozilla.jss.crypto.PKCS11Algorithm;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.PK11SymKey;
import org.mozilla.jss.util.NativeEnclosure;

public abstract class KBKDFParameterSpec
extends NativeEnclosure
implements AlgorithmParameterSpec,
KeySpec {
    public PK11SymKey prfKey;
    public long derivedKeyAlgorithm;
    public int keySize;
    protected long prf;
    protected KBKDFDataParameter[] params;
    protected KBKDFDerivedKey[] additional_keys;

    public void setPRF(PKCS11Algorithm prf) throws IllegalArgumentException {
        this.prf = prf.getValue();
    }

    public void setPRF(DigestAlgorithm prf) throws IllegalArgumentException {
        if (!(prf instanceof HMACAlgorithm) && !(prf instanceof CMACAlgorithm)) {
            Object msg = "Unknown pseudo-random function type: expected ";
            msg = (String)msg + "either HMAC or CMAC algorithms. Got: ";
            msg = (String)msg + prf.getClass().getName();
            throw new IllegalArgumentException((String)msg);
        }
        this.prf = prf.getEnum().getValue();
    }

    public void setPRF(long prf) {
        this.prf = prf;
    }

    public void setPRFKey(SecretKey key) throws InvalidKeyException {
        if (key instanceof PK11SymKey) {
            this.prfKey = (PK11SymKey)key;
            return;
        }
        if (key instanceof SecretKeyFacade) {
            this.setPRFKey(((SecretKeyFacade)key).key);
            return;
        }
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(key.getAlgorithm(), "Mozilla-JSS");
            SecretKey translated = skf.translateKey(key);
            if (translated instanceof SymmetricKey) {
                this.setPRFKey(translated);
                return;
            }
            if (translated instanceof SecretKeyFacade) {
                this.setPRFKey(((SecretKeyFacade)translated).key);
                return;
            }
            Object msg = "Expected key to become an instance of ";
            msg = (String)msg + "org.mozilla.jss.crypto.SymmetricKey or ";
            msg = (String)msg + "org.mozilla.jss.crypto.SecretKeyFacade after ";
            msg = (String)msg + "translation, but got: ";
            msg = (String)msg + translated.getClass().getName();
            throw new InvalidKeyException((String)msg);
        }
        catch (Exception excep) {
            throw new InvalidKeyException("Unable to import key: " + excep.getMessage(), excep);
        }
    }

    public void setDerivedKeyAlgorithm(PKCS11Algorithm algo) throws IllegalArgumentException {
        if (algo == null) {
            String msg = "Expected non-null PKCS11Algorithm value, but was null.";
            throw new IllegalArgumentException(msg);
        }
        this.derivedKeyAlgorithm = algo.getValue();
    }

    public void setDerivedKeyAlgorithm(long algo) throws IllegalArgumentException {
        this.derivedKeyAlgorithm = algo;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public void setParameters(KBKDFDataParameter[] params) throws IllegalArgumentException {
        if (params == null) {
            Object msg = "Expected populated array of KBKDFDataParameters, ";
            msg = (String)msg + "but was null.";
            throw new IllegalArgumentException((String)msg);
        }
        this.params = params;
    }

    public void addParameter(KBKDFDataParameter param) throws IllegalArgumentException {
        if (param == null) {
            Object msg = "Expected non-null instance of KBKDFDataParameters, ";
            msg = (String)msg + "but was null.";
            throw new IllegalArgumentException((String)msg);
        }
        ArrayList<Object> data_params = this.params == null ? new ArrayList<KBKDFDataParameter>(1) : new ArrayList<KBKDFDataParameter>(Arrays.asList(this.params));
        data_params.add(param);
        this.params = data_params.toArray(new KBKDFDataParameter[data_params.size()]);
    }

    public void setAdditionalDerivedKeys(KBKDFDerivedKey[] additional_keys) throws IllegalArgumentException {
        if (additional_keys == null) {
            Object msg = "Expected populated array of KBKDFDerivedKey, ";
            msg = (String)msg + "but was null.";
            throw new IllegalArgumentException((String)msg);
        }
        this.additional_keys = additional_keys;
    }

    public void addAdditionalDerivedKey(KBKDFDerivedKey derived_key) throws IllegalArgumentException {
        if (derived_key == null) {
            Object msg = "Expected non-null instance of KBKDFDerivedKey, ";
            msg = (String)msg + "but was null.";
            throw new IllegalArgumentException((String)msg);
        }
        ArrayList<Object> keys = this.additional_keys == null ? new ArrayList<KBKDFDerivedKey>(1) : new ArrayList<KBKDFDerivedKey>(Arrays.asList(this.additional_keys));
        keys.add(derived_key);
        this.additional_keys = keys.toArray(new KBKDFDerivedKey[keys.size()]);
    }

    @Override
    protected void acquireNativeResources() throws Exception {
        this.validateParameters();
        if (this.params != null) {
            for (NativeEnclosure nativeEnclosure : this.params) {
                nativeEnclosure.open();
            }
        }
        if (this.additional_keys != null) {
            for (NativeEnclosure nativeEnclosure : this.additional_keys) {
                nativeEnclosure.open();
            }
        }
        this.acquireNativeResourcesInternal();
    }

    @Override
    protected void releaseNativeResources() throws Exception {
        if (this.additional_keys != null) {
            for (NativeEnclosure nativeEnclosure : this.additional_keys) {
                nativeEnclosure.close();
            }
        }
        if (this.params != null) {
            for (NativeEnclosure nativeEnclosure : this.params) {
                nativeEnclosure.close();
            }
        }
        this.releaseNativeResourcesInternal();
    }

    protected abstract void acquireNativeResourcesInternal() throws Exception;

    protected abstract void releaseNativeResourcesInternal() throws Exception;

    protected abstract void validateParameters() throws IllegalArgumentException;
}

