/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class IA5CharsetDecoder
extends CharsetDecoder {
    public IA5CharsetDecoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.remaining() >= 1) {
            in.mark();
            byte b = in.get();
            if (CodingErrorAction.REPORT == this.unmappableCharacterAction() && (b & 0x80) != 0) {
                return CoderResult.unmappableForLength(1);
            }
            if (out.remaining() < 1) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
            out.put((char)(b & 0x7F));
        }
        return CoderResult.UNDERFLOW;
    }
}

