/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.AVAValueConverter;
import org.mozilla.jss.netscape.security.x509.GenericValueConverter;
import org.mozilla.jss.netscape.security.x509.LdapDNStrConverter;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;

public class LdapV3DNStrConverter
extends LdapDNStrConverter {
    protected X500NameAttrMap attrMap;
    protected boolean acceptUnknownOids;
    protected static final String specialChars = ",+=<>#;";
    protected static final String valueEndChars = "+,;>";
    protected static final String quotedEndChars = "\"";
    protected static final String octoEndChars = " +,;>";
    protected static final String hexDigits = "0123456789ABCDEFabcdef";

    public LdapV3DNStrConverter() {
        this.attrMap = X500NameAttrMap.getDefault();
        this.acceptUnknownOids = true;
    }

    public LdapV3DNStrConverter(X500NameAttrMap attributeMap, boolean doAcceptUnknownOids) {
        this.attrMap = attributeMap;
        this.acceptUnknownOids = doAcceptUnknownOids;
    }

    @Override
    public X500Name parseDN(String dn) throws IOException {
        return this.parseDN(dn, null);
    }

    @Override
    public X500Name parseDN(String dn, byte[] encodingOrder) throws IOException {
        StringReader dn_reader = new StringReader(dn);
        PushbackReader in = new PushbackReader(dn_reader, 5);
        return this.parseDN(in, encodingOrder);
    }

    @Override
    public RDN parseRDN(String rdn) throws IOException {
        return this.parseRDN(rdn, null);
    }

    @Override
    public RDN parseRDN(String rdn, byte[] encodingOrder) throws IOException {
        StringReader rdn_reader = new StringReader(rdn);
        PushbackReader in = new PushbackReader(rdn_reader, 5);
        return this.parseRDN(in, null);
    }

    @Override
    public AVA parseAVA(String ava) throws IOException {
        return this.parseAVA(ava, null);
    }

    @Override
    public AVA parseAVA(String ava, byte[] encodingOrder) throws IOException {
        StringReader ava_reader = new StringReader(ava);
        PushbackReader in = new PushbackReader(ava_reader, 5);
        return this.parseAVA(in, encodingOrder);
    }

    public X500Name parseDN(PushbackReader in) throws IOException {
        return this.parseDN(in, null);
    }

    public X500Name parseDN(PushbackReader in, byte[] encodingOrder) throws IOException {
        int lastChar;
        Vector<RDN> rdnVector = new Vector<RDN>();
        do {
            RDN rdn = this.parseRDN(in, encodingOrder);
            rdnVector.addElement(rdn);
        } while ((lastChar = in.read()) == 44 || lastChar == 59);
        RDN[] names = new RDN[rdnVector.size()];
        int i = 0;
        int j = rdnVector.size() - 1;
        while (i < rdnVector.size()) {
            names[j] = (RDN)rdnVector.elementAt(i);
            ++i;
            --j;
        }
        return new X500Name(names);
    }

    public RDN parseRDN(PushbackReader in) throws IOException {
        return this.parseRDN(in, null);
    }

    public RDN parseRDN(PushbackReader in, byte[] encodingOrder) throws IOException {
        int lastChar;
        Vector<AVA> avaVector = new Vector<AVA>();
        do {
            AVA ava = this.parseAVA(in, encodingOrder);
            avaVector.addElement(ava);
        } while ((lastChar = in.read()) == 43);
        if (lastChar != -1) {
            in.unread(lastChar);
        }
        AVA[] assertion = new AVA[avaVector.size()];
        for (int i = 0; i < avaVector.size(); ++i) {
            assertion[i] = (AVA)avaVector.elementAt(i);
        }
        return new RDN(assertion);
    }

    public AVA parseAVA(PushbackReader in) throws IOException {
        return this.parseAVA(in, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AVA parseAVA(PushbackReader in, byte[] encodingOrder) throws IOException {
        DerValue value;
        int c;
        StringBuffer keywordBuf = new StringBuffer();
        while ((c = in.read()) != 61) {
            if (c == -1) {
                throw new IOException("Bad AVA format: Missing '='");
            }
            keywordBuf.append((char)c);
        }
        ObjectIdentifier oid = this.parseAVAKeyword(keywordBuf.toString());
        c = in.read();
        while (c == 32) {
            c = in.read();
        }
        if (c == -1) {
            throw new IOException("Bad AVA format: Missing attribute value");
        }
        if (c == 35) {
            ByteArrayOutputStream berStream = new ByteArrayOutputStream();
            while (true) {
                c = in.read();
                char hexChar1 = (char)c;
                if (c == -1 || octoEndChars.indexOf(c) > 0) break;
                c = in.read();
                char hexChar2 = (char)c;
                if (hexDigits.indexOf(hexChar1) == -1 || hexDigits.indexOf(hexChar2) == -1) {
                    throw new IOException("Bad AVA value: bad hex value.");
                }
                int b = (Character.digit(hexChar1, 16) << 4) + Character.digit(hexChar2, 16);
                berStream.write(b);
            }
            if (berStream.size() == 0) {
                throw new IOException("bad AVA format: invalid hex value");
            }
            value = this.parseAVAValue(berStream.toByteArray(), oid);
            while (c == 32 && c != -1) {
                c = in.read();
            }
        } else {
            String endChars;
            StringBuffer valueBuf = new StringBuffer();
            boolean quoted = false;
            if (c == 34) {
                quoted = true;
                endChars = quotedEndChars;
                c = in.read();
                if (c == -1) {
                    throw new IOException("Bad AVA format: Missing attrValue");
                }
            } else {
                endChars = valueEndChars;
            }
            while (c != -1 && endChars.indexOf(c) == -1) {
                if (c == 92) {
                    c = in.read();
                    if (c == -1) {
                        throw new IOException("Bad AVA format: expecting escaped char.");
                    }
                    if (specialChars.indexOf((char)c) != -1 || c == 10 || c == 92 || c == 34 || c == 32) {
                        valueBuf.append((char)c);
                    } else {
                        CharArrayWriter hexCharsBuf;
                        block25: {
                            if (hexDigits.indexOf(c) == -1) throw new IOException("Bad AVA format: invalid escaping");
                            hexCharsBuf = new CharArrayWriter();
                            do {
                                char hexChar1 = (char)c;
                                c = in.read();
                                char hexChar2 = (char)c;
                                if (hexDigits.indexOf((char)c) == -1) {
                                    throw new IOException("Bad AVA format: invalid escaped hex pair");
                                }
                                hexCharsBuf.write(hexChar1);
                                hexCharsBuf.write(hexChar2);
                                c = in.read();
                                if (c == -1) break block25;
                                if (c != 92) {
                                    in.unread(c);
                                    break block25;
                                }
                                c = in.read();
                                if (c != -1) continue;
                                throw new IOException("Bad AVA format: expecting escaped char.");
                            } while (hexDigits.indexOf((char)c) != -1);
                            in.unread(c);
                            in.unread(92);
                        }
                        valueBuf.append(LdapV3DNStrConverter.getStringFromHexpairs(hexCharsBuf.toCharArray()));
                    }
                } else {
                    valueBuf.append((char)c);
                }
                c = in.read();
            }
            value = this.parseAVAValue(valueBuf.toString().trim(), oid, encodingOrder);
            if (quoted) {
                while ((c = in.read()) == 32) {
                }
                if (c != -1 && valueEndChars.indexOf(c) == -1) {
                    throw new IOException("Bad AVA format: separator expected at end of ava.");
                }
            }
        }
        if (c == -1) return new AVA(oid, value);
        in.unread(c);
        return new AVA(oid, value);
    }

    public ObjectIdentifier parseAVAKeyword(String avaKeyword) throws IOException {
        ObjectIdentifier oid;
        String keyword = avaKeyword.toUpperCase().trim();
        String oid_str = null;
        if (Character.digit(keyword.charAt(0), 10) != -1) {
            oid_str = keyword;
        } else if (keyword.startsWith("oid.") || keyword.startsWith("OID.")) {
            oid_str = keyword.substring(4);
        }
        if (oid_str != null) {
            ObjectIdentifier new_oid = new ObjectIdentifier(oid_str);
            oid = this.attrMap.getOid(new_oid);
            if (oid == null) {
                if (!this.acceptUnknownOids) {
                    throw new IOException("Unknown AVA OID.");
                }
                oid = new_oid;
            }
        } else {
            oid = this.attrMap.getOid(keyword);
            if (oid == null) {
                throw new IOException("Unknown AVA keyword '" + keyword + "'.");
            }
        }
        return oid;
    }

    public DerValue parseAVAValue(String avaValueString, ObjectIdentifier oid) throws IOException {
        return this.parseAVAValue(avaValueString, oid, null);
    }

    public DerValue parseAVAValue(String avaValueString, ObjectIdentifier oid, byte[] encodingOrder) throws IOException {
        AVAValueConverter valueConverter = this.attrMap.getValueConverter(oid);
        if (valueConverter == null) {
            if (!this.acceptUnknownOids) {
                throw new IllegalArgumentException("Unrecognized OID for AVA value conversion");
            }
            valueConverter = new GenericValueConverter();
        }
        return valueConverter.getValue(avaValueString, encodingOrder);
    }

    public DerValue parseAVAValue(byte[] berValue, ObjectIdentifier oid) throws IOException {
        AVAValueConverter valueConverter = this.attrMap.getValueConverter(oid);
        if (valueConverter == null && !this.acceptUnknownOids) {
            throw new IllegalArgumentException("Unrecognized OID for AVA value conversion");
        }
        valueConverter = new GenericValueConverter();
        return valueConverter.getValue(berValue);
    }

    @Override
    public String encodeDN(X500Name x500name) throws IOException {
        RDN[] rdns = x500name.getNames();
        StringBuffer fullname = new StringBuffer();
        if (rdns.length == 0) {
            return "";
        }
        int i = rdns.length - 1;
        fullname.append(this.encodeRDN(rdns[i--]));
        while (i >= 0) {
            String s = this.encodeRDN(rdns[i--]);
            fullname.append(",");
            fullname.append(s);
        }
        return fullname.toString();
    }

    @Override
    public String encodeRDN(RDN rdn) throws IOException {
        AVA[] avas = rdn.getAssertion();
        StringBuffer relname = new StringBuffer();
        int i = 0;
        relname.append(this.encodeAVA(avas[i++]));
        while (i < avas.length) {
            String s = this.encodeAVA(avas[i++]);
            relname.append("+");
            relname.append(s);
        }
        return relname.toString();
    }

    @Override
    public String encodeAVA(AVA ava) throws IOException {
        if (ava == null) {
            return "";
        }
        ObjectIdentifier oid = ava.getOid();
        DerValue value = ava.getValue();
        String keyword = this.encodeOID(oid);
        String valueStr = this.encodeValue(value, oid);
        return keyword + "=" + valueStr;
    }

    public String encodeOID(ObjectIdentifier oid) throws IOException {
        String keyword = this.attrMap.getName(oid);
        if (keyword == null) {
            if (this.acceptUnknownOids) {
                keyword = oid.toString();
            } else {
                throw new IOException("Unknown OID");
            }
        }
        return keyword;
    }

    public String encodeValue(DerValue attrValue, ObjectIdentifier oid) throws IOException {
        AVAValueConverter valueConverter;
        StringBuffer retval = new StringBuffer(30);
        String temp = null;
        X500NameAttrMap lAttrMap = this.attrMap;
        if (attrValue.tag == 12) {
            lAttrMap = X500NameAttrMap.getDirDefault();
        }
        if ((valueConverter = lAttrMap.getValueConverter(oid)) == null) {
            if (this.acceptUnknownOids) {
                valueConverter = new GenericValueConverter();
            } else {
                throw new IOException("Unknown AVA type for encoding AVA value");
            }
        }
        try {
            temp = valueConverter.getAsString(attrValue);
            if (temp == null) {
                byte[] data = attrValue.toByteArray();
                retval.append('#');
                for (int i = 0; i < data.length; ++i) {
                    retval.append(hexDigits.charAt(data[i] >> 4 & 0xF));
                    retval.append(hexDigits.charAt(data[i] & 0xF));
                }
            } else {
                retval.append(this.encodeString(temp));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("malformed AVA DER Value");
        }
        return retval.toString();
    }

    public String encodeString(String valueStr) {
        int i;
        int j;
        StringBuffer retval = new StringBuffer();
        int len = valueStr.length();
        for (j = len - 1; j >= 0 && valueStr.charAt(j) == ' '; --j) {
        }
        for (i = 0; i <= j && valueStr.charAt(i) == ' '; ++i) {
            retval.append('\\');
            retval.append(valueStr.charAt(i));
        }
        while (i <= j) {
            if (valueStr.charAt(i) == '\\') {
                retval.append('\\');
                retval.append(valueStr.charAt(i));
            } else if (specialChars.indexOf(valueStr.charAt(i)) != -1) {
                retval.append('\\');
                retval.append(valueStr.charAt(i));
            } else if (valueStr.charAt(i) == '\"') {
                retval.append('\\');
                retval.append(valueStr.charAt(i));
            } else {
                retval.append(valueStr.charAt(i));
            }
            ++i;
        }
        while (i < valueStr.length()) {
            retval.append('\\');
            retval.append(' ');
            ++i;
        }
        return retval.toString();
    }

    public X500NameAttrMap getAttrMap() {
        return this.attrMap;
    }

    public boolean getAcceptUnknownOids() {
        return this.acceptUnknownOids;
    }

    protected static char[] getStringFromHexpairs(char[] hexPairs) throws UnsupportedEncodingException {
        try {
            byte[] buffer = new byte[hexPairs.length / 2];
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = (byte)((Character.digit(hexPairs[i * 2], 16) << 4) + Character.digit(hexPairs[i * 2 + 1], 16));
            }
            Charset charset = Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(buffer));
            return Arrays.copyOfRange(charBuffer.array(), charBuffer.arrayOffset(), charBuffer.arrayOffset() + charBuffer.limit());
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException("No UTF8 byte to char converter to use for parsing LDAP DN String");
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Invalid hex pair in LDAP DN String.");
        }
    }
}

