/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class SubjectKeyIdentifierExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 2457721262590880939L;
    public static final String IDENT = "x509.info.extensions.SubjectKeyIdentifier";
    public static final String NAME = "SubjectKeyIdentifier";
    public static final String KEY_ID = "key_id";
    private KeyIdentifier id;

    private void encodeThis() throws IOException {
        DerOutputStream os = new DerOutputStream();
        this.id.encode(os);
        this.extensionValue = os.toByteArray();
    }

    public SubjectKeyIdentifierExtension(boolean critical, byte[] octetString) throws IOException {
        this.id = new KeyIdentifier(octetString);
        this.extensionId = PKIXExtensions.SubjectKey_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public SubjectKeyIdentifierExtension(byte[] octetString) throws IOException {
        this.id = new KeyIdentifier(octetString);
        this.extensionId = PKIXExtensions.SubjectKey_Id;
        this.critical = false;
        this.encodeThis();
    }

    public SubjectKeyIdentifierExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.SubjectKey_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.id = new KeyIdentifier(val);
    }

    @Override
    public String toString() {
        if (this.id == null) {
            return "";
        }
        String s = super.toString() + "SubjectKeyIdentifier [\n" + this.id.toString() + "]\n";
        return s;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectKey_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (name.equalsIgnoreCase(KEY_ID)) {
            if (!(obj instanceof KeyIdentifier)) {
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectKeyIdentifierExtension.");
        }
        this.id = (KeyIdentifier)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(KEY_ID)) {
            return this.id;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectKeyIdentifierExtension.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(KEY_ID)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:SubjectKeyIdentifierExtension.");
        }
        this.id = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(KEY_ID);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

