/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.DirStrConverter;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.LdapDNStrConverter;
import org.mozilla.jss.netscape.security.x509.PrintableConverter;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;

public class X500Name
implements Principal,
GeneralNameInterface {
    private static final long serialVersionUID = -730790062013191108L;
    private String dn;
    private RDN[] names;
    public static final ObjectIdentifier commonName_oid = X500NameAttrMap.getDefault().getOid("CN");
    public static final ObjectIdentifier uidName_oid = X500NameAttrMap.getDefault().getOid("UID");
    public static final ObjectIdentifier countryName_oid = X500NameAttrMap.getDefault().getOid("C");
    public static final ObjectIdentifier localityName_oid = X500NameAttrMap.getDefault().getOid("L");
    public static final ObjectIdentifier orgName_oid = X500NameAttrMap.getDefault().getOid("O");
    public static final ObjectIdentifier orgUnitName_oid = X500NameAttrMap.getDefault().getOid("OU");
    public static final ObjectIdentifier stateName_oid = X500NameAttrMap.getDefault().getOid("ST");
    public static final ObjectIdentifier streetAddress_oid = X500NameAttrMap.getDefault().getOid("STREET");
    public static final ObjectIdentifier title_oid = X500NameAttrMap.getDefault().getOid("TITLE");
    public static final ObjectIdentifier email_oid = X500NameAttrMap.getDefault().getOid("E");
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    public static final ObjectIdentifier ipAddress_oid = new ObjectIdentifier(ipAddress_data);

    public X500Name(String ldapDNString) throws IOException {
        if (ldapDNString == null || ldapDNString.equals("")) {
            this.clear();
            return;
        }
        X500Name x500name = LdapDNStrConverter.getDefault().parseDN(ldapDNString);
        this.names = x500name.getNames();
    }

    public X500Name(String ldapDNString, LdapDNStrConverter ldapDNStrConverter, byte[] tags) throws IOException {
        if (ldapDNString == null || ldapDNString.equals("")) {
            this.clear();
            return;
        }
        X500Name x500name = ldapDNStrConverter.parseDN(ldapDNString, tags);
        this.names = x500name.getNames();
    }

    public X500Name(String ldapDNString, byte[] tags) throws IOException {
        if (ldapDNString == null || ldapDNString.equals("")) {
            this.clear();
            return;
        }
        X500Name x500name = LdapDNStrConverter.getDefault().parseDN(ldapDNString, tags);
        this.names = x500name.getNames();
    }

    public X500Name(String ldapDNString, LdapDNStrConverter ldapDNStrConverter) throws IOException {
        if (ldapDNString == null || ldapDNString.equals("")) {
            this.clear();
            return;
        }
        X500Name x500name = ldapDNStrConverter.parseDN(ldapDNString);
        this.names = x500name.getNames();
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String country) throws IOException {
        DirStrConverter dirStrConverter = new DirStrConverter();
        PrintableConverter printableConverter = new PrintableConverter();
        AVA[] assertion = new AVA[1];
        int i = 4;
        this.names = new RDN[i];
        assertion[0] = new AVA(commonName_oid, dirStrConverter.getValue(commonName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgUnitName_oid, dirStrConverter.getValue(organizationUnit));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgName_oid, dirStrConverter.getValue(organizationName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(countryName_oid, printableConverter.getValue(country));
        this.names[--i] = new RDN(assertion);
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String country) throws IOException {
        DirStrConverter dirStrConverter = new DirStrConverter();
        PrintableConverter printableConverter = new PrintableConverter();
        AVA[] assertion = new AVA[1];
        int i = 6;
        this.names = new RDN[i];
        assertion[0] = new AVA(commonName_oid, dirStrConverter.getValue(commonName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgUnitName_oid, dirStrConverter.getValue(organizationUnit));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(orgName_oid, dirStrConverter.getValue(organizationName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(localityName_oid, dirStrConverter.getValue(localityName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(stateName_oid, dirStrConverter.getValue(stateName));
        this.names[--i] = new RDN(assertion);
        assertion[0] = new AVA(countryName_oid, printableConverter.getValue(country));
        this.names[--i] = new RDN(assertion);
    }

    public X500Name(DerValue value) throws IOException {
        this(value.toDerInputStream());
    }

    public X500Name(DerInputStream in) throws IOException {
        this.parseDER(in);
    }

    public X500Name(byte[] name) throws IOException {
        DerInputStream in = new DerInputStream(name);
        this.parseDER(in);
    }

    public X500Name(RDN[] rdns) {
        this.names = (RDN[])rdns.clone();
    }

    public X500Name(Vector<RDN> rdnVector) {
        int size = rdnVector.size();
        this.names = new RDN[size];
        for (int i = 0; i < size; ++i) {
            this.names[i] = rdnVector.elementAt(i);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.names);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X500Name other = (X500Name)obj;
        return Arrays.equals(this.names, other.names);
    }

    private void clear() {
        this.dn = "";
        this.names = null;
    }

    private String getString(DerValue attribute) throws IOException {
        if (attribute == null) {
            throw new IOException("Null attribute not valid");
        }
        String value = attribute.getAsString();
        if (value == null) {
            throw new IOException("not a DER string encoding, " + attribute.tag);
        }
        return value;
    }

    @Override
    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue attr = this.findAttribute(countryName_oid);
        return this.getString(attr);
    }

    public String getOrganization() throws IOException {
        DerValue attr = this.findAttribute(orgName_oid);
        return this.getString(attr);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue attr = this.findAttribute(orgUnitName_oid);
        return this.getString(attr);
    }

    public String getCommonName() throws IOException {
        DerValue attr = this.findAttribute(commonName_oid);
        return this.getString(attr);
    }

    public String getUserID() throws IOException {
        DerValue attr = this.findAttribute(uidName_oid);
        return this.getString(attr);
    }

    public String getLocality() throws IOException {
        DerValue attr = this.findAttribute(localityName_oid);
        return this.getString(attr);
    }

    public String getState() throws IOException {
        DerValue attr = this.findAttribute(stateName_oid);
        return this.getString(attr);
    }

    public String getEmail() throws IOException {
        DerValue attr = this.findAttribute(email_oid);
        if (attr == null) {
            return null;
        }
        return this.getString(attr);
    }

    public String toLdapDNString() throws IOException {
        if (this.dn == null) {
            this.generateDN(LdapDNStrConverter.getDefault());
        }
        return this.dn;
    }

    public List<String> getAttributesForOid(ObjectIdentifier oid) throws IOException {
        ArrayList<String> xs = new ArrayList<String>();
        for (int i = 0; i < this.names.length; ++i) {
            DerValue v = this.names[i].findAttribute(oid);
            if (v == null) continue;
            xs.add(this.getString(v));
        }
        return xs;
    }

    public String toLdapDNString(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        if (this.dn == null) {
            this.generateDN(ldapDNStrConverter);
        }
        return this.dn;
    }

    @Override
    public String toString() {
        String s;
        if (this.names == null) {
            String s2 = "";
            return s2;
        }
        try {
            s = this.toLdapDNString();
        }
        catch (IOException e) {
            return "";
        }
        return s;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier attribute) {
        DerValue retval = null;
        for (int i = 0; i < this.names.length && (retval = this.names[i].findAttribute(attribute)) == null; ++i) {
        }
        return retval;
    }

    public Enumeration<RDN> getRDNs() {
        return new RDNEnumerator();
    }

    public RDN[] getNames() {
        return (RDN[])this.names.clone();
    }

    public int getNamesLength() {
        return this.names.length;
    }

    private void parseDER(DerInputStream in) throws IOException {
        DerValue[] nameseq = in.getSequence(5);
        if (nameseq.length != 0) {
            this.names = new RDN[nameseq.length];
        } else {
            this.clear();
        }
        for (int i = 0; i < nameseq.length; ++i) {
            this.names[i] = new RDN(nameseq[i]);
        }
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        int len = 0;
        len = this.names == null ? 0 : this.names.length;
        for (int i = 0; i < len; ++i) {
            this.names[i].encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    public byte[] getEncoded() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            int len = 0;
            len = this.names == null ? 0 : this.names.length;
            for (int i = 0; i < len; ++i) {
                this.names[i].encode(tmp);
            }
            out.write((byte)48, tmp);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private void generateDN(LdapDNStrConverter ldapDNStrConverter) throws IOException {
        if (this.names == null) {
            return;
        }
        this.dn = ldapDNStrConverter.encodeDN(this);
    }

    static ObjectIdentifier intern(ObjectIdentifier oid) throws IOException {
        return X500NameAttrMap.getDefault().getOid(oid);
    }

    private class RDNEnumerator
    implements Enumeration<RDN> {
        private int index = 0;

        @Override
        public boolean hasMoreElements() {
            return this.index < X500Name.this.names.length;
        }

        @Override
        public RDN nextElement() {
            if (this.index >= X500Name.this.names.length) {
                return null;
            }
            return X500Name.this.names[this.index++];
        }
    }
}

