/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.CMACAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.SignatureAlgorithm;

public final class KeyType {
    protected Algorithm[] algorithms;
    protected String name;
    protected static Hashtable<Algorithm, KeyType> algHash = new Hashtable();
    public static final KeyType NULL = new KeyType(new Algorithm[0], "NULL");
    public static final KeyType RSA = new KeyType(new Algorithm[]{SignatureAlgorithm.RSASignature, SignatureAlgorithm.RSASignatureWithMD2Digest, SignatureAlgorithm.RSASignatureWithMD5Digest, SignatureAlgorithm.RSASignatureWithSHA1Digest, SignatureAlgorithm.RSASignatureWithSHA256Digest, SignatureAlgorithm.RSASignatureWithSHA384Digest, SignatureAlgorithm.RSASignatureWithSHA512Digest, SignatureAlgorithm.RSAPSSSignature, SignatureAlgorithm.RSAPSSSignatureWithSHA256Digest, SignatureAlgorithm.RSAPSSSignatureWithSHA384Digest, SignatureAlgorithm.RSAPSSSignatureWithSHA512Digest, KeyWrapAlgorithm.RSA, KeyWrapAlgorithm.RSA_OAEP}, "RSA");
    public static final KeyType DSA = new KeyType(new Algorithm[]{SignatureAlgorithm.DSASignature, SignatureAlgorithm.DSASignatureWithSHA1Digest}, "DSA");
    public static final KeyType EC = new KeyType(new Algorithm[]{SignatureAlgorithm.ECSignature, SignatureAlgorithm.ECSignatureWithSHA1Digest, SignatureAlgorithm.ECSignatureWithSHA256Digest, SignatureAlgorithm.ECSignatureWithSHA384Digest, SignatureAlgorithm.ECSignatureWithSHA512Digest}, "EC");
    @Deprecated
    public static final KeyType FORTEZZA = new KeyType(new Algorithm[0], "FORTEZZA");
    public static final KeyType DH = new KeyType(new Algorithm[0], "DH");
    public static final KeyType KEA = new KeyType(new Algorithm[0], "KEA");
    public static final KeyType DES = new KeyType(new Algorithm[]{KeyWrapAlgorithm.DES_ECB, KeyWrapAlgorithm.DES_CBC, KeyWrapAlgorithm.DES_CBC_PAD, EncryptionAlgorithm.DES_ECB, EncryptionAlgorithm.DES_CBC, EncryptionAlgorithm.DES_CBC_PAD}, "DES");
    public static final KeyType DES3 = new KeyType(new Algorithm[]{KeyWrapAlgorithm.DES3_ECB, KeyWrapAlgorithm.DES3_CBC, KeyWrapAlgorithm.DES3_CBC_PAD, EncryptionAlgorithm.DES3_ECB, EncryptionAlgorithm.DES3_CBC, EncryptionAlgorithm.DES3_CBC_PAD}, "DESede");
    public static final KeyType AES = new KeyType(new Algorithm[]{KeyWrapAlgorithm.AES_ECB, KeyWrapAlgorithm.AES_CBC, KeyWrapAlgorithm.AES_CBC_PAD, KeyWrapAlgorithm.AES_KEY_WRAP, KeyWrapAlgorithm.AES_KEY_WRAP_PAD, KeyWrapAlgorithm.AES_KEY_WRAP_PAD_KWP, EncryptionAlgorithm.AES_128_ECB, EncryptionAlgorithm.AES_128_CBC, EncryptionAlgorithm.AES_192_ECB, EncryptionAlgorithm.AES_192_CBC, EncryptionAlgorithm.AES_256_ECB, EncryptionAlgorithm.AES_256_CBC, EncryptionAlgorithm.AES_CBC_PAD, EncryptionAlgorithm.AES_128_CBC_PAD, EncryptionAlgorithm.AES_192_CBC_PAD, EncryptionAlgorithm.AES_256_CBC_PAD, CMACAlgorithm.AES}, "AES");
    public static final KeyType RC4 = new KeyType(new Algorithm[]{EncryptionAlgorithm.RC4}, "RC4");
    public static final KeyType RC2 = new KeyType(new Algorithm[]{EncryptionAlgorithm.RC2_CBC, EncryptionAlgorithm.RC2_CBC_PAD}, "RC2");
    @Deprecated(since="5.0.1", forRemoval=true)
    public static final KeyType SHA1_HMAC = new KeyType(new Algorithm[]{HMACAlgorithm.SHA1}, "SHA1_HMAC");
    public static final KeyType SHA256_HMAC = new KeyType(new Algorithm[]{HMACAlgorithm.SHA256}, "SHA256_HMAC");
    public static final KeyType SHA384_HMAC = new KeyType(new Algorithm[]{HMACAlgorithm.SHA384}, "SHA384_HMAC");
    public static final KeyType SHA512_HMAC = new KeyType(new Algorithm[]{HMACAlgorithm.SHA512}, "SHA512_HMAC");
    public static final KeyType GENERIC_SECRET = new KeyType(new Algorithm[0], "GENERIC_SECRET");

    protected KeyType() {
    }

    protected KeyType(Algorithm[] algs, String name) {
        assert (algs != null);
        this.algorithms = (Algorithm[])algs.clone();
        for (int i = 0; i < this.algorithms.length; ++i) {
            assert (!algHash.containsKey(this.algorithms[i]));
            algHash.put(this.algorithms[i], this);
        }
        this.name = name;
    }

    public Algorithm[] supportedAlgorithms() {
        return this.algorithms;
    }

    public static KeyType getKeyTypeFromAlgorithm(Algorithm alg) throws NoSuchAlgorithmException {
        assert (alg != null);
        KeyType obj = algHash.get(alg);
        if (obj == null) {
            throw new NoSuchAlgorithmException();
        }
        assert (obj instanceof KeyType);
        return obj;
    }

    public String toString() {
        return this.name;
    }
}

