/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.util.Assert;

public class RSAPSSAlgorithmParameters
extends AlgorithmParametersSpi {
    public static final AlgorithmId defaultHashAlg = new AlgorithmId(AlgorithmId.SHA_oid);
    public static final AlgorithmId defaultMaskGenFunc = new AlgorithmId(AlgorithmId.MGF1_oid);
    public static final BigInt defaultSaltLen = new BigInt(20);
    public static final BigInt defaultTrailerField = new BigInt(1);
    private PSSParameterSpec spec = PSSParameterSpec.DEFAULT;
    private AlgorithmId hashAlg = defaultHashAlg;
    private AlgorithmId maskGenFunc = defaultMaskGenFunc;
    private BigInt saltLen = defaultSaltLen;
    private BigInt trailerField = defaultTrailerField;

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.spec = (PSSParameterSpec)paramSpec;
        this.populateFromSpec();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.isAssignableFrom(PSSParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.spec));
        }
        throw new InvalidParameterSpecException("Unknown parameter spec passed to PSS parameters object: " + paramSpec.getName());
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.decode(new DerInputStream(params), params);
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        Assert.notReached("engineInit(byte[],String) not supported");
        throw new IOException("engineInit(byte[],String) not supported");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        this.encode(out);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        Assert.notReached("engineGetEncoded(String format)) not supported");
        throw new IOException("engineGetEncoded(String format)) not supported");
    }

    @Override
    protected String engineToString() {
        String str = new String("Mozilla-JSS PSSAlgorithmParameters " + this.getClass().getName() + " HashAlg: " + this.spec.getDigestAlgorithm() + " MaskGenAlg: " + this.spec.getMGFAlgorithm());
        return str;
    }

    private void decode(DerInputStream in, byte[] encoded) throws IOException {
        if (in == null) {
            throw new IOException("Invalid input: got null DerInputStream");
        }
        DerValue[] seq = in.getSequence(3);
        if (seq.length < 3 || seq.length > 4) {
            throw new IOException("Invalid data! Expected a sequence with either 3 or 4 members; got " + seq.length);
        }
        if (!seq[0].isContextSpecific((byte)0)) {
            throw new IOException("Invalid encoded data! Expecting OAEP-PSSDigestAlgorithms (hashAlgorithm).");
        }
        seq[0] = seq[0].data.getDerValue();
        AlgorithmId algid = AlgorithmId.parse(seq[0]);
        String specAlgName = this.getSpecAlgName(algid.getName());
        String specMGF1Name = "";
        MGF1ParameterSpec specMFG1ParamSpec = new MGF1ParameterSpec(specAlgName);
        if (!seq[1].isContextSpecific((byte)1)) {
            throw new IOException("Invalid encoded data! Expecting OAEP-PSSDigestAlgorithms (maskGenAlgorithm).");
        }
        seq[1] = seq[1].data.getDerValue();
        DerInputStream mgf1Str = new DerInputStream(seq[1].toByteArray());
        DerValue[] seqMgf1 = mgf1Str.getSequence(2);
        ObjectIdentifier mgf1OID = seqMgf1[0].getOID();
        if (!mgf1OID.equals(AlgorithmId.MGF1_oid)) {
            throw new IOException("Invalid encoded data: expected MGF1 OID but got: " + mgf1OID.toString());
        }
        specMGF1Name = "MGF1";
        if (!seq[2].isContextSpecific((byte)2)) {
            throw new IOException("Invalid encoded data! Expected INTEGER (saltLength).");
        }
        seq[2] = seq[2].data.getDerValue();
        BigInt sLength = seq[2].getInteger();
        this.spec = new PSSParameterSpec(specAlgName, specMGF1Name, specMFG1ParamSpec, sLength.toInt(), 1);
        this.populateFromSpec();
    }

    private void encode(DerOutputStream out) throws IOException {
        try (DerOutputStream tmp = new DerOutputStream();
             DerOutputStream mgf = new DerOutputStream();
             DerOutputStream seq1 = new DerOutputStream();
             DerOutputStream intStream = new DerOutputStream();){
            this.hashAlg.derEncodeWithContext(tmp, 0);
            mgf.putOID(this.maskGenFunc.getOID());
            this.hashAlg.encode(mgf);
            seq1.write((byte)48, mgf);
            tmp.write(DerValue.createTag((byte)-128, true, (byte)1), seq1);
            intStream.putInteger(this.saltLen);
            tmp.write(DerValue.createTag((byte)-128, true, (byte)2), intStream);
            out.write((byte)48, tmp);
            byte[] byArray = out.toByteArray();
        }
    }

    private void populateFromSpec() {
        if (this.spec == null || this.hashAlg == null) {
            return;
        }
        String hashAlgName = this.spec.getDigestAlgorithm();
        String maskGenName = this.spec.getMGFAlgorithm();
        int saltLen = this.spec.getSaltLength();
        this.saltLen = new BigInt(saltLen);
        int trailer = this.spec.getTrailerField();
        this.hashAlg = hashAlgName.equals("SHA-256") ? new AlgorithmId(AlgorithmId.SHA256_oid) : (hashAlgName.equals("SHA-512") ? new AlgorithmId(AlgorithmId.SHA512_oid) : (hashAlgName.equals("SHA-384") ? new AlgorithmId(AlgorithmId.SHA384_oid) : new AlgorithmId(AlgorithmId.SHA_oid)));
    }

    private String getSpecAlgName(String algName) {
        if ("SHA256".equals(algName)) {
            return "SHA-256";
        }
        if ("SHA384".equals(algName)) {
            return "SHA-384";
        }
        if ("SHA512".equals(algName)) {
            return "SHA-512";
        }
        return "SHA-1";
    }
}

