/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

public enum SSLVersion {
    SSL_2_0(new String[]{"SSL2", "SSLv2"}, 28, 2),
    SSL_3_0(new String[]{"SSL3", "SSLv3"}, 29, 768),
    TLS_1_0(new String[]{"TLS1_0", "TLSv1"}, 30, 769),
    TLS_1_1(new String[]{"TLS1_1", "TLSv1.1"}, 31, 770),
    TLS_1_2(new String[]{"TLS1_2", "TLSv1.2"}, 32, 771),
    TLS_1_3(new String[]{"TLS1_3", "TLSv1.3"}, 35, 772);

    private String[] aliases;
    private int value;
    private int nssValue;

    private SSLVersion(String alias, int value, int nssValue) {
        this.aliases = new String[]{alias};
        this.value = value;
        this.nssValue = nssValue;
    }

    private SSLVersion(String[] aliases, int value, int nssValue) {
        this.aliases = aliases;
        this.value = value;
        this.nssValue = nssValue;
    }

    public String alias() {
        return this.aliases[0];
    }

    public String jdkAlias() {
        return this.aliases[1];
    }

    public String[] aliases() {
        return this.aliases;
    }

    public int value() {
        return this.value;
    }

    public static SSLVersion valueOf(int value) {
        for (SSLVersion version : SSLVersion.values()) {
            if (version.value == value) {
                return version;
            }
            if (version.nssValue != value) continue;
            return version;
        }
        throw new IllegalArgumentException("Invalid SSLVersion value: " + value);
    }

    public boolean matchesAlias(String value) {
        for (String alias : this.aliases) {
            if (alias == null || !alias.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static SSLVersion findByAlias(String alias) {
        alias = alias.toUpperCase();
        for (SSLVersion version : SSLVersion.values()) {
            if (!version.matchesAlias(alias)) continue;
            return version;
        }
        return SSLVersion.valueOf(alias);
    }

    public static SSLVersion maxSupported() {
        SSLVersion result = null;
        for (SSLVersion v : SSLVersion.values()) {
            if (result != null && v.compareTo(result) <= 0) continue;
            result = v;
        }
        return result;
    }

    public static SSLVersion minSupported() {
        return TLS_1_0;
    }
}

