/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSSLoader {
    public static Logger logger = LoggerFactory.getLogger(JSSLoader.class);

    public static CryptoManager init(String config_path) throws Exception {
        if (config_path == null) {
            Object msg = "Please specify the path to the JSS configuration ";
            msg = (String)msg + "file in the java.security provider list.";
            throw new NullPointerException((String)msg);
        }
        try (FileInputStream fistream = new FileInputStream(config_path);){
            CryptoManager cryptoManager = JSSLoader.init(fistream);
            return cryptoManager;
        }
    }

    public static CryptoManager init(InputStream istream) throws Exception {
        if (CryptoManager.isInitialized()) {
            return CryptoManager.getInstance();
        }
        if (istream == null) {
            Object msg = "Please specify the JSS configuration InputStream ";
            msg = (String)msg + "in order to properly install this provider.";
            throw new NullPointerException((String)msg);
        }
        Properties config = new Properties();
        config.load(istream);
        InitializationValues ivs = JSSLoader.constructIV(config);
        JSSLoader.parseFipsMode(config, ivs);
        JSSLoader.parseReadOnly(config, ivs);
        JSSLoader.parseOCSPSettings(config, ivs);
        JSSLoader.parseProviderSettings(config, ivs);
        JSSLoader.parseNSSSettings(config, ivs);
        CryptoManager.initialize(ivs);
        CryptoManager cm = CryptoManager.getInstance();
        JSSLoader.parseOCSPPolicy(config, cm);
        JSSLoader.parsePasswords(config, cm);
        JSSLoader.parseExperimental(config);
        return cm;
    }

    private static InitializationValues constructIV(Properties config) {
        String configDir = config.getProperty("nss.config_dir", "/etc/pki/nssdb");
        String certPrefix = config.getProperty("nss.cert_prefix");
        String keyPrefix = config.getProperty("nss.key_prefix");
        String secmodName = config.getProperty("nss.secmod_name");
        if (certPrefix == null && keyPrefix == null && secmodName == null) {
            return new InitializationValues(configDir);
        }
        return new InitializationValues(configDir, certPrefix, keyPrefix, secmodName);
    }

    private static void parseFipsMode(Properties config, InitializationValues ivs) {
        String mode = config.getProperty("jss.fips", "unchanged");
        if (mode.equalsIgnoreCase("enabled")) {
            ivs.fipsMode = InitializationValues.FIPSMode.ENABLED;
        } else if (mode.equalsIgnoreCase("disabled")) {
            ivs.fipsMode = InitializationValues.FIPSMode.DISABLED;
        } else if (mode.equalsIgnoreCase("unchanged")) {
            ivs.fipsMode = InitializationValues.FIPSMode.UNCHANGED;
        } else {
            String msg = "Unknown value for jss.fips: " + mode + ". ";
            msg = msg + "Expecting one of ENABLED, DISABLED, or UNCHANGED.";
            throw new RuntimeException(msg);
        }
    }

    private static void parseReadOnly(Properties config, InitializationValues ivs) {
        Boolean value = JSSLoader.parseBoolean(config, "nss.read_only");
        if (value != null) {
            ivs.readOnly = value;
        }
    }

    private static void parseOCSPSettings(Properties config, InitializationValues ivs) {
        String nickname;
        String url;
        Boolean enabled = JSSLoader.parseBoolean(config, "jss.ocsp.enabled");
        if (enabled != null) {
            ivs.ocspCheckingEnabled = enabled;
        }
        ivs.ocspResponderURL = url = config.getProperty("jss.ocsp.responder.url");
        ivs.ocspResponderCertNickname = nickname = config.getProperty("jss.ocsp.responder.cert_nickname");
    }

    private static void parseProviderSettings(Properties config, InitializationValues ivs) {
        ivs.installJSSProvider = false;
        ivs.removeSunProvider = false;
        ivs.installJSSProviderFirst = false;
    }

    private static void parseNSSSettings(Properties config, InitializationValues ivs) {
        Boolean cooperate;
        Boolean noPK11Finalize;
        Boolean PK11Reload;
        Boolean PK11ThreadSafe;
        Boolean optimizeSpace;
        Boolean noRootInit;
        Boolean forceOpen;
        Boolean noModDB;
        Boolean noCertDB;
        Boolean PKIXVerify;
        Boolean initializeJavaOnly = JSSLoader.parseBoolean(config, "nss.java_only");
        if (initializeJavaOnly != null) {
            ivs.initializeJavaOnly = initializeJavaOnly;
        }
        if ((PKIXVerify = JSSLoader.parseBoolean(config, "nss.pkix_verify")) != null) {
            ivs.PKIXVerify = PKIXVerify;
        }
        if ((noCertDB = JSSLoader.parseBoolean(config, "nss.no_cert_db")) != null) {
            ivs.noCertDB = noCertDB;
        }
        if ((noModDB = JSSLoader.parseBoolean(config, "nss.no_mod_db")) != null) {
            ivs.noModDB = noModDB;
        }
        if ((forceOpen = JSSLoader.parseBoolean(config, "nss.force_open")) != null) {
            ivs.forceOpen = forceOpen;
        }
        if ((noRootInit = JSSLoader.parseBoolean(config, "nss.no_root_init")) != null) {
            ivs.noRootInit = noRootInit;
        }
        if ((optimizeSpace = JSSLoader.parseBoolean(config, "nss.optimize_space")) != null) {
            ivs.optimizeSpace = optimizeSpace;
        }
        if ((PK11ThreadSafe = JSSLoader.parseBoolean(config, "nss.pk11_thread_safe")) != null) {
            ivs.PK11ThreadSafe = PK11ThreadSafe;
        }
        if ((PK11Reload = JSSLoader.parseBoolean(config, "nss.pk11_reload")) != null) {
            ivs.PK11Reload = PK11Reload;
        }
        if ((noPK11Finalize = JSSLoader.parseBoolean(config, "nss.no_pk11_finalize")) != null) {
            ivs.noPK11Finalize = noPK11Finalize;
        }
        if ((cooperate = JSSLoader.parseBoolean(config, "nss.cooperate")) != null) {
            ivs.cooperate = cooperate;
        }
    }

    private static void parseOCSPPolicy(Properties config, CryptoManager cm) {
        String policy = config.getProperty("jss.ocsp.policy", "NONE");
        if (policy.equalsIgnoreCase("none")) {
            CryptoManager.setOCSPPolicy(CryptoManager.OCSPPolicy.NONE);
        } else if (policy.equalsIgnoreCase("normal")) {
            CryptoManager.setOCSPPolicy(CryptoManager.OCSPPolicy.NORMAL);
        } else if (policy.equalsIgnoreCase("leaf_and_chain")) {
            CryptoManager.setOCSPPolicy(CryptoManager.OCSPPolicy.LEAF_AND_CHAIN);
        } else {
            String msg = "Unknown value for jss.ocsp.policy: " + policy + ".";
            msg = msg + "Expecting one of NONE, NORMAL, or LEAF_AND_CHAIN.";
            throw new RuntimeException(msg);
        }
    }

    private static void parsePasswords(Properties config, CryptoManager cm) {
        String password = config.getProperty("jss.password");
        if (password != null && !password.isEmpty()) {
            Password pass_cb = new Password(password.toCharArray());
            cm.setPasswordCallback(pass_cb);
        }
    }

    private static void parseExperimental(Properties config) {
        Boolean sslengine = JSSLoader.parseBoolean(config, "jss.experimental.sslengine");
        if (sslengine != null) {
            JSSProvider.ENABLE_JSSENGINE = sslengine;
        }
    }

    private static Boolean parseBoolean(Properties config, String key_name) {
        String value = config.getProperty(key_name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        String msg = "Unknown value for boolean " + key_name + ": " + value;
        msg = msg + ". Expecting true, false, or not specified.";
        throw new RuntimeException(msg);
    }
}

