/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateAlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSerialNumber;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class CertInfo
extends X509CertInfo {
    private static final long serialVersionUID = -2883888348288591989L;
    public static final CertificateSubjectName SERIALIZE_SUBJECT;
    public static final CertificateIssuerName SERIALIZE_ISSUER;
    public static final CertificateValidity SERIALIZE_VALIDITY;
    public static final CertificateSerialNumber SERIALIZE_SERIALNO;
    public static final CertificateAlgorithmId SERIALIZE_ALGOR;
    public static final CertificateVersion FORCE_VERSION_3;

    public CertInfo() {
        CertInfo.makeSerializable(this);
    }

    public static void makeSerializable(X509CertInfo certinfo) {
        try {
            certinfo.set("version", FORCE_VERSION_3);
            if (certinfo.get("serialNumber") == null) {
                certinfo.set("serialNumber", SERIALIZE_SERIALNO);
            }
            if (certinfo.get("algorithmID") == null) {
                certinfo.set("algorithmID", SERIALIZE_ALGOR);
            }
            if (certinfo.get("issuer") == null) {
                certinfo.set("issuer", SERIALIZE_ISSUER);
            }
            if (certinfo.get("validity") == null) {
                certinfo.set("validity", SERIALIZE_VALIDITY);
            }
            if (certinfo.get("subject") == null) {
                certinfo.set("subject", SERIALIZE_SUBJECT);
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            FORCE_VERSION_3 = new CertificateVersion(2);
            SERIALIZE_SUBJECT = new CertificateSubjectName(new X500Name("cn=uninitialized"));
            SERIALIZE_ISSUER = new CertificateIssuerName(new X500Name("cn=uninitialized"));
            SERIALIZE_VALIDITY = new CertificateValidity(new Date(0L), new Date(0L));
            SERIALIZE_SERIALNO = new CertificateSerialNumber(new BigInteger("0"));
            SERIALIZE_ALGOR = new CertificateAlgorithmId(AlgorithmId.get("MD5withRSA"));
        }
        catch (IOException e) {
            System.out.println("**** Impossible Error encountered ****");
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("**** Impossible Error encountered ****");
            throw new RuntimeException(e.toString());
        }
    }
}

