/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedKeyUsageExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 765403075764697489L;
    private static final Logger logger = LoggerFactory.getLogger(ExtendedKeyUsageExtension.class);
    public static final String OID = "2.5.29.37";
    public static final String NAME = "ExtendedKeyUsageExtension";
    public static final String OID_OCSPSigning = "1.3.6.1.5.5.7.3.9";
    public static final String OID_CODESigning = "1.3.6.1.5.5.7.3.3";
    public static final int[] OID_OCSP_SIGNING_STR = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 9};
    public static final ObjectIdentifier OID_OCSP_SIGNING = new ObjectIdentifier(OID_OCSP_SIGNING_STR);
    public static final int[] OID_CODE_SIGNING_STR = new int[]{1, 3, 6, 1, 5, 5, 7, 3, 3};
    public static final ObjectIdentifier OID_CODE_SIGNING = new ObjectIdentifier(OID_OCSP_SIGNING_STR);
    private Vector<ObjectIdentifier> oidSet = null;
    private byte[] mCached = null;

    public ExtendedKeyUsageExtension() throws IOException {
        this(false, null);
    }

    public ExtendedKeyUsageExtension(boolean crit, Vector<ObjectIdentifier> oids) throws IOException {
        try {
            this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.critical = crit;
        this.oidSet = oids != null ? new Vector<ObjectIdentifier>(oids) : new Vector();
        this.encodeExtValue();
    }

    public ExtendedKeyUsageExtension(Boolean crit, Object byteVal) throws IOException {
        this.extensionId = ObjectIdentifier.getObjectIdentifier(OID);
        this.critical = crit;
        this.extensionValue = (byte[])((byte[])byteVal).clone();
        this.decodeThis();
    }

    @Override
    public void setCritical(boolean newValue) {
        if (this.critical != newValue) {
            this.critical = newValue;
            this.mCached = null;
        }
    }

    public Enumeration<ObjectIdentifier> getOIDs() {
        if (this.oidSet == null) {
            return null;
        }
        return this.oidSet.elements();
    }

    public void deleteAllOIDs() {
        if (this.oidSet == null) {
            return;
        }
        this.oidSet.clear();
    }

    public void addOID(ObjectIdentifier oid) {
        if (this.oidSet == null) {
            this.oidSet = new Vector();
        }
        if (this.oidSet.contains(oid)) {
            return;
        }
        this.oidSet.addElement(oid);
        this.mCached = null;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (this.mCached == null) {
            this.encodeExtValue();
            super.encode(out);
            this.mCached = out.toByteArray();
        }
    }

    @Override
    public String toString() {
        Object presentation = "oid=2.5.29.37 ";
        if (this.critical) {
            presentation = (String)presentation + "critical=true";
        }
        if (this.extensionValue != null) {
            StringBuffer extByteValue = new StringBuffer(" val=");
            for (int i = 0; i < this.extensionValue.length; ++i) {
                extByteValue.append(this.extensionValue[i] + " ");
            }
            presentation = (String)presentation + extByteValue.toString();
        }
        return presentation;
    }

    @Override
    public void decode(InputStream in) throws CertificateException, IOException {
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        if (this.mCached == null) {
            DerOutputStream temp = new DerOutputStream();
            this.encode(temp);
        }
        out.write(this.mCached);
    }

    @Override
    public void set(String name, Object obj) throws CertificateException, IOException {
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        return null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
    }

    private void decodeThis() throws IOException {
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of AuthInfoAccess extension");
        }
        if (this.oidSet == null) {
            this.oidSet = new Vector();
        }
        while (val.data.available() != 0) {
            DerValue oidVal = val.data.getDerValue();
            this.oidSet.addElement(oidVal.getOID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeExtValue() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        if (!this.oidSet.isEmpty()) {
            Enumeration<ObjectIdentifier> oidList = this.oidSet.elements();
            try {
                while (oidList.hasMoreElements()) {
                    temp.putOID(oidList.nextElement());
                }
            }
            catch (IOException ex) {
                logger.error("Problem encoding", (Throwable)ex);
            }
        }
        try {
            out.write((byte)48, temp);
        }
        catch (IOException iOException) {
        }
        finally {
            out.close();
        }
        this.extensionValue = out.toByteArray();
    }

    static {
        try {
            OIDMap.addAttribute(ExtendedKeyUsageExtension.class.getName(), OID, NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

