/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.provider;

import java.io.IOException;
import java.security.InvalidKeyException;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X509Key;

public final class RSAPublicKey
extends X509Key {
    private static final long serialVersionUID = 7764823589128565374L;
    private static final ObjectIdentifier ALGORITHM_OID = AlgorithmId.RSAEncryption_oid;
    private BigInt modulus;
    private BigInt publicExponent;

    public RSAPublicKey() {
    }

    public RSAPublicKey(BigInt modulus, BigInt publicExponent) throws InvalidKeyException {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
        this.algid = new AlgorithmId(ALGORITHM_OID);
        try (DerOutputStream out = new DerOutputStream();){
            out.putInteger(modulus);
            out.putInteger(publicExponent);
            this.key = new DerValue(48, out.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException ex) {
            throw new InvalidKeyException("could not DER encode : " + ex.getMessage());
        }
    }

    public RSAPublicKey(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
    }

    public int getKeySize() {
        return this.modulus.byteLength() * 8;
    }

    public BigInt getPublicExponent() {
        return this.publicExponent;
    }

    public BigInt getModulus() {
        return this.modulus;
    }

    @Override
    public String toString() {
        return "RSA Public Key\n  Algorithm: " + this.algid + "\n  modulus:\n" + this.modulus.toString() + "\n\n  publicExponent:\n" + this.publicExponent.toString() + "\n";
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        if (!this.algid.getOID().equals(ALGORITHM_OID) && !this.algid.getOID().equals(AlgorithmId.RSA_oid)) {
            throw new InvalidKeyException("Key algorithm OID is not RSA");
        }
        try {
            DerValue val = new DerValue(this.key);
            if (val.tag != 48) {
                throw new InvalidKeyException("Invalid RSA public key format: must be a SEQUENCE");
            }
            DerInputStream in = val.data;
            this.modulus = in.getInteger();
            this.publicExponent = in.getInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid RSA public key: " + e.getMessage());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.modulus == null ? 0 : this.modulus.hashCode());
        result = 31 * result + (this.publicExponent == null ? 0 : this.publicExponent.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSAPublicKey other = (RSAPublicKey)obj;
        if (this.modulus == null ? other.modulus != null : !this.modulus.equals(other.modulus)) {
            return false;
        }
        return !(this.publicExponent == null ? other.publicExponent != null : !this.publicExponent.equals(other.publicExponent));
    }

    public boolean bigIntEquals(BigInt x, BigInt y) {
        return !(x == null ? y != null : !x.equals(y));
    }
}

