/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.LdapV3DNStrConverter;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.X500Name;

public abstract class LdapDNStrConverter {
    private static LdapDNStrConverter defaultConverter = new LdapV3DNStrConverter();

    public abstract X500Name parseDN(String var1) throws IOException;

    public abstract X500Name parseDN(String var1, byte[] var2) throws IOException;

    public abstract RDN parseRDN(String var1) throws IOException;

    public abstract RDN parseRDN(String var1, byte[] var2) throws IOException;

    public abstract AVA parseAVA(String var1) throws IOException;

    public abstract AVA parseAVA(String var1, byte[] var2) throws IOException;

    public abstract String encodeDN(X500Name var1) throws IOException;

    public abstract String encodeRDN(RDN var1) throws IOException;

    public abstract String encodeAVA(AVA var1) throws IOException;

    public static LdapDNStrConverter getDefault() {
        return defaultConverter;
    }

    public static void setDefault(LdapDNStrConverter defConverter) {
        if (defConverter == null) {
            throw new IllegalArgumentException("The default Ldap DN String converter cannot be set to null.");
        }
        defaultConverter = defConverter;
    }
}

