/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.Attribute;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class SubjectDirAttributesExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -1215458115428197688L;
    public static final String IDENT = "Subject Directory Attributes";
    public static final String NAME = "SubjectDirectoryAttributes";
    private Vector<Attribute> attrList = new Vector();

    private void encodeThis() throws IOException {
        try (DerOutputStream out = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            Enumeration<Attribute> attrs = this.attrList.elements();
            while (attrs.hasMoreElements()) {
                Attribute attr = attrs.nextElement();
                attr.encode(tmp);
            }
            out.write((byte)48, tmp);
            this.extensionValue = out.toByteArray();
        }
    }

    private void decodeThis(DerValue derVal) throws IOException {
        if (derVal.tag != 48) {
            throw new IOException("Invalid encoding for Subject Directory Attribute extension.");
        }
        if (derVal.data.available() == 0) {
            throw new IOException("SubjectDirectoryAttributes No data available in passed DER encoded value.");
        }
        while (derVal.data.available() != 0) {
            DerValue encAttr = derVal.data.getDerValue();
            Attribute attr = new Attribute(encAttr);
            this.attrList.addElement(attr);
        }
    }

    public SubjectDirAttributesExtension(DerValue derVal) throws IOException {
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = false;
        this.decodeThis(derVal);
    }

    public SubjectDirAttributesExtension(Attribute[] list) throws IOException {
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = false;
        if (list == null || list.length == 0) {
            throw new IOException("No data available in passed Attribute List.");
        }
        for (int i = 0; i < list.length; ++i) {
            this.attrList.addElement(list[i]);
        }
    }

    public SubjectDirAttributesExtension(Boolean crit, Object value) throws IOException {
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = crit;
        if (!(value instanceof byte[])) {
            throw new IOException("SubjectDirectoryAttributesIllegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        this.decodeThis(new DerValue(extValue));
    }

    public SubjectDirAttributesExtension(Attribute[] list, boolean critical) throws IOException {
        this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
        this.critical = critical;
        if (list == null || list.length == 0) {
            throw new IOException("No data available in passed Attribute List.");
        }
        for (int i = 0; i < list.length; ++i) {
            this.attrList.addElement(list[i]);
        }
    }

    @Override
    public String toString() {
        String s = super.toString() + "SubjectDirectoryAttributes:[\n";
        Enumeration<Attribute> attrs = this.attrList.elements();
        StringBuffer tempBuffer = new StringBuffer();
        while (attrs.hasMoreElements()) {
            Attribute attr = attrs.nextElement();
            tempBuffer.append(attr.toString());
        }
        s = s + tempBuffer.toString();
        return s + "]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.decodeThis(val);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.SubjectDirectoryAttributes_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
    }

    @Override
    public Object get(String name) throws IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
    }

    @Override
    public void delete(String name) throws IOException {
        throw new IOException("Attribute name not recognized by CertAttrSet:SubjectDirectoryAttributes.");
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector elements = new Vector();
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Enumeration<Attribute> getAttributesList() {
        if (this.attrList == null) {
            return null;
        }
        return this.attrList.elements();
    }
}

