/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.DisplayText;
import org.mozilla.jss.netscape.security.x509.NoticeReference;
import org.mozilla.jss.netscape.security.x509.Qualifier;

public class UserNotice
extends Qualifier {
    private static final long serialVersionUID = 5770869942793748051L;
    private NoticeReference mNoticeReference = null;
    private DisplayText mDisplayText = null;

    public UserNotice(NoticeReference ref, DisplayText text) {
        this.mNoticeReference = ref;
        this.mDisplayText = text;
    }

    public UserNotice(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for UserNotice");
        }
        if (val.data.available() == 0) {
            return;
        }
        DerValue inSeq = val.data.getDerValue();
        if (inSeq.tag == 48) {
            this.mNoticeReference = new NoticeReference(inSeq);
        } else {
            this.mDisplayText = new DisplayText(inSeq);
        }
        if (val.data.available() == 0) {
            return;
        }
        this.mDisplayText = new DisplayText(val.data.getDerValue());
    }

    public NoticeReference getNoticeReference() {
        return this.mNoticeReference;
    }

    public DisplayText getDisplayText() {
        return this.mDisplayText;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.mNoticeReference != null) {
            this.mNoticeReference.encode(tmp);
        }
        if (this.mDisplayText != null) {
            this.mDisplayText.encode(tmp);
        }
        out.write((byte)48, tmp);
    }
}

