/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;

public class RevokeRequest
implements ASN1Value {
    public static final ENUMERATED unspecified = new ENUMERATED(0L);
    public static final ENUMERATED keyCompromise = new ENUMERATED(1L);
    public static final ENUMERATED cACompromise = new ENUMERATED(2L);
    public static final ENUMERATED affiliationChanged = new ENUMERATED(3L);
    public static final ENUMERATED superseded = new ENUMERATED(4L);
    public static final ENUMERATED cessationOfOperation = new ENUMERATED(5L);
    public static final ENUMERATED certificateHold = new ENUMERATED(6L);
    public static final ENUMERATED removeFromCRL = new ENUMERATED(8L);
    public static final ENUMERATED privilegeWithdrawn = new ENUMERATED(9L);
    public static final ENUMERATED aACompromise = new ENUMERATED(10L);
    private ANY issuerName;
    private INTEGER serialNumber;
    private ENUMERATED reason;
    private GeneralizedTime invalidityDate;
    private OCTET_STRING passphrase;
    private UTF8String comment;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public ANY getIssuerName() {
        return this.issuerName;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public ENUMERATED getReason() {
        return this.reason;
    }

    public GeneralizedTime getInvalidityDate() {
        return this.invalidityDate;
    }

    public OCTET_STRING getSharedSecret() {
        return this.passphrase;
    }

    public UTF8String getComment() {
        return this.comment;
    }

    @Deprecated
    public RevokeRequest(ANY issuerName, INTEGER serialNumber, ENUMERATED reason, OCTET_STRING passphrase, UTF8String comment) {
        this(issuerName, serialNumber, reason, null, passphrase, comment);
    }

    public RevokeRequest(ANY issuerName, INTEGER serialNumber, ENUMERATED reason, GeneralizedTime invalidityDate, OCTET_STRING passphrase, UTF8String comment) {
        if (issuerName == null || serialNumber == null || reason == null) {
            throw new IllegalArgumentException("parameter to RevokeRequest constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuerName = issuerName;
        this.sequence.addElement(issuerName);
        this.serialNumber = serialNumber;
        this.sequence.addElement(serialNumber);
        this.reason = reason;
        this.sequence.addElement(reason);
        this.invalidityDate = invalidityDate;
        this.sequence.addElement(invalidityDate);
        this.passphrase = passphrase;
        this.sequence.addElement(passphrase);
        this.comment = comment;
        this.sequence.addElement(comment);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(ENUMERATED.getTemplate());
            this.seqt.addOptionalElement(GeneralizedTime.getTemplate());
            this.seqt.addOptionalElement(OCTET_STRING.getTemplate());
            this.seqt.addOptionalElement(UTF8String.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new RevokeRequest((ANY)seq.elementAt(0), (INTEGER)seq.elementAt(1), (ENUMERATED)seq.elementAt(2), (GeneralizedTime)seq.elementAt(3), (OCTET_STRING)seq.elementAt(4), (UTF8String)seq.elementAt(5));
        }
    }
}

