/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.nss.BadCertHandler;
import org.mozilla.jss.nss.Buffer;
import org.mozilla.jss.nss.BufferProxy;
import org.mozilla.jss.nss.Cert;
import org.mozilla.jss.nss.CertAuthHandler;
import org.mozilla.jss.nss.PR;
import org.mozilla.jss.nss.PRErrors;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.nss.SSL;
import org.mozilla.jss.nss.SSLErrors;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.nss.SSLPreliminaryChannelInfo;
import org.mozilla.jss.nss.SecurityStatusResult;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.provider.javax.crypto.JSSNativeTrustManager;
import org.mozilla.jss.ssl.SSLAlertDescription;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLAlertLevel;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLVersion;
import org.mozilla.jss.ssl.SSLVersionRange;
import org.mozilla.jss.ssl.javax.JSSEngine;

public class JSSEngineReferenceImpl
extends JSSEngine {
    private String peer_info;
    private boolean closed_fd = true;
    private BufferProxy read_buf;
    private BufferProxy write_buf;
    private int unknown_state_count;
    private boolean step_handshake;
    private boolean returned_finished;
    private SSLException ssl_exception;
    private boolean seen_exception;
    private int debug_port;
    private ServerSocket ss_socket;
    private Socket s_socket;
    private Socket c_socket;
    private InputStream s_istream;
    private OutputStream s_ostream;
    private InputStream c_istream;
    private OutputStream c_ostream;
    private String name;
    private String prefix = "";
    private CertValidationTask task;

    public JSSEngineReferenceImpl() {
        this.peer_info = null;
        this.debug("JSSEngine: constructor()");
    }

    public JSSEngineReferenceImpl(String peerHost, int peerPort) {
        super(peerHost, peerPort);
        if (peerHost != null && peerPort != 0) {
            this.peer_info = peerHost + ":" + peerPort;
        }
        this.setHostname(peerHost);
        this.debug("JSSEngine: constructor(" + peerHost + ", " + peerPort + ")");
    }

    public JSSEngineReferenceImpl(String peerHost, int peerPort, X509Certificate localCert, PrivateKey localKey) {
        super(peerHost, peerPort, localCert, localKey);
        if (peerHost != null && peerPort != 0) {
            this.peer_info = peerHost + ":" + peerPort;
        }
        this.setHostname(peerHost);
        this.prefix = this.prefix + "[" + this.peer_info + "] ";
        this.debug("JSSEngine: constructor(" + peerHost + ", " + peerPort + ", " + localCert + ", " + localKey + ")");
    }

    private void debug(String msg) {
        logger.debug(this.prefix + msg);
    }

    private void info(String msg) {
        logger.info(this.prefix + msg);
    }

    private void warn(String msg) {
        logger.warn(this.prefix + msg);
    }

    public void setName(String name) {
        this.name = name;
        this.prefix = "[" + this.name + "] " + this.prefix;
    }

    private void init() throws SSLException {
        this.debug("JSSEngine: init()");
        if (this.ssl_fd != null && !this.closed_fd) {
            this.is_inbound_closed = true;
            this.is_outbound_closed = true;
            this.cleanup();
        }
        this.ssl_fd = null;
        this.createBuffers();
        this.createBufferFD();
        if (this.as_server) {
            this.initServer();
        } else {
            this.initClient();
        }
        this.applyProtocols();
        this.applyCiphers();
        this.applyConfig();
        this.applyHosts();
        this.applyTrustManagers();
        this.createLoggingSocket();
    }

    private void createBuffers() {
        this.debug("JSSEngine: createBuffers()");
        if (this.read_buf != null) {
            Buffer.Free(this.read_buf);
        }
        this.read_buf = Buffer.Create(BUFFER_SIZE);
        if (this.write_buf != null) {
            Buffer.Free(this.write_buf);
        }
        this.write_buf = Buffer.Create(BUFFER_SIZE);
    }

    private void createBufferFD() throws SSLException {
        this.debug("JSSEngine: createBufferFD()");
        PRFDProxy fd = this.peer_info != null && this.peer_info.length() != 0 ? PR.NewBufferPRFD(this.read_buf, this.write_buf, this.peer_info.getBytes()) : PR.NewBufferPRFD(this.read_buf, this.write_buf, null);
        if (fd == null) {
            throw new SSLException("Error creating buffer-backed PRFileDesc.");
        }
        SSLFDProxy model = null;
        if (this.as_server) {
            model = JSSEngineReferenceImpl.getServerTemplate(this.cert, this.key);
        }
        this.ssl_fd = SSL.ImportFD(model, fd);
        if (this.ssl_fd == null) {
            PR.Close(fd);
            throw new SSLException("Error creating SSL socket on top of buffer-backed PRFileDesc.");
        }
        fd = null;
        this.closed_fd = false;
        int ret = SSL.EnableAlertLogging(this.ssl_fd);
        if (ret == SSL.SECFailure) {
            throw new SSLException("Unable to enable SSL Alert Logging on this SSLFDProxy instance.");
        }
        ret = SSL.EnableHandshakeCallback(this.ssl_fd);
        if (ret == SSL.SECFailure) {
            throw new SSLException("Unable to enable SSL Handshake Callback on this SSLFDProxy instance.");
        }
    }

    private void initClient() throws SSLException {
        this.debug("JSSEngine: initClient()");
        if (this.cert != null && this.key != null) {
            this.debug("JSSEngine.initClient(): Enabling client auth: " + this.cert);
            this.ssl_fd.SetClientCert(this.cert);
            if (SSL.AttachClientCertCallback(this.ssl_fd) != SSL.SECSuccess) {
                throw new SSLException("Unable to attach client certificate auth callback.");
            }
        }
        if (this.hostname == null) {
            this.ssl_fd.badCertHandler = new BypassBadHostname(this.ssl_fd, 0);
            if (SSL.ConfigSyncBadCertCallback(this.ssl_fd) != SSL.SECSuccess) {
                throw new SSLException("Unable to attach bad cert callback.");
            }
        }
    }

    private void initServer() throws SSLException {
        this.debug("JSSEngine: initServer()");
        if (this.cert == null || this.key == null) {
            throw new IllegalArgumentException("JSSEngine: must be initialized with server certificate and key!");
        }
        this.debug("JSSEngine.initServer(): " + this.cert);
        this.debug("JSSEngine.initServer(): " + this.key);
        this.session.setLocalCertificates(new PK11Cert[]{this.cert});
        JSSEngineReferenceImpl.initializeSessionCache(1, 100L, null);
        this.configureClientAuth();
    }

    private void configureClientAuth() throws SSLException {
        this.debug("SSLFileDesc: " + this.ssl_fd);
        if (SSL.OptionSet(this.ssl_fd, SSL.REQUEST_CERTIFICATE, this.want_client_auth || this.need_client_auth ? 1 : 0) == SSL.SECFailure) {
            throw new SSLException("Unable to configure SSL_REQUEST_CERTIFICATE option: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
        }
        if (SSL.OptionSet(this.ssl_fd, SSL.REQUIRE_CERTIFICATE, this.need_client_auth ? SSL.REQUIRE_ALWAYS : 0) == SSL.SECFailure) {
            throw new SSLException("Unable to configure SSL_REQUIRE_CERTIFICATE option: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
        }
    }

    @Override
    protected void reconfigureClientAuth() {
        if (this.ssl_fd == null || !this.as_server) {
            return;
        }
        try {
            this.configureClientAuth();
        }
        catch (SSLException se) {
            throw new RuntimeException(se.getMessage(), se);
        }
    }

    private void applyCiphers() throws SSLException {
        this.debug("JSSEngine: applyCiphers()");
        if (this.enabled_ciphers == null) {
            return;
        }
        for (SSLCipher suite : SSLCipher.values()) {
            if (SSL.CipherPrefSet(this.ssl_fd, suite.getID(), false) != SSL.SECFailure) continue;
        }
        for (SSLCipher suite : this.enabled_ciphers) {
            if (suite == null) continue;
            if (SSL.CipherPrefSet(this.ssl_fd, suite.getID(), true) == SSL.SECFailure) {
                this.warn("Unable to enable cipher suite " + suite + ": " + JSSEngineReferenceImpl.errorText(PR.GetError()));
                continue;
            }
            this.debug("Enabled cipher suite " + suite + ": " + JSSEngineReferenceImpl.errorText(PR.GetError()));
        }
    }

    private void applyProtocols() throws SSLException {
        this.debug("JSSEngine: applyProtocols() min_protocol=" + this.min_protocol + " max_protocol=" + this.max_protocol);
        if (this.min_protocol == null || this.max_protocol == null) {
            this.debug("JSSEngine: applyProtocols() - missing min_protocol or max_protocol; using defaults");
            return;
        }
        SSLVersionRange vrange = new SSLVersionRange(this.min_protocol, this.max_protocol);
        if (SSL.VersionRangeSet(this.ssl_fd, vrange) == SSL.SECFailure) {
            throw new SSLException("Unable to set version range: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
        }
    }

    private void applyConfig() throws SSLException {
        this.debug("JSSEngine: applyConfig()");
        for (Integer key : this.config.keySet()) {
            Integer value = (Integer)this.config.get(key);
            this.debug("Setting configuration option: " + key + "=" + value);
            if (SSL.OptionSet(this.ssl_fd, key, value) == SSL.SECSuccess) continue;
            throw new SSLException("Unable to set configuration value: " + key + "=" + value);
        }
    }

    private void applyHosts() throws SSLException {
        this.debug("JSSEngine: applyHosts()");
        if (this.hostname != null && SSL.SetURL(this.ssl_fd, this.hostname) == SSL.SECFailure) {
            throw new SSLException("Unable to configure server hostname: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
        }
    }

    private void applyTrustManagers() throws SSLException {
        this.debug("JSSEngine: applyTrustManagers()");
        if (this.trust_managers == null || this.trust_managers.length == 0) {
            this.debug("JSSEngine: no TrustManagers to apply.");
            return;
        }
        if (this.trust_managers.length == 1 && this.trust_managers[0] instanceof JSSNativeTrustManager) {
            this.debug("JSSEngine: applyTrustManagers() - adding Native TrustManager");
            if (SSL.ConfigJSSDefaultCertAuthCallback(this.ssl_fd) == SSL.SECFailure) {
                throw new SSLException("Unable to configure JSSNativeTrustManager on this JSSengine: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
            }
            return;
        }
        if (this.as_server) {
            this.ssl_fd.certAuthHandler = new CertValidationTask(this.ssl_fd);
            if (SSL.ConfigSyncTrustManagerCertAuthCallback(this.ssl_fd) == SSL.SECFailure) {
                throw new SSLException("Unable to configure TrustManager validation on this JSSengine: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
            }
        } else if (SSL.ConfigAsyncTrustManagerCertAuthCallback(this.ssl_fd) == SSL.SECFailure) {
            throw new SSLException("Unable to configure TrustManager validation on this JSSengine: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
        }
    }

    private void createLoggingSocket() throws SSLException {
        if (this.debug_port == 0) {
            return;
        }
        try {
            this.ss_socket = new ServerSocket(this.debug_port);
            this.ss_socket.setReuseAddress(true);
            this.ss_socket.setReceiveBufferSize(BUFFER_SIZE);
            this.c_socket = new Socket(this.ss_socket.getInetAddress(), this.ss_socket.getLocalPort());
            this.c_socket.setReuseAddress(true);
            this.c_socket.setReceiveBufferSize(BUFFER_SIZE);
            this.c_socket.setSendBufferSize(BUFFER_SIZE);
            this.s_socket = this.ss_socket.accept();
            this.s_socket.setReuseAddress(true);
            this.s_socket.setReceiveBufferSize(BUFFER_SIZE);
            this.s_socket.setSendBufferSize(BUFFER_SIZE);
            this.s_istream = this.s_socket.getInputStream();
            this.s_ostream = this.s_socket.getOutputStream();
            this.c_istream = this.c_socket.getInputStream();
            this.c_ostream = this.c_socket.getOutputStream();
        }
        catch (Exception e) {
            throw new SSLException("Unable to enable debug socket logging! " + e.getMessage(), e);
        }
    }

    private void loggingSocketConsumeAllBytes() {
        int available2;
        try {
            available2 = this.s_istream.available();
            this.s_istream.skipNBytes(available2);
        }
        catch (Exception available2) {
            // empty catch block
        }
        try {
            available2 = this.c_istream.available();
            this.c_istream.skipNBytes(available2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.debug("JSSEngine: beginHandshake()");
        boolean unwrap = this.as_server;
        if (this.ssl_fd == null) {
            this.init();
            assert (this.ssl_fd != null);
            if (SSL.ResetHandshake(this.ssl_fd, this.as_server) == SSL.SECFailure) {
                throw new RuntimeException("Unable to begin handshake: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
            }
        } else {
            boolean bl = unwrap = !this.as_server;
            if (this.session.getSSLVersion() == SSLVersion.TLS_1_3) {
                boolean send_certificate_request;
                boolean bl2 = send_certificate_request = this.as_server && this.need_client_auth;
                if (send_certificate_request) {
                    if (SSL.SendCertificateRequest(this.ssl_fd) == SSL.SECFailure) {
                        throw new RuntimeException("Unable to issue certificate request on TLSv1.3: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
                    }
                } else if (SSL.KeyUpdate(this.ssl_fd, false) == SSL.SECFailure) {
                    throw new RuntimeException("Unable to request a new key on TLSv1.3: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
                }
            } else if (SSL.ReHandshake(this.ssl_fd, true) == SSL.SECFailure) {
                throw new RuntimeException("Unable to rehandshake: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
            }
        }
        this.ssl_fd.handshakeComplete = false;
        this.handshake_state = unwrap ? SSLEngineResult.HandshakeStatus.NEED_UNWRAP : SSLEngineResult.HandshakeStatus.NEED_WRAP;
        this.step_handshake = true;
        this.unknown_state_count = 0;
        this.returned_finished = false;
    }

    @Override
    public void closeInbound() {
        this.debug("JSSEngine: closeInbound()");
        if (!this.is_inbound_closed && this.ssl_fd != null && !this.closed_fd) {
            PR.Shutdown(this.ssl_fd, PR.SHUTDOWN_RCV);
        }
        this.is_inbound_closed = true;
    }

    @Override
    public void closeOutbound() {
        this.debug("JSSEngine: closeOutbound()");
        if (!this.is_outbound_closed && this.ssl_fd != null && !this.closed_fd) {
            PR.Shutdown(this.ssl_fd, PR.SHUTDOWN_SEND);
        }
        this.is_outbound_closed = true;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Override
    public Runnable getDelegatedTask() {
        this.debug("JSSEngine: getDelegatedTask()");
        if (this.ssl_fd != null) {
            this.checkNeedCertValidation();
        }
        return this.task;
    }

    private boolean checkNeedCertValidation() {
        this.debug("JSSEngine: checkNeedCertValidation()");
        if (this.task != null) {
            if (!this.task.finished) {
                this.debug("JSSEngine: checkNeedCertValidation() - task not done");
                return true;
            }
            this.debug("JSSEngine: checkNeedCertValidation() - task done with code " + this.task.result);
            if (SSL.AuthCertificateComplete(this.ssl_fd, this.task.result) != SSL.SECSuccess) {
                Object msg = "Got unexpected failure finishing cert ";
                msg = (String)msg + "authentication in NSS. Returned code ";
                msg = (String)msg + this.task.result;
                throw new RuntimeException((String)msg);
            }
            this.debug("JSSEngine: checkNeedCertValidation() - task done, removing");
            this.task = null;
            this.handshake_state = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.ssl_fd.needCertValidation = false;
            return false;
        }
        if (this.ssl_fd == null) {
            this.debug("JSSEngine: checkNeedCertValidation() - no ssl_fd");
            return false;
        }
        if (!this.ssl_fd.needCertValidation) {
            this.debug("JSSEngine: checkNeedCertValidation() - no need for cert validation");
            return false;
        }
        this.debug("JSSEngine: checkNeedCertValidation() - creating task");
        this.task = new CertValidationTask(this.ssl_fd);
        this.handshake_state = SSLEngineResult.HandshakeStatus.NEED_TASK;
        return true;
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        this.debug("JSSEngine: getHandshakeStatus()");
        if (this.checkNeedCertValidation()) {
            return this.handshake_state;
        }
        this.updateHandshakeState();
        return this.handshake_state;
    }

    @Override
    public SecurityStatusResult getStatus() {
        if (this.ssl_fd == null) {
            return null;
        }
        return SSL.SecurityStatus(this.ssl_fd);
    }

    public void enableSafeDebugLogging(int port) {
        this.debug_port = port;
    }

    private int computeSize(ByteBuffer[] buffers, int offset, int length) throws IllegalArgumentException {
        this.debug("JSSEngine: computeSize()");
        int result = 0;
        if (buffers == null || buffers.length == 0) {
            this.debug("JSSEngine.compueSize(): no buffers - result=" + result);
            return result;
        }
        for (int rel_index = 0; rel_index < length; ++rel_index) {
            int index = offset + rel_index;
            if (index >= buffers.length) {
                throw new IllegalArgumentException("offset (" + offset + ") or length (" + length + ") exceeds contract based on number of buffers (" + buffers.length + ")");
            }
            if (rel_index == 0 && buffers[index] == null) {
                this.debug("JSSEngine.computeSize(): null first buffer - result=" + result);
                return result;
            }
            if (buffers[index] == null) {
                throw new IllegalArgumentException("Buffer at index " + index + " is null.");
            }
            result += buffers[index].remaining();
        }
        this.debug("JSSEngine.computeSize(): result=" + result);
        return result;
    }

    private int putData(byte[] data, ByteBuffer[] buffers, int offset, int length) {
        int put_size;
        this.debug("JSSEngine: putData()");
        int buffer_index = offset;
        int data_index = 0;
        if (data == null || buffers == null) {
            return data_index;
        }
        for (data_index = 0; data_index < data.length; data_index += put_size) {
            while ((buffers[buffer_index] == null || buffers[buffer_index].remaining() <= 0) && buffer_index < offset + length) {
                ++buffer_index;
            }
            if (buffer_index >= offset + length) break;
            put_size = buffers[buffer_index].remaining();
            if (put_size > data.length - data_index) {
                put_size = data.length - data_index;
            }
            buffers[buffer_index].put(data, data_index, put_size);
        }
        return data_index;
    }

    private SSLException checkSSLAlerts() {
        SSLException exception;
        SSLAlertEvent event;
        this.debug("JSSEngine: Checking inbound and outbound SSL Alerts. Have " + this.ssl_fd.inboundAlerts.size() + " inbound and " + this.ssl_fd.outboundAlerts.size() + " outbound alerts.");
        while (this.ssl_fd.inboundOffset < this.ssl_fd.inboundAlerts.size()) {
            event = this.ssl_fd.inboundAlerts.get(this.ssl_fd.inboundOffset);
            ++this.ssl_fd.inboundOffset;
            if (event.getLevelEnum() == SSLAlertLevel.WARNING && event.getDescriptionEnum() == SSLAlertDescription.CLOSE_NOTIFY) {
                this.debug("Got inbound CLOSE_NOTIFY alert");
                this.closeInbound();
            }
            this.debug("JSSEngine: Got inbound alert: " + event);
            event.setEngine(this);
            this.fireAlertReceived(event);
            exception = event.toException();
            if (exception == null) continue;
            return exception;
        }
        while (this.ssl_fd.outboundOffset < this.ssl_fd.outboundAlerts.size()) {
            event = this.ssl_fd.outboundAlerts.get(this.ssl_fd.outboundOffset);
            ++this.ssl_fd.outboundOffset;
            if (event.getLevelEnum() == SSLAlertLevel.WARNING && event.getDescriptionEnum() == SSLAlertDescription.CLOSE_NOTIFY) {
                this.debug("Sent outbound CLOSE_NOTIFY alert.");
                this.closeOutbound();
            }
            this.debug("JSSEngine: Got outbound alert: " + event);
            event.setEngine(this);
            this.fireAlertSent(event);
            exception = event.toException();
            if (exception == null) continue;
            return exception;
        }
        return null;
    }

    private void updateHandshakeState() {
        int error_value;
        this.debug("JSSEngine: updateHandshakeState()");
        if (this.seen_exception) {
            return;
        }
        if (!this.step_handshake && this.handshake_state == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.debug("JSSEngine.updateHandshakeState() - not handshaking");
            this.unknown_state_count = 0;
            this.ssl_exception = this.checkSSLAlerts();
            this.seen_exception = this.ssl_exception != null;
            return;
        }
        if (!this.step_handshake && this.handshake_state == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.debug("JSSEngine.updateHandshakeState() - FINISHED to NOT_HANDSHAKING");
            if (this.returned_finished) {
                this.handshake_state = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
            this.unknown_state_count = 0;
            this.ssl_exception = this.checkSSLAlerts();
            this.seen_exception = this.ssl_exception != null;
            return;
        }
        this.debug("JSSEngine.updateHandshakeState() - forcing handshake");
        if (SSL.ForceHandshake(this.ssl_fd) == SSL.SECFailure && (error_value = PR.GetError()) != PRErrors.WOULD_BLOCK_ERROR) {
            this.debug("JSSEngine.updateHandshakeState() - FATAL " + this.getStatus());
            this.ssl_exception = new SSLHandshakeException("Error duing SSL.ForceHandshake() :: " + JSSEngineReferenceImpl.errorText(error_value));
            this.seen_exception = true;
            this.handshake_state = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            return;
        }
        this.debug("JSSEngine.updateHandshakeState() - read_buf.read=" + Buffer.ReadCapacity(this.read_buf) + " read_buf.write=" + Buffer.WriteCapacity(this.read_buf) + " write_buf.read=" + Buffer.ReadCapacity(this.write_buf) + " write_buf.write=" + Buffer.WriteCapacity(this.write_buf));
        if (Buffer.ReadCapacity(this.write_buf) > 0L && this.handshake_state != SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.debug("JSSEngine.updateHandshakeState() - can write " + Buffer.ReadCapacity(this.write_buf) + " bytes, NEED_WRAP to process");
            this.handshake_state = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.unknown_state_count = 0;
            return;
        }
        if (this.ssl_fd.handshakeComplete && Buffer.ReadCapacity(this.write_buf) == 0L) {
            this.debug("JSSEngine.updateHandshakeState() - handshakeComplete is " + this.ssl_fd.handshakeComplete + ", so we've just finished handshaking");
            this.step_handshake = false;
            this.handshake_state = SSLEngineResult.HandshakeStatus.FINISHED;
            this.unknown_state_count = 0;
            try {
                Certificate[] peer_chain = SSL.PeerCertificateChain(this.ssl_fd);
                this.session.setPeerCertificates(peer_chain);
            }
            catch (Exception e) {
                Object msg = "Unable to get peer's certificate chain: ";
                msg = (String)msg + e.getMessage();
                this.seen_exception = true;
                this.ssl_exception = new SSLException((String)msg, e);
            }
            this.session.refreshData();
            this.fireHandshakeComplete(new SSLHandshakeCompletedEvent(this));
            return;
        }
        if (Buffer.ReadCapacity(this.read_buf) == 0L && this.handshake_state != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.debug("JSSEngine.updateHandshakeState() - can read " + Buffer.ReadCapacity(this.read_buf) + " bytes, NEED_UNWRAP to give us more");
            this.handshake_state = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            this.unknown_state_count = 0;
            return;
        }
        ++this.unknown_state_count;
        if (this.unknown_state_count >= 4) {
            this.handshake_state = this.handshake_state == SSLEngineResult.HandshakeStatus.NEED_WRAP ? SSLEngineResult.HandshakeStatus.NEED_UNWRAP : SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.unknown_state_count = 1;
        }
    }

    private void logUnwrap(ByteBuffer src) {
        if (this.debug_port <= 0 || src == null || src.remaining() == 0) {
            return;
        }
        this.loggingSocketConsumeAllBytes();
        OutputStream stream = this.c_ostream;
        if (!this.as_server) {
            stream = this.s_ostream;
        }
        WritableByteChannel channel = Channels.newChannel(stream);
        int pos = src.position();
        try {
            this.debug("JSSEngine: logUnwrap() - writing " + src.remaining() + " bytes.");
            channel.write(src);
            stream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to log contents of unwrap's src to debug socket: " + e.getMessage(), e);
        }
        finally {
            src.position(pos);
        }
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws IllegalArgumentException, SSLException {
        int this_dst_write;
        int this_src_write;
        this.debug("JSSEngine: unwrap(ssl_fd=" + this.ssl_fd + ")");
        if (this.ssl_fd == null) {
            this.beginHandshake();
        }
        if (this.checkNeedCertValidation()) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshake_state, 0, 0);
        }
        boolean handshake_already_complete = this.ssl_fd.handshakeComplete;
        int src_capacity = src.remaining();
        this.logUnwrap(src);
        int wire_data = 0;
        int app_data = 0;
        do {
            this_src_write = 0;
            this_dst_write = 0;
            if (src != null && (this_src_write = Math.min((int)Buffer.WriteCapacity(this.read_buf), src.remaining())) > 0) {
                byte[] wire_buffer = new byte[this_src_write];
                src.get(wire_buffer);
                this_src_write = (int)Buffer.Write(this.read_buf, wire_buffer);
                wire_data += this_src_write;
                this.debug("JSSEngine.unwrap(): Wrote " + this_src_write + " bytes to read_buf.");
            }
            this.updateHandshakeState();
            int max_dst_size = this.computeSize(dsts, offset, length);
            byte[] app_buffer = PR.Read(this.ssl_fd, max_dst_size);
            int error = PR.GetError();
            this.debug("JSSEngine.unwrap() - " + app_buffer + " error=" + JSSEngineReferenceImpl.errorText(error));
            if (app_buffer != null) {
                this_dst_write = this.putData(app_buffer, dsts, offset, length);
                app_data += this_dst_write;
                continue;
            }
            if (max_dst_size <= 0 || error == 0 || error == PRErrors.WOULD_BLOCK_ERROR || error == PRErrors.SOCKET_SHUTDOWN_ERROR) continue;
            this.ssl_exception = new SSLException("Unexpected return from PR.Read(): " + JSSEngineReferenceImpl.errorText(error));
            this.seen_exception = true;
        } while (this_src_write != 0 || this_dst_write != 0);
        SSLException checkException = this.checkSSLAlerts();
        if (checkException != null && !this.seen_exception) {
            this.ssl_exception = checkException;
            this.seen_exception = true;
        }
        if (this.ssl_exception != null) {
            this.info("JSSEngine.unwrap() - Got SSLException: " + this.ssl_exception);
            SSLException excpt = this.ssl_exception;
            this.ssl_exception = null;
            this.handshake_state = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.tryCleanup();
            throw excpt;
        }
        SSLEngineResult.Status handshake_status = SSLEngineResult.Status.OK;
        if (this.is_inbound_closed) {
            this.debug("Socket is currently closed.");
            handshake_status = SSLEngineResult.Status.CLOSED;
        } else if (handshake_already_complete && src_capacity > 0 && app_data == 0) {
            this.debug("Underflowed: produced no application data when we expected to.");
            handshake_status = SSLEngineResult.Status.BUFFER_UNDERFLOW;
        }
        this.debug("JSSEngine.unwrap() - Finished");
        this.debug(" - Status: " + handshake_status);
        this.debug(" - Handshake State: " + this.handshake_state);
        this.debug(" - wire_data: " + wire_data);
        this.debug(" - app_data: " + app_data);
        if (this.handshake_state == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.returned_finished = true;
        }
        this.tryCleanup();
        return new SSLEngineResult(handshake_status, this.handshake_state, wire_data, app_data);
    }

    public int writeData(ByteBuffer[] srcs, int offset, int length) {
        this.debug("JSSEngine: writeData()");
        int data_length = 0;
        int index = offset;
        int max_index = offset + length;
        boolean attempted_write = false;
        while (index < max_index) {
            if (srcs[index] == null || srcs[index].remaining() <= 0) {
                ++index;
                continue;
            }
            this.debug("JSSEngine.writeData(): index=" + index + " max_index=" + max_index);
            int expected_write = Math.min(srcs[index].remaining(), BUFFER_SIZE);
            this.debug("JSSEngine.writeData(): expected_write=" + expected_write + " write_cap=" + Buffer.WriteCapacity(this.write_buf) + " read_cap=" + Buffer.ReadCapacity(this.read_buf));
            byte[] app_data = new byte[expected_write];
            srcs[index].get(app_data);
            int this_write = PR.Write(this.ssl_fd, app_data);
            attempted_write = true;
            if (this_write < expected_write) {
                int pos = srcs[index].position();
                int delta = expected_write - Math.max(0, this_write);
                srcs[index].position(pos - delta);
            }
            this.debug("JSSEngine.writeData(): this_write=" + this_write);
            if (this_write < 0) {
                int error = PR.GetError();
                if (error == PRErrors.SOCKET_SHUTDOWN_ERROR) {
                    this.debug("NSPR reports outbound socket is shutdown.");
                    this.is_outbound_closed = true;
                    break;
                }
                if (error == PRErrors.WOULD_BLOCK_ERROR) break;
                throw new RuntimeException("Unable to write to internal ssl_fd: " + JSSEngineReferenceImpl.errorText(PR.GetError()));
            }
            data_length += this_write;
            if (this_write >= expected_write) continue;
            break;
        }
        if (!attempted_write) {
            PR.Write(this.ssl_fd, null);
        }
        this.debug("JSSEngine.writeData(): data_length=" + data_length);
        return data_length;
    }

    private void logWrap(ByteBuffer dst) {
        if (this.debug_port <= 0 || dst == null || dst.remaining() == 0) {
            return;
        }
        this.loggingSocketConsumeAllBytes();
        OutputStream stream = this.s_ostream;
        if (!this.as_server) {
            stream = this.c_ostream;
        }
        WritableByteChannel channel = Channels.newChannel(stream);
        int pos = dst.position();
        try {
            dst.flip();
            this.debug("JSSEngine: logWrap() - writing " + dst.remaining() + " bytes.");
            channel.write(dst);
            stream.flush();
            dst.flip();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to log contents of wrap's dst to debug socket: " + e.getMessage(), e);
        }
        finally {
            dst.position(pos);
        }
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws IllegalArgumentException, SSLException {
        int this_dst_write;
        int this_src_write;
        this.debug("JSSEngine: wrap(ssl_fd=" + this.ssl_fd + ")");
        if (this.ssl_fd == null) {
            this.beginHandshake();
        }
        if (this.checkNeedCertValidation()) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.handshake_state, 0, 0);
        }
        int app_data = 0;
        int wire_data = 0;
        if (this.is_inbound_closed && !this.is_outbound_closed) {
            this.closeOutbound();
        }
        do {
            this_src_write = 0;
            this_dst_write = 0;
            this.updateHandshakeState();
            if (this.ssl_exception == null && this.seen_exception && this.handshake_state != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.handshake_state = SSLEngineResult.HandshakeStatus.FINISHED;
            }
            if ((this_src_write = this.writeData(srcs, offset, length)) > 0) {
                app_data += this_src_write;
                this.debug("JSSEngine.wrap(): wrote " + this_src_write + " from srcs to buffer.");
            } else {
                this.debug("JSSEngine.wrap(): not writing from srcs to buffer: this_src_write=" + this_src_write);
            }
            if (dst != null) {
                this_dst_write = Math.min((int)Buffer.ReadCapacity(this.write_buf), dst.remaining());
                if (this_dst_write > 0) {
                    byte[] wire_buffer = Buffer.Read(this.write_buf, this_dst_write);
                    dst.put(wire_buffer);
                    this_dst_write = wire_buffer.length;
                    wire_data += this_dst_write;
                    this.debug("JSSEngine.wrap() - Wrote " + wire_buffer.length + " bytes to dst.");
                    continue;
                }
                this.debug("JSSEngine.wrap(): not writing from write_buf into dst: this_dst_write=0 write_buf.read_capacity=" + Buffer.ReadCapacity(this.write_buf) + " dst.remaining=" + dst.remaining());
                continue;
            }
            this.debug("JSSEngine.wrap(): not writing from write_buf into NULL dst");
        } while (this_src_write != 0 || this_dst_write != 0);
        if (!this.seen_exception && this.ssl_exception == null) {
            this.ssl_exception = this.checkSSLAlerts();
            this.seen_exception = this.ssl_exception != null;
        }
        this.logWrap(dst);
        if (this.ssl_exception != null) {
            this.info("JSSEngine.wrap() - Got SSLException: " + this.ssl_exception);
            SSLException excpt = this.ssl_exception;
            this.ssl_exception = null;
            this.cleanup();
            throw excpt;
        }
        SSLEngineResult.Status handshake_status = SSLEngineResult.Status.OK;
        if (this.ssl_exception == null && this.seen_exception) {
            this.debug("Seen and processed exception; closing inbound and outbound because this was the last wrap(...)");
            this.closeInbound();
            this.closeOutbound();
        }
        if (this.is_outbound_closed) {
            this.debug("Socket is currently closed.");
            handshake_status = SSLEngineResult.Status.CLOSED;
            if (this.as_server) {
                this.closeInbound();
            }
        }
        this.debug("JSSEngine.wrap() - Finished");
        this.debug(" - Status: " + handshake_status);
        this.debug(" - Handshake State: " + this.handshake_state);
        this.debug(" - wire_data: " + wire_data);
        this.debug(" - app_data: " + app_data);
        if (this.handshake_state == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.returned_finished = true;
        }
        this.tryCleanup();
        return new SSLEngineResult(handshake_status, this.handshake_state, app_data, wire_data);
    }

    @Override
    public void tryCleanup() {
        this.debug("JSSEngine: tryCleanup()");
        if (this.is_inbound_closed && this.is_outbound_closed) {
            this.cleanup();
        }
    }

    @Override
    public void cleanup() {
        this.debug("JSSEngine: cleanup()");
        if (!this.is_inbound_closed) {
            this.debug("JSSEngine: cleanup() - closing opened inbound socket");
            this.closeInbound();
        }
        if (!this.is_outbound_closed) {
            this.debug("JSSEngine: cleanup() - closing opened outbound socket");
            this.closeOutbound();
        }
        this.cleanupLoggingSocket();
        this.cleanupSSLFD();
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    private void cleanupLoggingSocket() {
        if (this.debug_port > 0) {
            try {
                this.s_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.c_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ss_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanupSSLFD() {
        if (!this.closed_fd && this.ssl_fd != null) {
            try {
                SSL.RemoveCallbacks(this.ssl_fd);
                this.ssl_fd.close();
                this.ssl_fd = null;
            }
            catch (Exception e) {
                logger.error("Got exception trying to cleanup SSLFD", (Throwable)e);
            }
            finally {
                this.closed_fd = true;
            }
        }
        if (this.read_buf != null) {
            Buffer.Free(this.read_buf);
            this.read_buf = null;
        }
        if (this.write_buf != null) {
            Buffer.Free(this.write_buf);
            this.write_buf = null;
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    private class BypassBadHostname
    extends BadCertHandler {
        public BypassBadHostname(SSLFDProxy fd, int error) {
            super(fd, error);
        }

        @Override
        public int check(SSLFDProxy fd, int error) {
            if (error == SSLErrors.BAD_CERT_DOMAIN) {
                return 0;
            }
            return error;
        }
    }

    private class CertValidationTask
    extends CertAuthHandler {
        public CertValidationTask(SSLFDProxy fd) {
            super(fd);
        }

        public String findAuthType(SSLFDProxy ssl_fd, PK11Cert[] chain) throws Exception {
            SSLPreliminaryChannelInfo info = SSL.GetPreliminaryChannelInfo(ssl_fd);
            if (info == null) {
                String msg = "Expected non-null result from GetPreliminaryChannelInfo!";
                throw new RuntimeException(msg);
            }
            if (!info.haveProtocolVersion()) {
                Object msg = "Expected SSLPreliminaryChannelInfo (";
                msg = (String)msg + info + ") to have protocol information.";
                throw new RuntimeException((String)msg);
            }
            if (!info.haveCipherSuite()) {
                Object msg = "Expected SSLPreliminaryChannelInfo (";
                msg = (String)msg + info + ") to have cipher suite information.";
                throw new RuntimeException((String)msg);
            }
            SSLVersion version = info.getProtocolVersion();
            SSLCipher suite = info.getCipherSuite();
            if (version.value() < SSLVersion.TLS_1_3.value()) {
                if (suite.requiresRSACert()) {
                    if (suite.name().contains("RSA_EXPORT")) {
                        return "RSA_EXPORT";
                    }
                    return "RSA";
                }
                if (suite.requiresECDSACert()) {
                    return "ECDSA";
                }
                if (suite.requiresDSSCert()) {
                    return "DSA";
                }
            } else if (chain != null && chain.length > 0 && chain[0] != null) {
                PK11Cert cert = chain[0];
                PublicKey key = cert.getPublicKey();
                return key.getAlgorithm();
            }
            return null;
        }

        @Override
        public int check(SSLFDProxy fd) {
            java.security.cert.X509Certificate[] chain = null;
            try {
                chain = SSL.PeerCertificateChain(fd);
                String authType = this.findAuthType(fd, (PK11Cert[])chain);
                JSSEngineReferenceImpl.this.debug("CertAuthType: " + authType);
                if ((chain == null || chain.length == 0) && JSSEngineReferenceImpl.this.as_server && !JSSEngineReferenceImpl.this.need_client_auth) {
                    JSSEngineReferenceImpl.this.debug("No client certificate chain and client cert not needed.");
                    return 0;
                }
                for (X509TrustManager tm : JSSEngineReferenceImpl.this.trust_managers) {
                    if (tm instanceof X509ExtendedTrustManager) {
                        X509ExtendedTrustManager etm = (X509ExtendedTrustManager)tm;
                        if (JSSEngineReferenceImpl.this.as_server) {
                            etm.checkClientTrusted(chain, authType, JSSEngineReferenceImpl.this);
                            continue;
                        }
                        etm.checkServerTrusted(chain, authType, JSSEngineReferenceImpl.this);
                        continue;
                    }
                    if (JSSEngineReferenceImpl.this.as_server) {
                        tm.checkClientTrusted(chain, authType);
                        continue;
                    }
                    tm.checkServerTrusted(chain, authType);
                }
            }
            catch (Exception excpt) {
                return this.assignException(excpt, (PK11Cert[])chain);
            }
            return 0;
        }

        private int assignException(Exception excpt, PK11Cert[] chain) {
            int nss_code = Cert.MatchExceptionToNSSError(excpt);
            if (JSSEngineReferenceImpl.this.seen_exception) {
                return nss_code;
            }
            Object msg = "Got exception while trying to validate ";
            msg = (String)msg + "peer's certificate chain:\n";
            if (chain == null) {
                msg = (String)msg + " - (null chain)\n";
            } else if (chain.length == 0) {
                msg = (String)msg + " - (0 length chain)\n";
            } else {
                for (PK11Cert cert : chain) {
                    msg = (String)msg + " - " + cert + "\n";
                }
            }
            msg = (String)msg + "with given TrustManagers:\n";
            if (JSSEngineReferenceImpl.this.trust_managers == null) {
                msg = (String)msg + " - (null TrustManagers)\n";
            } else if (JSSEngineReferenceImpl.this.trust_managers.length == 0) {
                msg = (String)msg + " - (0 length TrustManagers)\n";
            } else {
                for (X509TrustManager tm : JSSEngineReferenceImpl.this.trust_managers) {
                    msg = (String)msg + " - " + (X509TrustManager)tm + "\n";
                }
            }
            msg = (String)msg + "exception message: " + excpt.getMessage();
            JSSEngineReferenceImpl.this.seen_exception = true;
            JSSEngineReferenceImpl.this.ssl_exception = new SSLException((String)msg, excpt);
            return nss_code;
        }
    }
}

