/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.mozilla.jss.nss.SSL;
import org.mozilla.jss.nss.SSLChannelInfo;
import org.mozilla.jss.nss.SSLFDProxy;
import org.mozilla.jss.nss.SSLPreliminaryChannelInfo;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLVersion;
import org.mozilla.jss.ssl.javax.JSSEngine;

public class JSSSession
implements SSLSession,
AutoCloseable {
    private static final int MAX_TLS_RECORD_PAYLOAD = 16384;
    private JSSEngine parent;
    private int applicationBufferSize;
    private int packetBufferSize;
    private SSLCipher cipherSuite;
    private SSLVersion protocolVersion;
    private long creationTime;
    private long lastAccessTime;
    private long expirationTime;
    private byte[] sessionID;
    private HashMap<String, Object> appDataMap;
    private Certificate[] localCertificates;
    private Principal localPrincipal;
    private String peerHost;
    private int peerPort;
    private String localAddr;
    private String remoteAddr;
    private Principal peerPrincipal;
    private X509Certificate[] peerChain;
    private Certificate[] peerCertificates;
    private boolean closed;

    protected JSSSession(JSSEngine engine, int buffer_size) {
        this.parent = engine;
        this.applicationBufferSize = Math.min(buffer_size, 16384);
        this.packetBufferSize = buffer_size;
        this.appDataMap = new HashMap();
    }

    public JSSEngine getEngine() {
        return this.parent;
    }

    public SSLChannelInfo getChannelInfo() {
        SSLFDProxy ssl_fd = this.parent.getSSLFDProxy();
        if (ssl_fd != null && ssl_fd.handshakeComplete) {
            return SSL.GetChannelInfo(ssl_fd);
        }
        return null;
    }

    public SSLPreliminaryChannelInfo getPreliminaryChannelInfo() {
        if (this.parent.getSSLFDProxy() != null) {
            return SSL.GetPreliminaryChannelInfo(this.parent.getSSLFDProxy());
        }
        return null;
    }

    @Override
    public int getApplicationBufferSize() {
        return this.applicationBufferSize;
    }

    @Override
    public int getPacketBufferSize() {
        return this.packetBufferSize;
    }

    @Override
    public byte[] getId() {
        return this.sessionID;
    }

    protected void setId(byte[] id) {
        this.sessionID = id;
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return null;
    }

    @Override
    public long getCreationTime() {
        if (this.creationTime == 0L) {
            this.refreshData();
        }
        return this.creationTime;
    }

    protected void setCreationTime(long time) {
        this.creationTime = time;
    }

    @Override
    public long getLastAccessedTime() {
        this.refreshData();
        return this.lastAccessTime;
    }

    protected void setLastAccessedTime(long when) {
        this.lastAccessTime = when;
    }

    public long getExpirationTime() {
        this.refreshData();
        return this.expirationTime;
    }

    protected void refreshData() {
        SSLChannelInfo info = this.getChannelInfo();
        if (info != null) {
            this.setId(info.getSessionID());
            this.setCreationTime(info.getCreationTime() * 1000L);
            this.setLastAccessedTime(info.getLastAccessTime() * 1000L);
            this.setExpirationTime(info.getExpirationTime() * 1000L);
            this.setCipherSuite(info.getCipherSuite());
            this.setProtocol(info.getProtocolVersion());
        }
    }

    protected void setExpirationTime(long when) {
        this.expirationTime = when;
    }

    @Override
    public boolean isValid() {
        return !this.closed && System.currentTimeMillis() < this.getExpirationTime();
    }

    @Override
    public void invalidate() {
        if (this.parent.getSSLFDProxy() != null) {
            SSL.InvalidateSession(this.parent.getSSLFDProxy());
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.setPeerCertificates(null);
    }

    @Override
    public void putValue(String name, Object value) {
        if (this.appDataMap.containsKey(name)) {
            this.removeValue(name);
        }
        this.appDataMap.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)value;
            listener.valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public Object getValue(String name) {
        return this.appDataMap.get(name);
    }

    @Override
    public void removeValue(String name) {
        Object value = this.appDataMap.remove(name);
        if (value instanceof SSLSessionBindingListener) {
            SSLSessionBindingListener listener = (SSLSessionBindingListener)value;
            listener.valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }

    @Override
    public String[] getValueNames() {
        return this.appDataMap.keySet().toArray(new String[0]);
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    protected void setLocalCertificates(Certificate[] certs) {
        this.localCertificates = certs;
    }

    @Override
    public Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    protected void setPeerCertificates(Certificate[] new_certs) {
        if (this.peerCertificates != null) {
            for (Certificate cert : this.peerCertificates) {
                try {
                    ((PK11Cert)cert).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
        this.peerCertificates = new_certs;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerChain == null) {
            String msg = "Peer reported no certificate chain or handshake has not yet completed.";
            throw new SSLPeerUnverifiedException(msg);
        }
        return this.peerChain;
    }

    protected void setPeerCertificateChain(X509Certificate[] chain) {
        this.peerChain = chain;
    }

    @Override
    public Principal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    protected void setPeerPrincipal(Principal principal) {
        this.peerPrincipal = principal;
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.localPrincipal;
    }

    protected void setLocalPrincipal(Principal principal) {
        this.localPrincipal = principal;
    }

    @Override
    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            this.refreshData();
        }
        if (this.cipherSuite == null) {
            return null;
        }
        return this.cipherSuite.name();
    }

    public SSLCipher getSSLCipher() {
        return this.cipherSuite;
    }

    protected void setCipherSuite(SSLCipher suite) {
        this.cipherSuite = suite;
    }

    @Override
    public String getProtocol() {
        if (this.protocolVersion == null) {
            this.refreshData();
        }
        if (this.protocolVersion == null) {
            return null;
        }
        return this.protocolVersion.jdkAlias();
    }

    public SSLVersion getSSLVersion() {
        return this.protocolVersion;
    }

    protected void setProtocol(SSLVersion protocol) {
        this.protocolVersion = protocol;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    public void setPeerHost(String host) {
        this.peerHost = host;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    public void setPeerPort(int port) {
        this.peerPort = port;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }
}

