/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.mozilla.jss.CRLImportException;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CertificateUsage;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.NicknameConflictException;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.UserCertConflictException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplier;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.KeyType;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11SecureRandom;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.provider.java.security.JSSMessageDigestSpi;
import org.mozilla.jss.util.InvalidNicknameException;
import org.mozilla.jss.util.NativeProxy;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoManager
implements TokenSupplier {
    public static Logger logger = LoggerFactory.getLogger(CryptoManager.class);
    private Vector<PK11Module> moduleVector;
    private CryptoToken internalCryptoToken;
    private CryptoToken internalKeyStorageToken;
    private static CryptoManager instance;
    private PasswordCallback passwordCallback;
    private static int TYPE_KRL;
    private static int TYPE_CRL;
    public static final boolean JSS_DEBUG;
    private ThreadLocal<CryptoToken> threadToken = new ThreadLocal();
    private static OCSPPolicy ocspPolicy;

    private static void loadLibrary() {
        try {
            System.loadLibrary("jss");
            logger.debug("CryptoManager: Loaded JSS library from java.library.path");
            return;
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug("CryptoManager: Unable to load JSS library from java.library.path: " + e.getMessage());
            String path = "/usr/lib64/jss/libjss.so";
            try {
                System.load(path);
                logger.debug("CryptoManager: Loaded JSS library from " + path);
                return;
            }
            catch (UnsatisfiedLinkError e2) {
                logger.debug("CryptoManager: Unable to load JSS library from " + path + ": " + e2.getMessage());
                path = "/usr/lib/jss/libjss.so";
                try {
                    System.load(path);
                    logger.debug("CryptoManager: Loaded JSS library from " + path);
                    return;
                }
                catch (UnsatisfiedLinkError e3) {
                    logger.debug("CryptoManager: Unable to load JSS library from " + path + ": " + e3.getMessage());
                    logger.error("Unable to load JSS library");
                    System.exit(-1);
                    return;
                }
            }
        }
    }

    @Override
    public synchronized CryptoToken getInternalCryptoToken() {
        return this.internalCryptoToken;
    }

    public synchronized CryptoToken getInternalKeyStorageToken() {
        return this.internalKeyStorageToken;
    }

    public synchronized CryptoToken getTokenByName(String name) throws NoSuchTokenException {
        Enumeration<CryptoToken> tokens = this.getAllTokens();
        while (tokens.hasMoreElements()) {
            CryptoToken token = tokens.nextElement();
            try {
                if (!name.equals(token.getName())) continue;
                return token;
            }
            catch (TokenException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoSuchTokenException("No such token: " + name);
    }

    public synchronized Enumeration<CryptoToken> getTokensSupportingAlgorithm(Algorithm alg) {
        Enumeration<CryptoToken> tokens = this.getAllTokens();
        Vector<CryptoToken> goodTokens = new Vector<CryptoToken>();
        while (tokens.hasMoreElements()) {
            CryptoToken tok = tokens.nextElement();
            if (!tok.doesAlgorithm(alg)) continue;
            goodTokens.addElement(tok);
        }
        return goodTokens.elements();
    }

    public synchronized Enumeration<CryptoToken> getAllTokens() {
        Enumeration<PK11Module> modules = this.getModules();
        Vector<CryptoToken> allTokens = new Vector<CryptoToken>();
        while (modules.hasMoreElements()) {
            Enumeration<CryptoToken> tokens = modules.nextElement().getTokens();
            while (tokens.hasMoreElements()) {
                allTokens.addElement(tokens.nextElement());
            }
        }
        return allTokens.elements();
    }

    public synchronized Enumeration<CryptoToken> getExternalTokens() {
        Enumeration<PK11Module> modules = this.getModules();
        Vector<PK11Token> allTokens = new Vector<PK11Token>();
        while (modules.hasMoreElements()) {
            Enumeration<CryptoToken> tokens = modules.nextElement().getTokens();
            while (tokens.hasMoreElements()) {
                PK11Token token = (PK11Token)tokens.nextElement();
                if (token.isInternalCryptoToken() || token.isInternalKeyStorageToken()) continue;
                allTokens.addElement(token);
            }
        }
        return allTokens.elements();
    }

    public synchronized Enumeration<PK11Module> getModules() {
        return this.moduleVector.elements();
    }

    private synchronized void reloadModules() {
        this.moduleVector = new Vector();
        this.putModulesInVector(this.moduleVector);
        Enumeration<CryptoToken> tokens = this.getAllTokens();
        this.internalCryptoToken = null;
        this.internalKeyStorageToken = null;
        while (tokens.hasMoreElements()) {
            PK11Token token = (PK11Token)tokens.nextElement();
            if (token.isInternalCryptoToken()) {
                assert (this.internalCryptoToken == null);
                this.internalCryptoToken = token;
            }
            if (!token.isInternalKeyStorageToken()) continue;
            assert (this.internalKeyStorageToken == null);
            this.internalKeyStorageToken = token;
        }
        assert (this.internalKeyStorageToken != null);
        assert (this.internalCryptoToken != null);
    }

    private native void putModulesInVector(Vector<PK11Module> var1);

    protected CryptoManager() {
        TokenSupplierManager.setTokenSupplier(this);
        this.reloadModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Class<CryptoManager> clazz = CryptoManager.class;
        synchronized (CryptoManager.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoManager getInstance() throws NotInitializedException {
        Class<CryptoManager> clazz = CryptoManager.class;
        synchronized (CryptoManager.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Provider p = Security.getProvider("Mozilla-JSS");
            Class<CryptoManager> clazz2 = CryptoManager.class;
            synchronized (CryptoManager.class) {
                if (instance != null) {
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return instance;
                }
                if (p instanceof JSSProvider) {
                    JSSProvider jssProvider = (JSSProvider)p;
                    assert (jssProvider.getCryptoManager() != null);
                    instance = jssProvider.getCryptoManager();
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return instance;
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                throw new NotInitializedException();
            }
        }
    }

    private static native boolean enableFIPS(boolean var0) throws GeneralSecurityException;

    public synchronized native boolean FIPSEnabled();

    public synchronized void setPasswordCallback(PasswordCallback pwcb) {
        this.passwordCallback = pwcb;
        this.setNativePasswordCallback(pwcb);
    }

    private native void setNativePasswordCallback(PasswordCallback var1);

    public synchronized PasswordCallback getPasswordCallback() {
        return this.passwordCallback;
    }

    public static synchronized void initialize(String configDir) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException, GeneralSecurityException {
        CryptoManager.initialize(new InitializationValues(configDir));
    }

    public static synchronized void initializeWithContext(String configDir) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException, GeneralSecurityException {
        InitializationValues values = new InitializationValues(configDir);
        values.initializeContext = true;
        CryptoManager.initialize(values);
    }

    public static synchronized void initializeWithContext(InitializationValues values) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException, GeneralSecurityException {
        values.initializeContext = true;
        CryptoManager.initialize(values);
    }

    public static synchronized void initialize(InitializationValues values) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException, GeneralSecurityException {
        if (instance != null) {
            throw new AlreadyInitializedException();
        }
        if (values.ocspResponderURL != null && values.ocspResponderCertNickname == null) {
            throw new GeneralSecurityException("Must set ocspResponderCertNickname");
        }
        if (values.initializeContext) {
            CryptoManager.initializeAllNativeWithContext(values.configDir, values.certPrefix, values.keyPrefix, values.secmodName, values.readOnly, values.getManufacturerID(), values.getLibraryDescription(), values.getInternalTokenDescription(), values.getInternalKeyStorageTokenDescription(), values.getInternalSlotDescription(), values.getInternalKeyStorageSlotDescription(), values.getFIPSSlotDescription(), values.getFIPSKeyStorageSlotDescription(), values.ocspCheckingEnabled, values.ocspResponderURL, values.ocspResponderCertNickname, values.initializeJavaOnly, values.PKIXVerify, values.noCertDB, values.noModDB, values.forceOpen, values.noRootInit, values.optimizeSpace, values.PK11ThreadSafe, values.PK11Reload, values.noPK11Finalize, values.cooperate);
        } else {
            CryptoManager.initializeAllNative2(values.configDir, values.certPrefix, values.keyPrefix, values.secmodName, values.readOnly, values.getManufacturerID(), values.getLibraryDescription(), values.getInternalTokenDescription(), values.getInternalKeyStorageTokenDescription(), values.getInternalSlotDescription(), values.getInternalKeyStorageSlotDescription(), values.getFIPSSlotDescription(), values.getFIPSKeyStorageSlotDescription(), values.ocspCheckingEnabled, values.ocspResponderURL, values.ocspResponderCertNickname, values.initializeJavaOnly, values.PKIXVerify, values.noCertDB, values.noModDB, values.forceOpen, values.noRootInit, values.optimizeSpace, values.PK11ThreadSafe, values.PK11Reload, values.noPK11Finalize, values.cooperate);
        }
        instance = new CryptoManager();
        instance.setPasswordCallback(values.passwordCallback);
        if (values.fipsMode != InitializationValues.FIPSMode.UNCHANGED && CryptoManager.enableFIPS(values.fipsMode == InitializationValues.FIPSMode.ENABLED)) {
            instance.reloadModules();
        }
        JSSMessageDigestSpi.SHA1 mds = new JSSMessageDigestSpi.SHA1();
        logger.debug("Loaded " + mds);
        KeyType kt = KeyType.getKeyTypeFromAlgorithm(SignatureAlgorithm.RSASignatureWithSHA1Digest);
        logger.debug("Loaded " + kt);
        if (values.installJSSProvider) {
            int position;
            int insert_position = 1;
            if (!values.installJSSProviderFirst) {
                insert_position = Security.getProviders().length + 1;
            }
            if ((position = Security.insertProviderAt(new JSSProvider(true), insert_position)) < 0) {
                logger.warn("JSS provider is already installed");
            }
        }
        if (values.removeSunProvider) {
            Security.removeProvider("SUN");
        }
        logger.info("JSS CryptoManager: successfully initialized from NSS database at " + values.configDir);
    }

    private static native void initializeAllNative2(String var0, String var1, String var2, String var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13, String var14, String var15, boolean var16, boolean var17, boolean var18, boolean var19, boolean var20, boolean var21, boolean var22, boolean var23, boolean var24, boolean var25, boolean var26) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException;

    private static native void initializeAllNativeWithContext(String var0, String var1, String var2, String var3, boolean var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, boolean var13, String var14, String var15, boolean var16, boolean var17, boolean var18, boolean var19, boolean var20, boolean var21, boolean var22, boolean var23, boolean var24, boolean var25, boolean var26) throws KeyDatabaseException, CertDatabaseException, AlreadyInitializedException;

    public native X509Certificate[] getCACerts();

    public native X509Certificate[] getPermCerts();

    public X509Certificate importCertPackage(byte[] certPackage, String nickname) throws CertificateEncodingException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException {
        return this.importCertPackageNative(certPackage, nickname, false, false);
    }

    public X509Certificate importUserCACertPackage(byte[] certPackage, String nickname) throws CertificateEncodingException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException {
        return this.importCertPackageNative(certPackage, nickname, false, true);
    }

    public X509Certificate importCACertPackage(byte[] certPackage) throws CertificateEncodingException, TokenException {
        try {
            return this.importCertPackageNative(certPackage, null, true, false);
        }
        catch (NicknameConflictException e) {
            logger.error("importing CA certs caused nickname conflict", (Throwable)e);
            throw new RuntimeException("Importing CA certs caused nickname conflict: " + e.getMessage(), e);
        }
        catch (UserCertConflictException e) {
            logger.error("importing CA certs caused user cert conflict", (Throwable)e);
            throw new RuntimeException("Importing CA certs caused user cert conflict: " + e.getMessage(), e);
        }
        catch (NoSuchItemOnTokenException e) {
            logger.error("importing CA certs caused NoSuchItemOnTokenException", (Throwable)e);
            throw new RuntimeException("Importing CA certs caused NoSuchItemOnTokenException: " + e.getMessage(), e);
        }
    }

    public InternalCertificate importCertToPerm(X509Certificate cert, String nickname) throws TokenException, InvalidNicknameException {
        if (nickname == null) {
            throw new InvalidNicknameException("Nickname must be non-null");
        }
        return this.importCertToPermNative(cert, nickname);
    }

    public X509Certificate importDERCert(byte[] cert, CertificateUsage usage, boolean permanent, String nickname) {
        return this.importDERCertNative(cert, usage.getEnumValue(), permanent, nickname);
    }

    private native X509Certificate importDERCertNative(byte[] var1, int var2, boolean var3, String var4);

    private native InternalCertificate importCertToPermNative(X509Certificate var1, String var2) throws TokenException;

    private native X509Certificate importCertPackageNative(byte[] var1, String var2, boolean var3, boolean var4) throws CertificateEncodingException, NicknameConflictException, UserCertConflictException, NoSuchItemOnTokenException, TokenException;

    public void importCRL(byte[] crl, String url) throws CRLImportException, TokenException {
        this.importCRLNative(crl, url, TYPE_CRL);
    }

    private native void importCRLNative(byte[] var1, String var2, int var3) throws CRLImportException, TokenException;

    public native byte[] exportCertsToPKCS7(X509Certificate[] var1) throws CertificateEncodingException;

    public X509Certificate findCertByNickname(String nickname) throws ObjectNotFoundException, TokenException {
        assert (nickname != null);
        return this.findCertByNicknameNative(nickname);
    }

    public X509Certificate[] findCertsByNickname(String nickname) throws TokenException {
        assert (nickname != null);
        return this.findCertsByNicknameNative(nickname);
    }

    public X509Certificate findCertByIssuerAndSerialNumber(byte[] derIssuer, INTEGER serialNumber) throws ObjectNotFoundException, TokenException {
        try {
            ANY sn = (ANY)ASN1Util.decode(ANY.getTemplate(), ASN1Util.encode(serialNumber));
            return this.findCertByIssuerAndSerialNumberNative(derIssuer, sn.getContents());
        }
        catch (InvalidBERException e) {
            throw new RuntimeException("Invalid BER encoding of INTEGER: " + e.getMessage(), e);
        }
    }

    private native X509Certificate findCertByIssuerAndSerialNumberNative(byte[] var1, byte[] var2) throws ObjectNotFoundException, TokenException;

    protected native X509Certificate findCertByNicknameNative(String var1) throws ObjectNotFoundException, TokenException;

    protected native X509Certificate[] findCertsByNicknameNative(String var1) throws TokenException;

    public X509Certificate[] buildCertificateChain(X509Certificate leaf) throws CertificateException, TokenException {
        if (!(leaf instanceof PK11Cert)) {
            throw new CertificateException("Certificate is not a PKCS #11 certificate");
        }
        return this.buildCertificateChainNative((PK11Cert)leaf);
    }

    native X509Certificate[] buildCertificateChainNative(PK11Cert var1) throws CertificateException, TokenException;

    public PrivateKey findPrivKeyByCert(X509Certificate cert) throws ObjectNotFoundException, TokenException {
        assert (cert != null);
        if (!(cert instanceof PK11Cert)) {
            throw new ObjectNotFoundException("Non-pkcs11 cert passed to PK11Finder");
        }
        return this.findPrivKeyByCertNative(cert);
    }

    protected native PrivateKey findPrivKeyByCertNative(X509Certificate var1) throws ObjectNotFoundException, TokenException;

    public JSSSecureRandom createPseudoRandomNumberGenerator() {
        return new PK11SecureRandom();
    }

    @Override
    public JSSSecureRandom getSecureRNG() {
        return new PK11SecureRandom();
    }

    public static native int getJSSMajorVersion();

    public static native int getJSSMinorVersion();

    public static native int getJSSPatchVersion();

    public static final String getJSSVersion() {
        return String.format("%d.%d.%d", CryptoManager.getJSSMajorVersion(), CryptoManager.getJSSMinorVersion(), CryptoManager.getJSSPatchVersion());
    }

    public static native boolean getJSSDebug();

    @Override
    public void setThreadToken(CryptoToken token) {
        if (token != null) {
            this.threadToken.set(token);
        } else {
            this.threadToken.remove();
        }
    }

    @Override
    public CryptoToken getThreadToken() {
        CryptoToken tok = this.threadToken.get();
        if (tok == null) {
            tok = this.getInternalKeyStorageToken();
        }
        return tok;
    }

    public int isCertValid(String nickname, boolean checkSig) throws ObjectNotFoundException, InvalidNicknameException {
        if (nickname == null) {
            throw new InvalidNicknameException("Nickname must be non-null");
        }
        int currCertificateUsage = 0;
        currCertificateUsage = this.verifyCertificateNowCUNative(nickname, checkSig);
        return currCertificateUsage;
    }

    private native int verifyCertificateNowCUNative(String var1, boolean var2) throws ObjectNotFoundException;

    @Deprecated
    public boolean isCertValid(String nickname, boolean checkSig, CertificateUsage certificateUsage) throws ObjectNotFoundException, InvalidNicknameException {
        if (nickname == null) {
            throw new InvalidNicknameException("Nickname must be non-null");
        }
        if (certificateUsage == null || certificateUsage == CertificateUsage.CheckAllUsages) {
            int currCertificateUsage = this.verifyCertificateNowCUNative(nickname, checkSig);
            return currCertificateUsage != 2944;
        }
        return this.verifyCertificateNowNative(nickname, checkSig, certificateUsage.getUsage());
    }

    public void verifyCertificate(String nickname, boolean checkSig, CertificateUsage certificateUsage) throws ObjectNotFoundException, InvalidNicknameException, CertificateException {
        int usage = certificateUsage == null ? 0 : certificateUsage.getUsage();
        this.verifyCertificateNowNative2(nickname, checkSig, usage);
    }

    public void verifyCertificate(X509Certificate cert, boolean checkSig, CertificateUsage certificateUsage) throws ObjectNotFoundException, InvalidNicknameException, CertificateException {
        int usage = certificateUsage == null ? 0 : certificateUsage.getUsage();
        this.verifyCertificateNowNative3(cert, checkSig, usage);
    }

    private native boolean verifyCertificateNowNative(String var1, boolean var2, int var3) throws ObjectNotFoundException;

    private native void verifyCertificateNowNative2(String var1, boolean var2, int var3) throws ObjectNotFoundException, InvalidNicknameException, CertificateException;

    private native void verifyCertificateNowNative3(X509Certificate var1, boolean var2, int var3) throws ObjectNotFoundException, InvalidNicknameException, CertificateException;

    public boolean isCertValid(String nickname, boolean checkSig, CertUsage certUsage) throws ObjectNotFoundException, InvalidNicknameException {
        if (nickname == null) {
            throw new InvalidNicknameException("Nickname must be non-null");
        }
        return this.verifyCertNowNative(nickname, checkSig, certUsage.getUsage());
    }

    private native boolean verifyCertNowNative(String var1, boolean var2, int var3) throws ObjectNotFoundException;

    public boolean isCertValid(byte[] certPackage, boolean checkSig, CertUsage certUsage) throws TokenException, CertificateEncodingException {
        return this.verifyCertTempNative(certPackage, checkSig, certUsage.getUsage());
    }

    private native boolean verifyCertTempNative(byte[] var1, boolean var2, int var3) throws TokenException, CertificateEncodingException;

    public static synchronized int getOCSPPolicy() {
        return ocspPolicy.ordinal();
    }

    public static synchronized OCSPPolicy getOCSPPolicyEnum() {
        return ocspPolicy;
    }

    public static synchronized void setOCSPPolicy(OCSPPolicy policy) {
        ocspPolicy = policy;
    }

    public void configureOCSP(boolean ocspCheckingEnabled, String ocspResponderURL, String ocspResponderCertNickname) throws GeneralSecurityException {
        if (ocspCheckingEnabled && ocspResponderURL == null && ocspResponderCertNickname == null) {
            CryptoManager.setOCSPPolicy(OCSPPolicy.LEAF_AND_CHAIN);
        } else {
            CryptoManager.setOCSPPolicy(OCSPPolicy.NORMAL);
        }
        this.configureOCSPNative(ocspCheckingEnabled, ocspResponderURL, ocspResponderCertNickname);
    }

    private native void configureOCSPNative(boolean var1, String var2, String var3) throws GeneralSecurityException;

    public void OCSPCacheSettings(int ocsp_cache_size, int ocsp_min_cache_entry_duration, int ocsp_max_cache_entry_duration) throws GeneralSecurityException {
        this.OCSPCacheSettingsNative(ocsp_cache_size, ocsp_min_cache_entry_duration, ocsp_max_cache_entry_duration);
    }

    private native void OCSPCacheSettingsNative(int var1, int var2, int var3) throws GeneralSecurityException;

    public void setOCSPTimeout(int ocsp_timeout) throws GeneralSecurityException {
        this.setOCSPTimeoutNative(ocsp_timeout);
    }

    private native void setOCSPTimeoutNative(int var1) throws GeneralSecurityException;

    public synchronized void shutdown() throws Exception {
        try {
            NativeProxy.purgeAllInRegistry();
        }
        finally {
            this.shutdownNative();
            instance = null;
        }
    }

    public native void shutdownNative();

    static {
        CryptoManager.loadLibrary();
        instance = null;
        TYPE_KRL = 0;
        TYPE_CRL = 1;
        JSS_DEBUG = CryptoManager.getJSSDebug();
        ocspPolicy = OCSPPolicy.NONE;
    }

    public static final class CertUsage {
        private static ArrayList<CertUsage> list = new ArrayList();
        private int usage;
        private String name;
        public static final CertUsage SSLClient = new CertUsage(0, "SSLClient");
        public static final CertUsage SSLServer = new CertUsage(1, "SSLServer");
        public static final CertUsage SSLServerWithStepUp = new CertUsage(2, "SSLServerWithStepUp");
        public static final CertUsage SSLCA = new CertUsage(3, "SSLCA");
        public static final CertUsage EmailSigner = new CertUsage(4, "EmailSigner");
        public static final CertUsage EmailRecipient = new CertUsage(5, "EmailRecipient");
        public static final CertUsage ObjectSigner = new CertUsage(6, "ObjectSigner");
        public static final CertUsage UserCertImport = new CertUsage(7, "UserCertImport");
        public static final CertUsage VerifyCA = new CertUsage(8, "VerifyCA");
        public static final CertUsage ProtectedObjectSigner = new CertUsage(9, "ProtectedObjectSigner");
        public static final CertUsage StatusResponder = new CertUsage(10, "StatusResponder");
        public static final CertUsage AnyCA = new CertUsage(11, "AnyCA");

        private CertUsage() {
        }

        private CertUsage(int usage, String name) {
            this.usage = usage;
            this.name = name;
            list.add(this);
        }

        public int getUsage() {
            return this.usage;
        }

        public static Iterator<CertUsage> getCertUsages() {
            return list.iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum OCSPPolicy {
        NONE,
        NORMAL,
        LEAF_AND_CHAIN;

    }
}

