/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

public enum PKCS11Algorithm {
    CKM_AES_CBC(34, 4226L),
    CKM_AES_CBC_PAD(35, 4229L),
    CKM_AES_ECB(33, 4225L),
    CKM_AES_KEY_GEN(32, 4224L),
    CKM_DES3_CBC_PAD(14, 310L),
    CKM_DES3_ECB(12, 306L),
    CKM_DES3_KEY_GEN(16, 305L),
    CKM_DES_CBC_PAD(11, 293L),
    CKM_DES_KEY_GEN(15, 288L),
    CKM_DSA_KEY_PAIR_GEN(6, 16L),
    CKM_EC_KEY_PAIR_GEN(46, 4160L),
    CKM_NSS_AES_KEY_WRAP(57, 3461563217L),
    CKM_NSS_AES_KEY_WRAP_PAD(58, 3461563218L),
    CKM_PBA_SHA1_WITH_SHA1_HMAC(31, 960L),
    CKM_RC2_CBC_PAD(36, 261L),
    CKM_RC2_KEY_GEN(37, 256L),
    CKM_RC4_KEY_GEN(17, 272L),
    CKM_RSA_PKCS_KEY_PAIR_GEN(5, 0L),
    CKM_SHA_1_HMAC(27, 545L),
    CKM_SHA_256_HMAC(67, 593L),
    CKM_SHA_384_HMAC(68, 609L),
    CKM_SHA_512_HMAC(69, 625L),
    CKM_AES_CMAC(70, 4234L),
    CKM_SP800_108_COUNTER_KDF(72, 940L),
    CKM_SP800_108_FEEDBACK_KDF(73, 941L),
    CKM_SP800_108_DOUBLE_PIPELINE_KDF(74, 942L),
    CKM_NSS_SP800_108_COUNTER_KDF_DERIVE_DATA(75, 3461563258L),
    CKM_NSS_SP800_108_FEEDBACK_KDF_DERIVE_DATA(76, 3461563259L),
    CKM_NSS_SP800_108_DOUBLE_PIPELINE_KDF_DERIVE_DATA(77, 3461563260L),
    CKM_MD2(24, 512L),
    CKM_MD5(25, 528L),
    CKM_SHA_1(26, 544L),
    CKM_SHA256(38, 592L),
    CKM_SHA384(39, 608L),
    CKM_SHA512(40, 624L);

    private int alg_index;
    private long pk11_value;

    private PKCS11Algorithm(int alg_index, long pk11_value) {
        this.alg_index = alg_index;
        this.pk11_value = pk11_value;
    }

    public int getIndex() {
        return this.alg_index;
    }

    public long getValue() {
        return this.pk11_value;
    }

    public static PKCS11Algorithm valueOfIndex(int index) {
        for (PKCS11Algorithm alg : PKCS11Algorithm.values()) {
            if (alg.alg_index != index) continue;
            return alg;
        }
        return null;
    }

    public static PKCS11Algorithm valueOfConstant(long constant) {
        for (PKCS11Algorithm alg : PKCS11Algorithm.values()) {
            if (alg.pk11_value != constant) continue;
            return alg;
        }
        return null;
    }
}

