/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;

public class SerialNumber
implements Serializable {
    private static final long serialVersionUID = 1600956411497203535L;
    private BigInt serialNum;

    private void construct(DerValue derVal) throws IOException {
        this.serialNum = derVal.getInteger();
        if (derVal.data.available() != 0) {
            throw new IOException("Excess SerialNumber data");
        }
    }

    public SerialNumber(BigInteger num) {
        this.serialNum = new BigInt(num);
    }

    public SerialNumber(BigInt num) {
        this.serialNum = num;
    }

    public SerialNumber(int num) {
        this.serialNum = new BigInt(num);
    }

    public SerialNumber(DerInputStream in) throws IOException {
        DerValue derVal = in.getDerValue();
        this.construct(derVal);
    }

    public SerialNumber(DerValue val) throws IOException {
        this.construct(val);
    }

    public SerialNumber(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.construct(derVal);
    }

    public String toString() {
        return "SerialNumber: [" + this.serialNum.toString() + "]";
    }

    public void encode(DerOutputStream out) throws IOException {
        out.putInteger(this.serialNum);
    }

    public BigInt getNumber() {
        return this.serialNum;
    }
}

