/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.nss;

import org.mozilla.jss.nss.BufferProxy;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.nss.SSLFDProxy;

public class PR {
    public static final int SHUTDOWN_RCV = PR.getPRShutdownRcv();
    public static final int SHUTDOWN_SEND = PR.getPRShutdownSend();
    public static final int SHUTDOWN_BOTH = PR.getPRShutdownBoth();
    public static final int SUCCESS = PR.getPRSuccess();
    public static final int FAILURE = PR.getPRFailure();

    public static native PRFDProxy Open(String var0, int var1, int var2);

    public static native PRFDProxy NewTCPSocket();

    public static native PRFDProxy NewBufferPRFD(BufferProxy var0, BufferProxy var1, byte[] var2);

    public static int Close(PRFDProxy fd) {
        if (fd == null || fd.isNull()) {
            return SUCCESS;
        }
        return PR.Close(fd, true);
    }

    public static native int Close(PRFDProxy var0, boolean var1);

    public static synchronized int Close(SSLFDProxy fd) throws Exception {
        if (fd == null || fd.isNull()) {
            return SUCCESS;
        }
        return PR.Close(fd, false);
    }

    public static native int Shutdown(PRFDProxy var0, int var1);

    public static native byte[] Read(PRFDProxy var0, int var1);

    public static native byte[] Recv(PRFDProxy var0, int var1, int var2, long var3);

    public static native int Write(PRFDProxy var0, byte[] var1);

    public static native int Send(PRFDProxy var0, byte[] var1, int var2, long var3);

    public static native int GetError();

    public static String GetErrorText() {
        byte[] text = PR.GetErrorTextNative();
        if (text == null) {
            return "";
        }
        return new String(text);
    }

    private static native byte[] GetErrorTextNative();

    public static String ErrorToName(int code) {
        byte[] name = PR.ErrorToNameNative(code);
        if (name == null) {
            return "";
        }
        return new String(name);
    }

    private static native byte[] ErrorToNameNative(int var0);

    private static native int getPRShutdownRcv();

    private static native int getPRShutdownSend();

    private static native int getPRShutdownBoth();

    private static native int getPRSuccess();

    private static native int getPRFailure();
}

