/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;

public class KeyFactorySpi1_2
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec spec = (RSAPublicKeySpec)keySpec;
            SEQUENCE seq = new SEQUENCE();
            seq.addElement(new INTEGER(spec.getModulus()));
            seq.addElement(new INTEGER(spec.getPublicExponent()));
            return PK11PubKey.fromRaw(org.mozilla.jss.crypto.PrivateKey.RSA, ASN1Util.encode(seq));
        }
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec spec = (DSAPublicKeySpec)keySpec;
            SEQUENCE pqg = new SEQUENCE();
            pqg.addElement(new INTEGER(spec.getP()));
            pqg.addElement(new INTEGER(spec.getQ()));
            pqg.addElement(new INTEGER(spec.getG()));
            OBJECT_IDENTIFIER oid = null;
            try {
                oid = SignatureAlgorithm.DSASignature.toOID();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No such algorithm: " + e.getMessage(), e);
            }
            AlgorithmIdentifier algID = new AlgorithmIdentifier(oid, pqg);
            INTEGER publicValue = new INTEGER(spec.getY());
            byte[] encodedPublicValue = ASN1Util.encode(publicValue);
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(algID, new BIT_STRING(encodedPublicValue, 0));
            return PK11PubKey.fromSPKI(ASN1Util.encode(spki));
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec spec = (X509EncodedKeySpec)keySpec;
            return PK11PubKey.fromSPKI(spec.getEncoded());
        }
        throw new InvalidKeySpecException("Unsupported KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec spec = (RSAPrivateCrtKeySpec)keySpec;
                SEQUENCE privKey = new SEQUENCE();
                privKey.addElement(new INTEGER(0L));
                privKey.addElement(new INTEGER(spec.getModulus()));
                privKey.addElement(new INTEGER(spec.getPublicExponent()));
                privKey.addElement(new INTEGER(spec.getPrivateExponent()));
                privKey.addElement(new INTEGER(spec.getPrimeP()));
                privKey.addElement(new INTEGER(spec.getPrimeQ()));
                privKey.addElement(new INTEGER(spec.getPrimeExponentP()));
                privKey.addElement(new INTEGER(spec.getPrimeExponentQ()));
                privKey.addElement(new INTEGER(spec.getCrtCoefficient()));
                AlgorithmIdentifier algID = new AlgorithmIdentifier(org.mozilla.jss.crypto.PrivateKey.RSA.toOID(), null);
                OCTET_STRING encodedPrivKey = new OCTET_STRING(ASN1Util.encode(privKey));
                PrivateKeyInfo pki = new PrivateKeyInfo(new INTEGER(0L), algID, encodedPrivKey, null);
                return PK11PrivKey.fromPrivateKeyInfo(ASN1Util.encode(pki), TokenSupplierManager.getTokenSupplier().getThreadToken());
            }
            if (keySpec instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec spec = (DSAPrivateKeySpec)keySpec;
                SEQUENCE pqgParams = new SEQUENCE();
                pqgParams.addElement(new INTEGER(spec.getP()));
                pqgParams.addElement(new INTEGER(spec.getQ()));
                pqgParams.addElement(new INTEGER(spec.getG()));
                AlgorithmIdentifier algID = new AlgorithmIdentifier(org.mozilla.jss.crypto.PrivateKey.DSA.toOID(), pqgParams);
                OCTET_STRING privateKey = new OCTET_STRING(ASN1Util.encode(new INTEGER(spec.getX())));
                PrivateKeyInfo pki = new PrivateKeyInfo(new INTEGER(0L), algID, privateKey, null);
                BigInteger y = spec.getG().modPow(spec.getX(), spec.getP());
                byte[] yBA = y.toByteArray();
                if (y.bitLength() % 8 == 0) {
                    byte[] newBA = new byte[yBA.length - 1];
                    assert (newBA.length > 0);
                    System.arraycopy(yBA, 1, newBA, 0, newBA.length);
                    yBA = newBA;
                }
                return PK11PrivKey.fromPrivateKeyInfo(ASN1Util.encode(pki), TokenSupplierManager.getTokenSupplier().getThreadToken(), yBA);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return PK11PrivKey.fromPrivateKeyInfo((PKCS8EncodedKeySpec)keySpec, TokenSupplierManager.getTokenSupplier().getThreadToken());
            }
            throw new InvalidKeySpecException("Unsupported KeySpec type: " + keySpec.getClass().getName());
        }
        catch (TokenException te) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            te.printStackTrace(pw);
            throw new InvalidKeySpecException("TokenException: " + sw.toString());
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Exporting raw key data is not supported. Wrap the key instead.");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        byte[] encoded = key.getEncoded();
        String format = key.getFormat();
        try {
            if (format.equals("SubjectPublicKeyInfo") || format.equalsIgnoreCase("X.509")) {
                X509EncodedKeySpec spec = new X509EncodedKeySpec(encoded);
                return this.engineGeneratePublic(spec);
            }
            if (format.equals("PrivateKeyInfo") || format.equalsIgnoreCase("PKCS#8")) {
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encoded);
                return this.engineGeneratePrivate(spec);
            }
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        throw new InvalidKeyException("Unsupported encoding format: " + format);
    }
}

