/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSSocket;

public class JSSSocketChannel
extends SocketChannel {
    private JSSSocket sslSocket;
    private SocketChannel parent;
    private Socket parentSocket;
    private ReadableByteChannel readChannel;
    private WritableByteChannel writeChannel;
    private JSSEngine engine;
    private InputStream consumed;
    private ReadableByteChannel consumedChannel;
    private boolean autoClose = true;
    private boolean inboundClosed = false;
    private boolean outboundClosed = false;
    private ByteBuffer empty = ByteBuffer.allocate(0);
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private boolean handshakeCompleted = false;

    public JSSSocketChannel(JSSSocket sslSocket, SocketChannel parent, Socket parentSocket, ReadableByteChannel readChannel, WritableByteChannel writeChannel, JSSEngine engine) throws IOException {
        super(null);
        this.sslSocket = sslSocket;
        this.parent = parent;
        this.parentSocket = parentSocket;
        this.readChannel = readChannel;
        this.writeChannel = writeChannel;
        this.engine = engine;
        this.readBuffer = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        this.writeBuffer = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
    }

    public JSSSocketChannel(JSSSocket sslSocket, SocketChannel parent, JSSEngine engine) throws IOException {
        this(sslSocket, parent, parent.socket(), parent, parent, engine);
        this.configureBlocking(parent.isBlocking());
    }

    public JSSSocketChannel(JSSSocket sslSocket, Socket parentSocket, ReadableByteChannel readChannel, WritableByteChannel writeChannel, JSSEngine engine) throws IOException {
        this(sslSocket, null, parentSocket, readChannel, writeChannel, engine);
        this.configureBlocking(true);
    }

    public void setConsumedData(InputStream consumed) throws IOException {
        if (consumed != null && consumed.available() > 0) {
            this.consumed = consumed;
            this.consumedChannel = Channels.newChannel(consumed);
        }
    }

    public void setAutoClose(boolean on) {
        this.autoClose = on;
    }

    private int remoteRead() throws IOException {
        if (this.consumed != null) {
            int n = this.consumedChannel.read(this.readBuffer);
            if (n < 0) {
                this.consumed = null;
                this.consumedChannel = null;
                return 0;
            }
            return n;
        }
        if (this.isBlocking()) {
            ByteBuffer slice = this.readBuffer.slice();
            int available = this.parentSocket.getInputStream().available();
            if (slice.limit() > available) {
                slice.limit(available);
            }
            int n = this.readChannel.read(slice);
            this.readBuffer.position(this.readBuffer.position() + Math.max(n, 0));
            return n;
        }
        return this.readChannel.read(this.readBuffer);
    }

    @Override
    public boolean finishConnect() throws IOException {
        if (this.parent != null && !this.parent.finishConnect()) {
            return false;
        }
        SSLEngineResult.HandshakeStatus state = this.engine.getHandshakeStatus();
        if (state == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return true;
        }
        int handshakeAttempts = 0;
        int maxHandshakeAttempts = 100;
        if (!this.isBlocking()) {
            maxHandshakeAttempts = 10;
        }
        try {
            do {
                if (state == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.write(this.empty);
                } else if (state == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.read(this.empty);
                } else if (state == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    Runnable task = this.engine.getDelegatedTask();
                    task.run();
                } else {
                    Object msg = "Error attempting to handshake: unknown ";
                    msg = (String)msg + "handshake status code `" + state + "`";
                    throw new IOException((String)msg);
                }
                SSLEngineResult.HandshakeStatus lastState = state;
                state = this.engine.getHandshakeStatus();
                ++handshakeAttempts;
                if (state == lastState) {
                    try {
                        Thread.sleep((long)handshakeAttempts * 10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (handshakeAttempts <= maxHandshakeAttempts) continue;
                if (!this.isBlocking()) {
                    return false;
                }
                Object msg = "Error attempting to handshake: unable to ";
                msg = (String)msg + "complete handshake successfully in ";
                msg = (String)msg + maxHandshakeAttempts + " calls to wrap or unwrap. ";
                msg = (String)msg + "Connection stalled.";
                throw new IOException((String)msg);
            } while (state != SSLEngineResult.HandshakeStatus.FINISHED && state != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING);
        }
        catch (SSLException ssle) {
            Object msg = "Error attempting to handshake with remote peer: ";
            msg = (String)msg + "got unexpected exception: " + ssle.getMessage();
            throw new IOException((String)msg, ssle);
        }
        this.handshakeCompleted = true;
        this.sslSocket.notifyHandshakeCompletedListeners();
        return true;
    }

    private static long computeSize(ByteBuffer[] buffers, int offset, int length) throws IOException {
        long result = 0L;
        if (buffers == null || buffers.length == 0) {
            return result;
        }
        for (int rel_index = 0; rel_index < length; ++rel_index) {
            int index = offset + rel_index;
            if (index >= buffers.length) {
                String msg = "Offset (" + offset + " or length (" + length;
                msg = msg + ") exceeds contract based on number of buffers ";
                msg = msg + "given (" + buffers.length + ")";
                throw new IOException(msg);
            }
            if (buffers[index] == null) continue;
            result += (long)buffers[index].remaining();
        }
        return result;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.read(new ByteBuffer[]{dst});
    }

    @Override
    public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (this.inboundClosed) {
            return -1L;
        }
        long unwrapped = 0L;
        long decrypted = 0L;
        try {
            SSLEngineResult result;
            do {
                int n = this.remoteRead();
                if (this.readBuffer.position() == 0 && !this.handshakeCompleted) {
                    return decrypted > 0L ? decrypted : (long)n;
                }
                this.readBuffer.flip();
                result = this.engine.unwrap(this.readBuffer, dsts, offset, length);
                switch (result.getStatus()) {
                    case CLOSED: {
                        this.shutdownInput();
                        break;
                    }
                    case OK: 
                    case BUFFER_UNDERFLOW: {
                        break;
                    }
                    default: {
                        throw new IOException("Unexpected status from unwrap: " + result);
                    }
                }
                unwrapped += (long)result.bytesConsumed();
                decrypted += (long)result.bytesProduced();
                this.readBuffer.compact();
            } while (result.bytesConsumed() > 0);
        }
        catch (SSLException ssle) {
            Object msg = "Unable to unwrap data using SSLEngine: ";
            msg = (String)msg + ssle.getMessage();
            throw new IOException((String)msg, ssle);
        }
        return decrypted;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.write(new ByteBuffer[]{src});
    }

    @Override
    public synchronized long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.outboundClosed) {
            return -1L;
        }
        this.writeBuffer.clear();
        ByteBuffer dst = this.writeBuffer;
        long wrapped = 0L;
        long encrypted = 0L;
        long sent = 0L;
        try {
            do {
                SSLEngineResult result;
                if ((result = this.engine.wrap(srcs, offset, length, dst)).getStatus() != SSLEngineResult.Status.OK && result.getStatus() != SSLEngineResult.Status.CLOSED) {
                    throw new IOException("Unexpected status from wrap: " + result);
                }
                wrapped += (long)result.bytesConsumed();
                dst.flip();
                int thisWrite = this.writeChannel.write(dst);
                if ((sent += (long)thisWrite) < (encrypted += (long)result.bytesProduced()) && result.bytesConsumed() == 0 && result.bytesProduced() == 0 && thisWrite == 0) {
                    Object msg = "Calls to wrap or write stalled, consuming ";
                    msg = (String)msg + "and producing no data: sent " + sent + " bytes ";
                    msg = (String)msg + "of " + encrypted + " bytes encrypted to peer.";
                    throw new IOException((String)msg);
                }
                dst.flip();
            } while (sent < encrypted);
        }
        catch (SSLException ssle) {
            Object msg = "Unable to wrap data with SSLEngine: ";
            msg = (String)msg + ssle.getMessage();
            throw new IOException((String)msg, ssle);
        }
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        try {
            JSSSocketChannel jSSSocketChannel = this;
            synchronized (jSSSocketChannel) {
                ByteBuffer readOne = ByteBuffer.allocate(1);
                this.shutdownInput();
                this.inboundClosed = false;
                this.read(readOne);
                if (!this.outboundClosed) {
                    this.shutdownOutput();
                }
                this.engine.closeInbound();
                this.outboundClosed = true;
                this.inboundClosed = true;
            }
        }
        finally {
            this.engine.cleanup();
            this.engine = null;
            if (this.autoClose) {
                if (this.parent == null) {
                    this.parentSocket.shutdownInput();
                    this.parentSocket.shutdownOutput();
                    this.parentSocket.close();
                } else {
                    this.parent.shutdownInput();
                    this.parent.shutdownOutput();
                    this.parent.close();
                }
            }
        }
    }

    public void setListeners(Collection<? extends EventListener> listeners) {
        this.engine.setListeners(listeners);
    }

    public Collection<? extends EventListener> getListeners() {
        return this.engine.getListeners();
    }

    @Override
    public JSSSocketChannel bind(SocketAddress local) throws IOException {
        if (this.parent == null) {
            this.parentSocket.bind(local);
            return this;
        }
        this.parent.bind(local);
        return this;
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        if (this.parent == null) {
            this.parentSocket.connect(remote);
            return true;
        }
        return this.parent.connect(remote);
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.supportedOptions();
    }

    @Override
    public <T> JSSSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        if (this.parent != null) {
            this.parent.setOption((SocketOption)name, (Object)value);
        }
        return this;
    }

    @Override
    public JSSSocket socket() {
        return this.sslSocket;
    }

    @Override
    public boolean isConnected() {
        if (this.parent == null) {
            return this.parentSocket.isConnected();
        }
        return this.parent.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        if (this.parent == null) {
            return !this.parentSocket.isConnected();
        }
        return this.parent.isConnectionPending();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        if (this.parent == null) {
            return this.parentSocket.getLocalSocketAddress();
        }
        return this.parent.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        if (this.parent == null) {
            return this.parentSocket.getRemoteSocketAddress();
        }
        return this.parent.getRemoteAddress();
    }

    @Override
    public JSSSocketChannel shutdownInput() throws IOException {
        this.inboundClosed = true;
        return this;
    }

    @Override
    public JSSSocketChannel shutdownOutput() throws IOException {
        this.engine.closeOutbound();
        this.write(this.empty);
        this.outboundClosed = true;
        return this;
    }

    @Override
    public void implConfigureBlocking(boolean block) throws IOException {
        if (this.parent == null) {
            return;
        }
        this.parent.configureBlocking(block);
    }
}

