/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class GenerateTestCert {
    private X509Certificate nssServerCert;
    private X509Certificate nssClientCert;
    private static final String CACERT_NICKNAME = "JSSCATestCert";
    private static final String SERVERCERT_NICKNAME = "JSSTestServerCert";
    private static final String CLIENTCERT_NICKNAME = "JSSTestClientCert";
    private String keyType = "RSA";
    private int keyLength = 4096;
    private SignatureAlgorithm sigAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;

    public static void main(String[] args) throws Exception {
        GenerateTestCert gtc = new GenerateTestCert();
        if (args.length > 0) {
            gtc.doIt(args);
        } else {
            gtc.usage();
        }
    }

    public void usage() {
        System.out.println("USAGE: java org.mozilla.jss.tests.GenerateTestCert <test dir> <password file> <serial Number > [hostname] [Signature Alg] [CAcertNickname] [ServerCertNickname] [ClientCertNickName]");
        System.out.println("This program creates self signed Certificates.They are only meant for testing and should never be used in production. \nThe default nicknames:\n\tCA certificate: JSSCATestCert\n\tServer certificate: JSSTestServerCert\n\tClient certificate: JSSTestClientCert");
        System.out.println("Signature algorithm values:\n\tSHA-1/RSA\tSHA-256/RSA\tSHA-384/RSA\tSHA-512/RSA\tSHA-1/DSA\tSHA-1/EC\tSHA-256/EC\tSHA-384/EC\tSHA-512/EC");
        System.exit(1);
    }

    private void setSigAlg(String alg2) {
        if (alg2.equalsIgnoreCase("SHA-1/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
        } else if (alg2.equalsIgnoreCase("SHA-256/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
        } else if (alg2.equalsIgnoreCase("SHA-384/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA384Digest;
        } else if (alg2.equalsIgnoreCase("SHA-512/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA512Digest;
        } else if (alg2.equalsIgnoreCase("SHA-1/DSA")) {
            this.sigAlg = SignatureAlgorithm.DSASignatureWithSHA1Digest;
        } else if (alg2.equalsIgnoreCase("SHA-1/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA1Digest;
        } else if (alg2.equalsIgnoreCase("SHA-256/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA256Digest;
        } else if (alg2.equalsIgnoreCase("SHA-384/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA384Digest;
        } else if (alg2.equalsIgnoreCase("SHA-512/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA512Digest;
        } else {
            this.usage();
        }
        if (alg2.endsWith("RSA")) {
            this.keyType = "RSA";
        } else if (alg2.endsWith("DSA")) {
            this.keyType = "DSA";
            this.keyLength = 1024;
        } else if (alg2.endsWith("EC")) {
            this.keyType = "EC";
            this.keyLength = 256;
        } else {
            this.usage();
        }
    }

    private void doIt(String[] args) throws Exception {
        String caCertNick = CACERT_NICKNAME;
        String serverCertNick = SERVERCERT_NICKNAME;
        String clientCertNick = CLIENTCERT_NICKNAME;
        if (args.length < 3) {
            this.usage();
        }
        try {
            X509Certificate[] certs;
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken tok = cm.getInternalKeyStorageToken();
            FilePasswordCallback cb = new FilePasswordCallback(args[1]);
            tok.login((PasswordCallback)cb);
            int serialNum = Integer.parseInt(args[2]);
            X509Certificate[] permCerts = cm.getPermCerts();
            int originalPermCerts = permCerts.length;
            System.out.println("Number of certificates stored in the  database: " + originalPermCerts);
            String hostname = "localhost";
            if (args.length > 4) {
                hostname = args[3];
            }
            String alg2 = "SHA-256/RSA";
            if (args.length > 5) {
                alg2 = args[4];
            }
            this.setSigAlg(alg2);
            if (args.length > 6) {
                caCertNick = args[5];
            }
            if ((certs = cm.findCertsByNickname(caCertNick)).length > 0) {
                System.out.println(caCertNick + " already exists!");
                System.exit(1);
            }
            if (args.length > 7) {
                serverCertNick = args[6];
            }
            if ((certs = cm.findCertsByNickname(serverCertNick)).length > 0) {
                System.out.println(serverCertNick + " already exists!");
                System.exit(1);
            }
            if (args.length == 8) {
                clientCertNick = args[7];
            }
            if ((certs = cm.findCertsByNickname(clientCertNick)).length > 0) {
                System.out.println(clientCertNick + " already exists!");
                System.exit(1);
            }
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.keyType, "Mozilla-JSS");
            kpg.initialize(this.keyLength);
            KeyPair caPair = kpg.genKeyPair();
            SEQUENCE extensions = new SEQUENCE();
            extensions.addElement((ASN1Value)this.makeBasicConstraintsExtension());
            Certificate caCert = this.makeCert("CACert", "CACert", serialNum, caPair.getPrivate(), caPair.getPublic(), serialNum, extensions);
            X509Certificate nssCaCert = cm.importUserCACertPackage(ASN1Util.encode((ASN1Value)caCert), caCertNick);
            InternalCertificate intern = (InternalCertificate)nssCaCert;
            intern.setSSLTrust(152);
            kpg.initialize(this.keyLength);
            KeyPair serverPair = kpg.genKeyPair();
            Certificate serverCert = this.makeCert("CACert", hostname, serialNum + 1, caPair.getPrivate(), serverPair.getPublic(), serialNum, null);
            this.nssServerCert = cm.importCertPackage(ASN1Util.encode((ASN1Value)serverCert), serverCertNick);
            kpg.initialize(this.keyLength);
            KeyPair clientPair = kpg.genKeyPair();
            Certificate clientCert = this.makeCert("CACert", "ClientCert", serialNum + 2, caPair.getPrivate(), clientPair.getPublic(), serialNum, null);
            this.nssClientCert = cm.importCertPackage(ASN1Util.encode((ASN1Value)clientCert), clientCertNick);
            System.out.println("\nThis program created certificates with \nfollowing cert nicknames:\n\t" + caCertNick + "\n\t" + serverCertNick + "\n\t" + clientCertNick);
            permCerts = cm.getPermCerts();
            if (originalPermCerts + 3 != permCerts.length) {
                System.out.println("Error there should be three more  certificates stored in the database");
                System.exit(1);
            } else {
                System.out.println("Number of certificates stored in the  database: " + permCerts.length);
            }
            certs = cm.findCertsByNickname(caCertNick);
            if (certs.length == 0) {
                System.out.println(caCertNick + " should exist!");
                System.exit(1);
            }
            if ((certs = cm.findCertsByNickname(serverCertNick)).length == 0) {
                System.out.println(serverCertNick + " should exist!");
                System.exit(1);
            }
            if ((certs = cm.findCertsByNickname(clientCertNick)).length == 0) {
                System.out.println(clientCertNick + " should exist!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE bc = new SEQUENCE();
        bc.addElement((ASN1Value)new BOOLEAN(true));
        OBJECT_IDENTIFIER bcOID = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING enc = new OCTET_STRING(ASN1Util.encode((ASN1Value)bc));
        return new Extension(bcOID, true, enc);
    }

    private Certificate makeCert(String issuerName, String subjectName, int serialNumber, PrivateKey privKey, PublicKey pubKey, int rand, SEQUENCE extensions) throws Exception {
        AlgorithmIdentifier sigAlgID = null;
        sigAlgID = this.keyType.equals("RSA") ? new AlgorithmIdentifier(this.sigAlg.toOID(), null) : new AlgorithmIdentifier(this.sigAlg.toOID());
        Name issuer = new Name();
        issuer.addCountryName("US");
        issuer.addOrganizationName("Mozilla");
        issuer.addOrganizationalUnitName("JSS Testing" + rand);
        issuer.addCommonName(issuerName);
        Name subject = new Name();
        subject.addCountryName("US");
        subject.addOrganizationName("Mozilla");
        subject.addOrganizationalUnitName("JSS Testing" + rand);
        subject.addCommonName(subjectName);
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(1, 1);
        Date notAfter = cal.getTime();
        SubjectPublicKeyInfo.Template spkiTemp = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ASN1Util.decode((ASN1Template)spkiTemp, (byte[])pubKey.getEncoded());
        CertificateInfo info = new CertificateInfo(CertificateInfo.v3, new INTEGER((long)serialNumber), sigAlgID, issuer, notBefore, notAfter, subject, spki);
        if (extensions != null) {
            info.setExtensions(extensions);
        }
        return new Certificate(info, privKey, this.sigAlg);
    }
}

