/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;

public class JCASymKeyGen {
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    byte[] plainText = "Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!Firefox   rules!".getBytes();
    byte[] plainTextPad = "Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!Thunderbird rules!".getBytes();
    byte[] plainTextB = "NSPR   NSS  JSS!NSPR   NSS  JSS!NSPR   NSS  JSS!".getBytes();
    byte[] plainTextPadB = "Use Firefox and Thunderbird!".getBytes();
    static boolean bFipsMode = false;

    public JCASymKeyGen(String certDbLoc, String passwdFile) {
        try {
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken token = cm.getInternalCryptoToken();
            if (cm.FIPSEnabled()) {
                try {
                    bFipsMode = true;
                    FilePasswordCallback cb = new FilePasswordCallback(passwdFile);
                    token.login((PasswordCallback)cb);
                    System.out.println("Logged in");
                }
                catch (IncorrectPasswordException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                catch (TokenException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
        }
        catch (NotInitializedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public SecretKey genSecretKey(String keyType, String provider) {
        SecretKey key = null;
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(keyType, provider);
            if (keyType.equals("AES") || keyType.equals("RC2")) {
                kg.init(128);
            }
            System.out.println("Key " + keyType + " generation done by " + kg.getProvider().toString());
            key = kg.generateKey();
            if (!this.checkAlgorithm(key, keyType)) {
                throw new Exception("Error: " + key.getAlgorithm() + "  algorithm");
            }
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return key;
    }

    public SecretKey genPBESecretKey(String keyType, String provider) {
        SecretKey key = null;
        SecretKeyFactory kf = null;
        try {
            char[] pw = "thunderbird".toCharArray();
            byte[] salt = new byte[8];
            SecureRandom random = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
            random.nextBytes(salt);
            int iterationCount = 2;
            kf = SecretKeyFactory.getInstance(keyType, provider);
            PBEKeySpec keySpec = new PBEKeySpec(pw, salt, iterationCount);
            key = kf.generateSecret(keySpec);
            System.out.println("Key " + keyType + " generation done by " + kf.getProvider().toString());
            if (!bFipsMode) {
                System.out.println("The length of the generated key in bits: " + key.getEncoded().length * 8 + " " + key.getAlgorithm());
            }
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return key;
    }

    public void testCipher(SecretKey sKey, String algFamily, String algType, String providerForEncrypt, String providerForDecrypt) throws Exception {
        try {
            byte[] plaintext = this.plainText;
            if (algType.endsWith("PKCS5Padding")) {
                plaintext = this.plainTextPad;
            }
            Cipher cipher2 = Cipher.getInstance(algType, providerForEncrypt);
            AlgorithmParameters ap = null;
            byte[] encodedAlgParams = null;
            RC2ParameterSpec RC2ParSpec = null;
            if (algFamily.compareToIgnoreCase("RC2") == 0) {
                byte[] iv = new byte[8];
                SecureRandom random = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
                random.nextBytes(iv);
                RC2ParSpec = new RC2ParameterSpec(128, iv);
                cipher2.init(1, (Key)sKey, RC2ParSpec);
            } else {
                cipher2.init(1, sKey);
                ap = cipher2.getParameters();
                if (ap != null) {
                    encodedAlgParams = ap.getEncoded();
                }
            }
            byte[] ciphertext = new byte[cipher2.getOutputSize(plaintext.length)];
            int cLen = cipher2.update(plaintext, 0, plaintext.length, ciphertext, 0);
            cLen += cipher2.doFinal(ciphertext, cLen);
            cipher2 = Cipher.getInstance(algType, providerForDecrypt);
            if (encodedAlgParams == null) {
                if (RC2ParSpec != null) {
                    cipher2.init(2, (Key)sKey, RC2ParSpec);
                } else {
                    cipher2.init(2, sKey);
                }
            } else {
                AlgorithmParameters aps = AlgorithmParameters.getInstance(algFamily);
                aps.init(encodedAlgParams);
                cipher2.init(2, (Key)sKey, aps);
            }
            byte[] recovered = new byte[cLen];
            int rLen = cipher2.update(ciphertext, 0, cLen, recovered, 0);
            rLen += cipher2.doFinal(recovered, rLen);
            boolean isEqual = true;
            for (int i = 0; i < plaintext.length; ++i) {
                if (plaintext[i] == recovered[i]) continue;
                isEqual = false;
                break;
            }
            if (!isEqual) {
                throw new Exception("ERROR: " + providerForEncrypt + " and " + providerForDecrypt + " failed for " + algType);
            }
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
        }
        catch (BadPaddingException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
        catch (IllegalBlockSizeException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public void testMultiPartCipher(SecretKey sKey, String algFamily, String algType, String providerForEncrypt, String providerForDecrypt) throws Exception {
        try {
            byte[] plaintext = this.plainText;
            byte[] plaintextB = this.plainTextB;
            if (algType.endsWith("PKCS5Padding")) {
                plaintext = this.plainTextPad;
                plaintextB = this.plainTextPadB;
            }
            Cipher cipher2 = Cipher.getInstance(algType, providerForEncrypt);
            AlgorithmParameters ap = null;
            byte[] encodedAlgParams = null;
            RC2ParameterSpec RC2ParSpec = null;
            if (algFamily.compareToIgnoreCase("RC2") == 0) {
                byte[] iv = new byte[8];
                SecureRandom random = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
                random.nextBytes(iv);
                RC2ParSpec = new RC2ParameterSpec(128, iv);
                cipher2.init(1, (Key)sKey, RC2ParSpec);
            } else {
                cipher2.init(1, sKey);
                ap = cipher2.getParameters();
                if (ap != null) {
                    encodedAlgParams = ap.getEncoded();
                }
            }
            byte[] ciphertext = new byte[cipher2.getOutputSize(plaintext.length + plaintextB.length)];
            int cLen = cipher2.update(plaintext, 0, plaintext.length, ciphertext, 0);
            cLen += cipher2.update(plaintextB, 0, plaintextB.length, ciphertext, cLen);
            cLen += cipher2.doFinal(ciphertext, cLen);
            cipher2 = Cipher.getInstance(algType, providerForDecrypt);
            if (encodedAlgParams == null) {
                if (RC2ParSpec != null) {
                    cipher2.init(2, (Key)sKey, RC2ParSpec);
                } else {
                    cipher2.init(2, sKey);
                }
            } else {
                AlgorithmParameters aps = AlgorithmParameters.getInstance(algFamily);
                aps.init(encodedAlgParams);
                cipher2.init(2, (Key)sKey, aps);
            }
            byte[] recovered = new byte[cLen];
            int rLen = cipher2.update(ciphertext, 0, cLen, recovered, 0);
            rLen += cipher2.doFinal(recovered, rLen);
            boolean isEqual = true;
            for (int i = 0; i < plaintext.length; ++i) {
                if (i < plaintext.length) {
                    if (plaintext[i] == recovered[i]) continue;
                    isEqual = false;
                    break;
                }
                if (plaintextB[i - this.plainText.length] != recovered[i]) continue;
                isEqual = false;
                break;
            }
            if (!isEqual) {
                throw new Exception("ERROR: " + providerForEncrypt + " and " + providerForDecrypt + " failed for " + algType);
            }
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace();
        }
        catch (BadPaddingException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
        catch (IllegalBlockSizeException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String certDbLoc = ".";
        String passwdFile = null;
        String[][] symKeyTable = new String[][]{{"DES", "DES/ECB/NoPadding", "DES/CBC/PKCS5Padding", "DES/CBC/NoPadding"}, {"DESede", "DESede/ECB/NoPadding", "DESede/CBC/PKCS5Padding", "DESede/CBC/NoPadding"}, {"AES", "AES/ECB/NoPadding", "AES/CBC/NoPadding", "AES/CBC/PKCS5Padding"}, {"RC2", "RC2/CBC/NoPadding", "RC2/CBC/PKCS5Padding"}, {"PBEWithMD5AndDES", "DES/ECB/NoPadding"}, {"PBEWithSHA1AndDES"}, {"PBEWithSHA1AndDESede", "DESede/ECB/NoPadding"}};
        if (args.length <= 2) {
            certDbLoc = args[0];
            if (args.length == 2) {
                passwdFile = args[1];
            }
        } else {
            System.out.println("USAGE: java org.mozilla.jss.tests.JCASymKeyGen <certDbPath> [passwordFile]");
            System.out.println("password file only required if in FIPSMODE.");
            System.out.println("FIPSMODE requires Java 1.6 or higher!");
            System.exit(1);
        }
        String otherProvider = new String("IBMJCE");
        Provider p = null;
        p = Security.getProvider(otherProvider);
        if (p == null && (p = Security.getProvider(otherProvider = new String("SunJCE"))) == null) {
            System.out.println("unable to find IBMJCE or SunJCE providers");
            System.exit(1);
        }
        JCASymKeyGen skg = new JCASymKeyGen(certDbLoc, passwdFile);
        System.out.println(otherProvider + ": " + p.getInfo());
        p = Security.getProvider(MOZ_PROVIDER_NAME);
        System.out.println("Mozilla-JSS: " + p.getInfo());
        SecretKey mozKey = null;
        try {
            for (int i = 0; i < symKeyTable.length; ++i) {
                try {
                    mozKey = symKeyTable[i][0].startsWith("PBE") ? skg.genPBESecretKey(symKeyTable[i][0], MOZ_PROVIDER_NAME) : skg.genSecretKey(symKeyTable[i][0], MOZ_PROVIDER_NAME);
                }
                catch (Exception e) {
                    System.out.println("unable to generate key: " + symKeyTable[i][0] + " " + e.getMessage());
                }
                for (int a = 1; a < symKeyTable[i].length; ++a) {
                    skg.testCipher(mozKey, symKeyTable[i][0], symKeyTable[i][a], MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
                    skg.testMultiPartCipher(mozKey, symKeyTable[i][0], symKeyTable[i][a], MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
                    try {
                        Cipher cipher2 = Cipher.getInstance(symKeyTable[i][a], otherProvider);
                    }
                    catch (Exception e) {
                        System.out.println("Mozilla-JSS only supports " + symKeyTable[i][a]);
                        continue;
                    }
                    if (bFipsMode) continue;
                    skg.testCipher(mozKey, symKeyTable[i][0], symKeyTable[i][a], MOZ_PROVIDER_NAME, otherProvider);
                    skg.testMultiPartCipher(mozKey, symKeyTable[i][0], symKeyTable[i][a], MOZ_PROVIDER_NAME, otherProvider);
                    skg.testCipher(mozKey, symKeyTable[i][0], symKeyTable[i][a], otherProvider, MOZ_PROVIDER_NAME);
                    skg.testMultiPartCipher(mozKey, symKeyTable[i][0], symKeyTable[i][a], otherProvider, MOZ_PROVIDER_NAME);
                    System.out.println("Mozilla-JSS and  " + otherProvider + " tested " + symKeyTable[i][a]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private boolean checkAlgorithm(SecretKey k, String alg2) {
        boolean status = false;
        if (k.getAlgorithm().equals(alg2)) {
            status = true;
        }
        return status;
    }
}

