/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.CryptoManager;

public class JSSPackageTest {
    public static void main(String[] args) {
        try {
            Package pkg = ClassLoader.getSystemClassLoader().getDefinedPackage("org.mozilla.jss");
            if (pkg != null) {
                System.out.println("\n---------------------------------------------------------");
                System.out.println("Checking jss jar and library version");
                System.out.println("---------------------------------------------------------");
                System.out.println("              Introspecting jss jar file");
                System.out.println("Package name:\t" + pkg.getName());
                System.out.println("Spec title  :\t" + pkg.getSpecificationTitle());
                System.out.println("Spec vendor :\t" + pkg.getSpecificationVendor());
                System.out.println("Spec version:\t" + pkg.getSpecificationVersion());
                System.out.println("Impl title  :\t" + pkg.getImplementationTitle());
                System.out.println("Impl vendor :\t" + pkg.getImplementationVendor());
                System.out.println("Impl version:\t" + pkg.getImplementationVersion());
            }
            System.out.println("\n\tFetching version information from CryptoManager");
            System.out.println("\n\t" + CryptoManager.getJSSVersion());
            System.out.println("\n\tTo check the JNI version in libjss.so:");
            System.out.println("\n\ttry: strings libjss.so | grep -i header");
            System.out.println("\n\tor : ident libjss.so");
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Exception caught : " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

