/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.EOFException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NicknameConflictException;
import org.mozilla.jss.UserCertConflictException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.NoSuchItemOnTokenException;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLProtocolVariant;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLVersionRange;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class SSLClientAuth
implements Runnable {
    private CryptoManager cm;
    public static final SignatureAlgorithm sigAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
    private X509Certificate nssServerCert;
    private X509Certificate nssClientCert;
    private String serverCertNick;
    private String clientCertNick;
    private boolean useNickname;
    private boolean success = true;
    public int port = 29752;
    public int serialNum = 0;
    public boolean serverReady = false;

    public static Certificate makeCert(String issuerName, String subjectName, int serialNumber, PrivateKey privKey, PublicKey pubKey, int rand, SEQUENCE extensions) throws Exception {
        AlgorithmIdentifier sigAlgID = new AlgorithmIdentifier(sigAlg.toOID(), null);
        Name issuer = new Name();
        issuer.addCountryName("US");
        issuer.addOrganizationName("Mozilla");
        issuer.addOrganizationalUnitName("JSS Testing" + rand);
        issuer.addCommonName(issuerName);
        Name subject = new Name();
        subject.addCountryName("US");
        subject.addOrganizationName("Mozilla");
        subject.addOrganizationalUnitName("JSS Testing" + rand);
        subject.addCommonName(subjectName);
        Calendar cal = Calendar.getInstance();
        Date notBefore = cal.getTime();
        cal.add(1, 1);
        Date notAfter = cal.getTime();
        SubjectPublicKeyInfo.Template spkiTemp = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ASN1Util.decode((ASN1Template)spkiTemp, (byte[])pubKey.getEncoded());
        CertificateInfo info = new CertificateInfo(CertificateInfo.v3, new INTEGER((long)serialNumber), sigAlgID, issuer, notBefore, notAfter, subject, spki);
        if (extensions != null) {
            info.setExtensions(extensions);
        }
        return new Certificate(info, privKey, sigAlg);
    }

    public static void main(String[] args) throws Exception {
        new SSLClientAuth().doIt(args);
    }

    public void doIt(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: java org.mozilla.jss.tests.SSLClientAuth <dbdir> <passwordFile> [port] [Certificate Serial Number]");
            System.exit(1);
        }
        this.cm = CryptoManager.getInstance();
        CryptoToken tok = this.cm.getInternalKeyStorageToken();
        FilePasswordCallback cb = new FilePasswordCallback(args[1]);
        tok.login((PasswordCallback)cb);
        if (args.length >= 3) {
            this.port = Integer.parseInt(args[2]);
            System.out.println("using port:" + this.port);
        }
        if (args.length >= 4) {
            this.serialNum = Integer.parseInt(args[3]);
        } else {
            SecureRandom rng = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            this.serialNum = SSLClientAuth.nextRandInt(rng);
        }
        this.serverCertNick = "SSLserver-" + this.serialNum;
        this.clientCertNick = "SSLclient-" + this.serialNum;
        X509Certificate[] certs = this.cm.findCertsByNickname(this.serverCertNick);
        if (certs.length == 0) {
            this.generateCerts(this.cm, this.serialNum);
        } else {
            try {
                this.nssServerCert = this.cm.findCertByNickname(this.serverCertNick);
                this.nssClientCert = this.cm.findCertByNickname(this.clientCertNick);
            }
            catch (TokenException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            catch (ObjectNotFoundException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        this.configureDefaultSSLoptions();
        this.testSpecificCiphers();
        this.useNickname = false;
        this.testConnection();
        this.useNickname = true;
        this.testConnection();
        System.out.println("Exiting main()");
        if (this.getSuccess()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private void generateCerts(CryptoManager cm, int serialNum) {
        int keyLength = 4096;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "Mozilla-JSS");
            kpg.initialize(keyLength);
            KeyPair caPair = kpg.genKeyPair();
            SEQUENCE extensions = new SEQUENCE();
            extensions.addElement((ASN1Value)SSLClientAuth.makeBasicConstraintsExtension());
            Certificate caCert = SSLClientAuth.makeCert("CACert", "CACert", serialNum, caPair.getPrivate(), caPair.getPublic(), serialNum, extensions);
            X509Certificate nssCaCert = cm.importUserCACertPackage(ASN1Util.encode((ASN1Value)caCert), "SSLCA-" + serialNum);
            InternalCertificate intern = (InternalCertificate)nssCaCert;
            intern.setSSLTrust(152);
            kpg.initialize(keyLength);
            KeyPair serverPair = kpg.genKeyPair();
            Certificate serverCert = SSLClientAuth.makeCert("CACert", "localhost", serialNum + 1, caPair.getPrivate(), serverPair.getPublic(), serialNum, null);
            this.nssServerCert = cm.importCertPackage(ASN1Util.encode((ASN1Value)serverCert), this.serverCertNick);
            kpg.initialize(keyLength);
            KeyPair clientPair = kpg.genKeyPair();
            Certificate clientCert = SSLClientAuth.makeCert("CACert", "ClientCert", serialNum + 2, caPair.getPrivate(), clientPair.getPublic(), serialNum, null);
            this.nssClientCert = cm.importCertPackage(ASN1Util.encode((ASN1Value)clientCert), this.clientCertNick);
        }
        catch (CertificateEncodingException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NicknameConflictException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserCertConflictException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (TokenException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchItemOnTokenException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void configureDefaultSSLoptions() {
        try {
            SSLSocket.enableSSL2Default((boolean)false);
            SSLSocket.enableSSL3Default((boolean)false);
            SSLSocket.setSSLVersionRangeDefault((SSLProtocolVariant)SSLProtocolVariant.STREAM, (SSLVersionRange)new SSLVersionRange(32, 32));
            SSLSocket.enableSessionTicketsDefault((boolean)true);
            if (this.cm.FIPSEnabled()) {
                System.out.println("The NSS database is configured in FIPSmode.");
                System.out.println("Enable ony FIPS ciphersuites.");
                int[] ciphers = SSLSocket.getImplementedCipherSuites();
                for (int i = 0; i < ciphers.length; ++i) {
                    if (SSLSocket.isFipsCipherSuite((int)ciphers[i])) {
                        SSLSocket.setCipherPreferenceDefault((int)ciphers[i], (boolean)true);
                        continue;
                    }
                    if (!SSLSocket.getCipherPreferenceDefault((int)ciphers[i])) continue;
                    SSLSocket.setCipherPreferenceDefault((int)ciphers[i], (boolean)false);
                }
            }
        }
        catch (SocketException ex) {
            System.out.println("Error configuring default SSL options.");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void testSpecificCiphers() {
        try {
            SSLSocket.enableSSL2Default((boolean)false);
            SSLSocket.enableSSL3Default((boolean)false);
            SSLSocket.enableSessionTicketsDefault((boolean)true);
        }
        catch (SocketException ex) {
            System.out.println("Error configuring ciphers.");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection() throws Exception {
        this.serverReady = false;
        Thread server = new Thread(this);
        server.start();
        SSLClientAuth sSLClientAuth = this;
        synchronized (sSLClientAuth) {
            while (!this.serverReady) {
                this.wait();
            }
        }
        System.out.println("client about to connect");
        SSLSocket sock = new SSLSocket("localhost", this.port);
        if (this.useNickname) {
            sock.setClientCertNickname(this.clientCertNick);
            System.out.println("Client specified cert by nickname");
        } else {
            sock.setClientCert(this.nssClientCert);
            System.out.println("Client specified cert directly");
        }
        System.out.println("client connected");
        sock.addHandshakeCompletedListener((SSLHandshakeCompletedListener)new HandshakeListener("client", this));
        sock.forceHandshake();
        String cipher2 = sock.getStatus().getCipher();
        System.out.println("client forced handshake. ciphersuite: " + cipher2);
        sock.close();
        server.join();
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SSLServerSocket.configServerSessionIDCache((int)10, (int)100, (int)100, null);
            System.out.println("Server about to create socket");
            SSLServerSocket serverSock = new SSLServerSocket(this.port, 5, null, null, true);
            System.out.println("Server created socket");
            serverSock.requireClientAuth(20);
            if (this.useNickname) {
                serverSock.setServerCertNickname(this.serverCertNick);
                System.out.println("Server specified cert by nickname");
            } else {
                serverSock.setServerCert(this.nssServerCert);
                System.out.println("Server specified cert directly");
            }
            SSLClientAuth sSLClientAuth = this;
            synchronized (sSLClientAuth) {
                this.serverReady = true;
                this.notify();
            }
            System.out.println("Server about to accept");
            SSLSocket sock = (SSLSocket)serverSock.accept();
            System.out.println("Server accepted");
            sock.addHandshakeCompletedListener((SSLHandshakeCompletedListener)new HandshakeListener("server", this));
            InputStream is = sock.getInputStream();
            try {
                System.out.println("Server about to read");
                is.read();
                System.out.println("Server read successful");
            }
            catch (EOFException e) {
                System.out.println("Server got EOF");
            }
            sock.close();
            serverSock.close();
        }
        catch (Exception e) {
            SSLClientAuth sSLClientAuth = this;
            synchronized (sSLClientAuth) {
                this.serverReady = true;
                this.setFailure();
                this.notify();
            }
            e.printStackTrace();
        }
        System.out.println("Server exiting");
    }

    static Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE bc = new SEQUENCE();
        bc.addElement((ASN1Value)new BOOLEAN(true));
        OBJECT_IDENTIFIER bcOID = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING enc = new OCTET_STRING(ASN1Util.encode((ASN1Value)bc));
        return new Extension(bcOID, true, enc);
    }

    static int nextRandInt(SecureRandom rand) throws Exception {
        byte[] bytes = new byte[4];
        rand.nextBytes(bytes);
        int i = bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3];
        System.out.println("generated random value:" + i);
        return i;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private SSLClientAuth boss;

        public HandshakeListener(String who, SSLClientAuth boss) {
            this.who = who;
            this.boss = boss;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            try {
                String mesg = this.who + " got a completed handshake ";
                SSLSecurityStatus status = event.getStatus();
                mesg = status.isSecurityOn() ? mesg + "(security is ON)" : mesg + "(security is OFF)";
                System.out.println(mesg);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.boss.setFailure();
            }
        }
    }
}

