/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaElementBindingEnum;
import com.netscape.jndi.ldap.schema.SchemaElementContainer;
import com.netscape.jndi.ldap.schema.SchemaElementNameEnum;
import com.netscape.jndi.ldap.schema.SchemaManager;
import com.netscape.jndi.ldap.schema.SchemaObjectClass;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import netscape.ldap.LDAPObjectClassSchema;

public class SchemaObjectClassContainer
extends SchemaElementContainer {
    public SchemaObjectClassContainer(SchemaManager schemaMgr) throws NamingException {
        super(schemaMgr, "ClassDefinition");
    }

    @Override
    public DirContext createSchemaElement(String name, Attributes attrs) throws NamingException {
        if (name.length() == 0) {
            throw new NamingException("Empty name for schema objectclass");
        }
        LDAPObjectClassSchema objclass = SchemaObjectClass.parseDefAttributes(attrs);
        this.m_schemaMgr.createObjectClass(objclass);
        return new SchemaObjectClass(objclass, this.m_schemaMgr);
    }

    @Override
    public void removeSchemaElement(String name) throws NamingException {
        if (name.length() == 0) {
            throw new NamingException("Can not delete schema object container");
        }
        this.m_schemaMgr.removeObjectClass(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> getNameList(String name) throws NamingException {
        SchemaDirContext schemaObj = (SchemaDirContext)this.lookup(name);
        if (schemaObj == this) {
            return new SchemaElementNameEnum(this.m_schemaMgr.getObjectClassNames());
        }
        throw new NotContextException(name);
    }

    @Override
    public NamingEnumeration<Binding> getBindingsList(String name) throws NamingException {
        SchemaDirContext schemaObj = (SchemaDirContext)this.lookup(name);
        if (schemaObj == this) {
            return new SchemaElementBindingEnum(this.m_schemaMgr.getObjectClasses(), this.m_schemaMgr);
        }
        throw new NotContextException(name);
    }

    @Override
    public Object lookupSchemaElement(String name) throws NamingException {
        if (name.length() == 0) {
            return this;
        }
        LDAPObjectClassSchema objclass = this.m_schemaMgr.getObjectClass(name);
        if (objclass == null) {
            throw new NameNotFoundException(name);
        }
        return new SchemaObjectClass(objclass, this.m_schemaMgr);
    }
}

