/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import netscape.ldap.ber.stream.BERBitString;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERNull;
import netscape.ldap.ber.stream.BERNumericString;
import netscape.ldap.ber.stream.BERObjectId;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERPrintableString;
import netscape.ldap.ber.stream.BERReal;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.ber.stream.BERTagDecoder;
import netscape.ldap.ber.stream.BERUTCTime;
import netscape.ldap.ber.stream.BERVisibleString;

public abstract class BERElement
implements Serializable {
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BITSTRING = 3;
    public static final int OCTETSTRING = 4;
    public static final int NULL = 5;
    public static final int OBJECTID = 6;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int SET = 49;
    public static final int SEQUENCE = 48;
    public static final int NUMERICSTRING = 18;
    public static final int PRINTABLESTRING = 19;
    public static final int TELETEXSTRING = 20;
    public static final int VIDEOTEXSTRING = 21;
    public static final int IA5STRING = 22;
    public static final int UTCTIME = 23;
    public static final int GRAPHICSTRING = 25;
    public static final int VISIBLESTRING = 26;
    public static final int GENERALSTRING = 27;
    public static final int TAG = -1;
    public static final int CHOICE = -2;
    public static final int ANY = -3;
    public static final int EOC = 0;
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int SASLCONTEXT = 160;
    public static final int PRIVATE = 192;
    public static final int PRIMITIVE = 0;
    public static final int CONSTRUCTED = 32;
    public static final int MRA_OID = 1;
    public static final int MRA_TYPE = 2;
    public static final int MRA_VALUE = 3;
    public static final int MRA_DNATTRS = 4;
    public static final int EXOP_REQ_OID = 0;
    public static final int EXOP_REQ_VALUE = 1;
    public static final int EXOP_RES_OID = 10;
    public static final int EXOP_RES_VALUE = 11;
    public static final int SK_MATCHRULE = 0;
    public static final int SK_REVERSE = 1;
    public static final int SR_ATTRTYPE = 0;

    public static BERElement getElement(BERTagDecoder decoder, InputStream stream, int[] bytes_read) throws IOException {
        BERElement element = null;
        int tag = stream.read();
        bytes_read[0] = 1;
        if (tag == 0) {
            stream.read();
            bytes_read[0] = 1;
            element = null;
        } else if (tag == 1) {
            element = new BERBoolean(stream, bytes_read);
        } else if (tag == 2) {
            element = new BERInteger(stream, bytes_read);
        } else if (tag == 3) {
            element = new BERBitString(stream, bytes_read);
        } else if (tag == 35) {
            element = new BERBitString(decoder, stream, bytes_read);
        } else if (tag == 4) {
            element = new BEROctetString(stream, bytes_read);
        } else if (tag == 36) {
            element = new BEROctetString(decoder, stream, bytes_read);
        } else if (tag == 5) {
            element = new BERNull(stream, bytes_read);
        } else if (tag == 6) {
            element = new BERObjectId(stream, bytes_read);
        } else if (tag == 9) {
            element = new BERReal(stream, bytes_read);
        } else if (tag == 10) {
            element = new BEREnumerated(stream, bytes_read);
        } else if (tag == 48) {
            element = new BERSequence(decoder, stream, bytes_read);
        } else if (tag == 49) {
            element = new BERSet(decoder, stream, bytes_read);
        } else if (tag == 18) {
            element = new BERNumericString(stream, bytes_read);
        } else if (tag == 50) {
            element = new BERNumericString(decoder, stream, bytes_read);
        } else if (tag == 19) {
            element = new BERPrintableString(stream, bytes_read);
        } else if (tag == 51) {
            element = new BERPrintableString(decoder, stream, bytes_read);
        } else if (tag == 23) {
            element = new BERUTCTime(stream, bytes_read);
        } else if (tag == 55) {
            element = new BERUTCTime(decoder, stream, bytes_read);
        } else if (tag == 26) {
            element = new BERVisibleString(stream, bytes_read);
        } else if (tag == 58) {
            element = new BERVisibleString(decoder, stream, bytes_read);
        } else if ((tag & 0xC0) > 0) {
            element = new BERTag(decoder, tag, stream, bytes_read);
        } else {
            throw new IOException("invalid tag " + tag);
        }
        return element;
    }

    public static int readLengthOctets(InputStream stream, int[] bytes_read) throws IOException {
        int contents_length = 0;
        int octet = stream.read();
        bytes_read[0] = bytes_read[0] + 1;
        if (octet == 128) {
            contents_length = -1;
        } else if ((octet & 0x80) > 0) {
            int num_length_octets = octet & 0x7F;
            for (int i = 0; i < num_length_octets; ++i) {
                octet = stream.read();
                bytes_read[0] = bytes_read[0] + 1;
                contents_length = (contents_length << 8) + octet;
            }
        } else {
            contents_length = octet;
        }
        return contents_length;
    }

    public static void sendDefiniteLength(OutputStream stream, int num_content_octets) throws IOException {
        boolean bytes_written = false;
        if (num_content_octets <= 127) {
            stream.write(num_content_octets);
        } else {
            int num_length_octets = 0;
            int num = num_content_octets;
            while (num >= 0) {
                ++num_length_octets;
                if ((num >>= 8) > 0) continue;
            }
            byte[] buffer = new byte[num_length_octets + 1];
            buffer[0] = (byte)(0x80 | num_length_octets);
            num = num_content_octets;
            for (int i = num_length_octets; i > 0; --i) {
                buffer[i] = (byte)(num & 0xFF);
                num >>= 8;
            }
            stream.write(buffer);
        }
    }

    protected int readUnsignedBinary(InputStream stream, int[] bytes_read, int length) throws IOException {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            int octet = stream.read();
            bytes_read[0] = bytes_read[0] + 1;
            value = (value << 8) + octet;
        }
        return value;
    }

    protected int readTwosComplement(InputStream stream, int[] bytes_read, int length) throws IOException {
        int value = 0;
        if (length > 0) {
            boolean negative = false;
            int octet = stream.read();
            bytes_read[0] = bytes_read[0] + 1;
            if ((octet & 0x80) > 0) {
                negative = true;
            }
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    octet = stream.read();
                    bytes_read[0] = bytes_read[0] + 1;
                }
                value = negative ? (value << 8) + (octet ^ 0xFF) & 0xFF : (value << 8) + (octet & 0xFF);
            }
            if (negative) {
                value = (value + 1) * -1;
            }
        }
        return value;
    }

    public String byteToHexString(byte value) {
        if (value < 0) {
            return Integer.toHexString((value & 0x7F) + 128);
        }
        return Integer.toHexString(value);
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract int getType();

    public abstract String toString();
}

