/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BERTagDecoder;

public class BERTag
extends BERElement {
    private int m_tag = 0;
    private BERElement m_element = null;
    private boolean m_implicit = false;

    public BERTag(int tag, BERElement element, boolean implicit) {
        this.m_tag = tag;
        this.m_element = element;
        this.m_implicit = implicit;
    }

    public BERTag(BERTagDecoder decoder, int tag, InputStream stream, int[] bytes_read) throws IOException {
        this.m_tag = tag;
        boolean[] implicit = new boolean[1];
        this.m_element = decoder.getElement(decoder, tag, stream, bytes_read, implicit);
        this.m_implicit = implicit[0];
    }

    public BERElement getValue() {
        return this.m_element;
    }

    public void setImplicit(boolean value) {
        this.m_implicit = value;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        stream.write(this.m_tag);
        ByteArrayOutputStream contents_stream = new ByteArrayOutputStream();
        this.m_element.write(contents_stream);
        byte[] contents_buffer = contents_stream.toByteArray();
        if (this.m_implicit) {
            stream.write(contents_buffer, 1, contents_buffer.length - 1);
        } else {
            BERTag.sendDefiniteLength(stream, contents_buffer.length);
            stream.write(contents_buffer);
        }
    }

    @Override
    public int getType() {
        return -1;
    }

    public int getTag() {
        return this.m_tag;
    }

    @Override
    public String toString() {
        Object s = "";
        if ((this.m_tag & 0xC0) == 0) {
            s = (String)s + "UNIVERSAL-";
        } else if ((this.m_tag & 0x80 & (this.m_tag & 0x40)) > 0) {
            s = (String)s + "PRIVATE-";
        } else if ((this.m_tag & 0x40) > 0) {
            s = (String)s + "APPLICATION-";
        } else if ((this.m_tag & 0x80) > 0) {
            s = (String)s + "CONTEXT-";
        }
        return "[" + (String)s + (this.m_tag & 0x1F) + "] " + this.m_element.toString();
    }
}

