/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import netscape.ldap.LDAPResourceBundle;

public class LDAPException
extends Exception
implements Serializable {
    static final long serialVersionUID = -9215007872184847925L;
    public static final int SUCCESS = 0;
    public static final int OPERATION_ERROR = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int TIME_LIMIT_EXCEEDED = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int COMPARE_FALSE = 5;
    public static final int COMPARE_TRUE = 6;
    public static final int AUTH_METHOD_NOT_SUPPORTED = 7;
    public static final int STRONG_AUTH_REQUIRED = 8;
    public static final int LDAP_PARTIAL_RESULTS = 9;
    public static final int REFERRAL = 10;
    public static final int ADMIN_LIMIT_EXCEEDED = 11;
    public static final int UNAVAILABLE_CRITICAL_EXTENSION = 12;
    public static final int CONFIDENTIALITY_REQUIRED = 13;
    public static final int SASL_BIND_IN_PROGRESS = 14;
    public static final int NO_SUCH_ATTRIBUTE = 16;
    public static final int UNDEFINED_ATTRIBUTE_TYPE = 17;
    public static final int INAPPROPRIATE_MATCHING = 18;
    public static final int CONSTRAINT_VIOLATION = 19;
    public static final int ATTRIBUTE_OR_VALUE_EXISTS = 20;
    public static final int INVALID_ATTRIBUTE_SYNTAX = 21;
    public static final int NO_SUCH_OBJECT = 32;
    public static final int ALIAS_PROBLEM = 33;
    public static final int INVALID_DN_SYNTAX = 34;
    public static final int IS_LEAF = 35;
    public static final int ALIAS_DEREFERENCING_PROBLEM = 36;
    public static final int INAPPROPRIATE_AUTHENTICATION = 48;
    public static final int INVALID_CREDENTIALS = 49;
    public static final int INSUFFICIENT_ACCESS_RIGHTS = 50;
    public static final int BUSY = 51;
    public static final int UNAVAILABLE = 52;
    public static final int UNWILLING_TO_PERFORM = 53;
    public static final int LOOP_DETECT = 54;
    public static final int SORT_CONTROL_MISSING = 60;
    public static final int INDEX_RANGE_ERROR = 61;
    public static final int NAMING_VIOLATION = 64;
    public static final int OBJECT_CLASS_VIOLATION = 65;
    public static final int NOT_ALLOWED_ON_NONLEAF = 66;
    public static final int NOT_ALLOWED_ON_RDN = 67;
    public static final int ENTRY_ALREADY_EXISTS = 68;
    public static final int OBJECT_CLASS_MODS_PROHIBITED = 69;
    public static final int AFFECTS_MULTIPLE_DSAS = 71;
    public static final int OTHER = 80;
    public static final int SERVER_DOWN = 81;
    public static final int LDAP_TIMEOUT = 85;
    public static final int PARAM_ERROR = 89;
    public static final int CONNECT_ERROR = 91;
    public static final int LDAP_NOT_SUPPORTED = 92;
    public static final int CONTROL_NOT_FOUND = 93;
    public static final int NO_RESULTS_RETURNED = 94;
    public static final int MORE_RESULTS_TO_RETURN = 95;
    public static final int CLIENT_LOOP = 96;
    public static final int REFERRAL_LIMIT_EXCEEDED = 97;
    public static final int TLS_NOT_SUPPORTED = 112;
    private int resultCode = -1;
    private String errorMessage = null;
    private String extraMessage = null;
    private String matchedDN = null;
    private Locale m_locale = Locale.getDefault();
    private static Hashtable<String, PropertyResourceBundle> cacheResource = new Hashtable();
    private static final String baseName = "netscape/ldap/errors/ErrorCodes";

    public LDAPException() {
    }

    public LDAPException(String message) {
        super(message);
    }

    public LDAPException(String message, int resultCode) {
        super(message);
        this.resultCode = resultCode;
    }

    public LDAPException(String message, int resultCode, String serverErrorMessage) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = serverErrorMessage;
    }

    public LDAPException(String message, int resultCode, String serverErrorMessage, String matchedDN) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = serverErrorMessage;
        this.matchedDN = matchedDN;
    }

    public int getLDAPResultCode() {
        return this.resultCode;
    }

    public String getLDAPErrorMessage() {
        return this.errorMessage;
    }

    void setExtraMessage(String msg) {
        this.extraMessage = this.extraMessage == null ? msg : this.extraMessage + "; " + msg;
    }

    public String getMatchedDN() {
        return this.matchedDN;
    }

    @Override
    public String toString() {
        String str = super.toString() + " (" + this.resultCode + ")";
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            str = str + "; " + this.errorMessage;
        }
        if (this.matchedDN != null && this.matchedDN.length() > 0) {
            str = str + "; matchedDN = " + this.matchedDN;
        }
        if (this.extraMessage != null) {
            str = str + "; " + this.extraMessage;
        }
        return str;
    }

    public String errorCodeToString() {
        return LDAPException.errorCodeToString(this.resultCode, this.m_locale);
    }

    public String errorCodeToString(Locale l) {
        return LDAPException.errorCodeToString(this.resultCode, l);
    }

    public static String errorCodeToString(int code) {
        return LDAPException.errorCodeToString(code, Locale.getDefault());
    }

    public static synchronized String errorCodeToString(int code, Locale locale) {
        try {
            String localeStr = locale.toString();
            PropertyResourceBundle p = cacheResource.get(localeStr);
            if (p == null && (p = LDAPResourceBundle.getBundle(baseName)) != null) {
                cacheResource.put(localeStr, p);
            }
            if (p != null) {
                return (String)p.handleGetObject(Integer.toString(code));
            }
        }
        catch (IOException e) {
            System.out.println("Cannot open resource file for LDAPException netscape/ldap/errors/ErrorCodes");
        }
        return null;
    }
}

